/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRippler;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.skins.JFXTabPaneSkin$$Lambda$1;
import com.jfoenix.skins.JFXTabPaneSkin$$Lambda$2;
import com.jfoenix.skins.JFXTabPaneSkin$$Lambda$3;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderContainer$$Lambda$1;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderContainer$$Lambda$2;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderControl$$Lambda$1;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderControl$$Lambda$2;
import com.jfoenix.skins.JFXTabPaneSkin$HeaderControl$$Lambda$3;
import com.jfoenix.skins.JFXTabPaneSkin$TabContentHolder$$Lambda$1;
import com.jfoenix.skins.JFXTabPaneSkin$TabContentHolder$$Lambda$2;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$1;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$2;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$3;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$4;
import com.jfoenix.skins.JFXTabPaneSkin$TabHeaderContainer$$Lambda$5;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.transitions.CachedTransition;
import com.sun.javafx.scene.control.MultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TabPaneBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.Duration;

public class JFXTabPaneSkin
extends BehaviorSkinBase<TabPane, TabPaneBehavior> {
    private Color defaultColor = Color.valueOf((String)"#00BCD4");
    private Color ripplerColor = Color.valueOf((String)"FFFF8D");
    private Color selectedTabText = Color.WHITE;
    private Color tempLabelColor = Color.WHITE;
    private HeaderContainer headerContainer;
    private ObservableList<TabContentHolder> tabContentHolders = FXCollections.observableArrayList();
    private Rectangle tabPaneClip;
    private Rectangle headerContainerClip;
    private Tab selectedTab;
    private boolean isSelectingTab = false;
    private double dragStart;
    private double offsetStart;
    private AnchorPane tabsContainer;
    private AnchorPane tabsContainerHolder;
    private static final int SPACER = 10;
    private double maxWidth = 0.0;
    private double maxHeight = 0.0;
    private int diffTabsIndices = 0;
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"disabled");

    public JFXTabPaneSkin(TabPane tabPane) {
        super((Control)tabPane, (BehaviorBase)new TabPaneBehavior(tabPane));
        this.headerContainer = new HeaderContainer();
        this.getChildren().add((Object)this.headerContainer);
        JFXDepthManager.setDepth((Node)this.headerContainer, 1);
        this.tabsContainer = new AnchorPane();
        this.tabsContainerHolder = new AnchorPane();
        this.tabsContainerHolder.getChildren().add((Object)this.tabsContainer);
        this.getChildren().add((Object)this.tabsContainerHolder);
        for (Tab tab : ((TabPane)this.getSkinnable()).getTabs()) {
            this.addTabContentHolder(tab);
        }
        this.tabPaneClip = new Rectangle(tabPane.getWidth(), tabPane.getHeight());
        ((TabPane)this.getSkinnable()).setClip((Node)this.tabPaneClip);
        this.headerContainerClip = new Rectangle();
        this.headerContainer.setClip((Node)this.headerContainerClip);
        if (((TabPane)this.getSkinnable()).getTabs().size() == 0) {
            this.headerContainer.setVisible(false);
        }
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        if (this.selectedTab == null && ((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex() != -1) {
            ((TabPane)this.getSkinnable()).getSelectionModel().select(((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex());
            this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        }
        if (this.selectedTab == null) {
            ((TabPane)this.getSkinnable()).getSelectionModel().selectFirst();
        }
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        this.headerContainer.headersRegion.setOnMouseDragged(JFXTabPaneSkin$$Lambda$1.lambdaFactory$(this));
        ((TabPane)this.getSkinnable()).setOnMousePressed(JFXTabPaneSkin$$Lambda$2.lambdaFactory$(this));
        ((TabPane)this.getSkinnable()).getTabs().addListener(JFXTabPaneSkin$$Lambda$3.lambdaFactory$(this));
        this.registerChangeListener((ObservableValue)tabPane.getSelectionModel().selectedItemProperty(), "SELECTED_TAB");
        this.registerChangeListener((ObservableValue)tabPane.widthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)tabPane.heightProperty(), "HEIGHT");
    }

    protected void handleControlPropertyChanged(String property) {
        super.handleControlPropertyChanged(property);
        if ("SELECTED_TAB".equals(property)) {
            this.isSelectingTab = true;
            this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
            ((TabPane)this.getSkinnable()).requestLayout();
        } else if ("WIDTH".equals(property)) {
            this.tabPaneClip.setWidth(((TabPane)this.getSkinnable()).getWidth());
        } else if ("HEIGHT".equals(property)) {
            this.tabPaneClip.setHeight(((TabPane)this.getSkinnable()).getHeight());
        }
    }

    private void removeTabs(List<? extends Tab> removedTabs) {
        for (Tab tab : removedTabs) {
            TabHeaderContainer tabHeaderContainer = this.headerContainer.getTabHeaderContainer(tab);
            if (tabHeaderContainer == null) continue;
            tabHeaderContainer.isClosing = true;
            this.removeTab(tab);
            if (!((TabPane)this.getSkinnable()).getTabs().isEmpty()) continue;
            this.headerContainer.setVisible(false);
        }
    }

    private void addTabs(List<? extends Tab> addedTabs, int startIndex) {
        int i = 0;
        for (Tab tab : addedTabs) {
            if (!this.headerContainer.isVisible()) {
                this.headerContainer.setVisible(true);
            }
            this.headerContainer.addTab(tab, startIndex + i++, false);
            this.addTabContentHolder(tab);
            TabHeaderContainer tabHeaderContainer = this.headerContainer.getTabHeaderContainer(tab);
            if (tabHeaderContainer == null) continue;
            tabHeaderContainer.setVisible(true);
            tabHeaderContainer.inner.requestLayout();
        }
    }

    private void addTabContentHolder(Tab tab) {
        TabContentHolder tabContentHolder = new TabContentHolder(tab);
        tabContentHolder.setClip((Node)new Rectangle());
        this.tabContentHolders.add((Object)tabContentHolder);
        this.tabsContainer.getChildren().add(0, (Object)tabContentHolder);
    }

    private void removeTabContentHolder(Tab tab) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            if (!tabContentHolder.tab.equals(tab)) continue;
            tabContentHolder.removeListeners(tab);
            this.getChildren().remove((Object)tabContentHolder);
            this.tabContentHolders.remove((Object)tabContentHolder);
            this.tabsContainer.getChildren().remove((Object)tabContentHolder);
            break;
        }
    }

    private void removeTab(Tab tab) {
        TabHeaderContainer tabHeaderContainer = this.headerContainer.getTabHeaderContainer(tab);
        if (tabHeaderContainer != null) {
            tabHeaderContainer.removeListeners(tab);
        }
        this.headerContainer.removeTab(tab);
        this.removeTabContentHolder(tab);
        this.headerContainer.requestLayout();
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            this.maxWidth = Math.max(this.maxWidth, this.snapSize(tabContentHolder.prefWidth(-1.0)));
        }
        double headerContainerWidth = this.snapSize(this.headerContainer.prefWidth(-1.0));
        double prefWidth = Math.max(this.maxWidth, headerContainerWidth);
        return this.snapSize(prefWidth) + rightInset + leftInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            this.maxHeight = Math.max(this.maxHeight, this.snapSize(tabContentHolder.prefHeight(-1.0)));
        }
        double headerContainerHeight = this.snapSize(this.headerContainer.prefHeight(-1.0));
        double prefHeight = this.maxHeight + this.snapSize(headerContainerHeight);
        return this.snapSize(prefHeight) + topInset + bottomInset;
    }

    public double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.headerContainer.getBaselineOffset() + topInset;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double headerHeight = this.snapSize(this.headerContainer.prefHeight(-1.0));
        this.headerContainer.resize(w, headerHeight);
        this.headerContainer.relocate(x, y);
        this.headerContainerClip.setX(0.0);
        this.headerContainerClip.setY(0.0);
        this.headerContainerClip.setWidth(w);
        this.headerContainerClip.setHeight(headerHeight + 10.0);
        double contentStartX = 0.0;
        double contentStartY = 0.0;
        contentStartX = x;
        contentStartY = y + headerHeight;
        double contentWidth = w - 0.0;
        double contentHeight = h - headerHeight;
        Rectangle clip = new Rectangle(contentWidth, contentHeight);
        this.tabsContainerHolder.setClip((Node)clip);
        this.tabsContainerHolder.resize(contentWidth, contentHeight);
        this.tabsContainerHolder.relocate(contentStartX, contentStartY);
        this.tabsContainer.resize(contentWidth * (double)this.tabContentHolders.size(), contentHeight);
        int max = this.tabContentHolders.size();
        for (int i = 0; i < max; ++i) {
            TabContentHolder tabContentHolder = (TabContentHolder)((Object)this.tabContentHolders.get(i));
            tabContentHolder.setVisible(true);
            tabContentHolder.setTranslateX(contentWidth * (double)i);
            if (tabContentHolder.getClip() != null) {
                ((Rectangle)tabContentHolder.getClip()).setWidth(contentWidth);
                ((Rectangle)tabContentHolder.getClip()).setHeight(contentHeight);
            }
            if (tabContentHolder.tab == this.selectedTab) {
                int index = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)this.selectedTab);
                if (index != i) {
                    this.tabsContainer.setTranslateX(-contentWidth * (double)i);
                    this.diffTabsIndices = i - index;
                } else {
                    if (this.diffTabsIndices != 0) {
                        this.tabsContainer.setTranslateX(this.tabsContainer.getTranslateX() + contentWidth * (double)this.diffTabsIndices);
                        this.diffTabsIndices = 0;
                    }
                    if (this.isSelectingTab) {
                        new CachedTransition((Node)this.tabsContainer, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.tabsContainer.translateXProperty(), (Object)(-contentWidth * (double)index), Interpolator.EASE_BOTH)})})){
                            {
                                this.setCycleDuration(Duration.seconds((double)0.32));
                                this.setDelay(Duration.seconds((double)0.0));
                            }
                        }.play();
                    } else {
                        this.tabsContainer.setTranslateX(-contentWidth * (double)index);
                    }
                }
            }
            tabContentHolder.resize(contentWidth, contentHeight);
        }
    }

    private /* synthetic */ void lambda$new$430(ListChangeListener.Change change) {
        ArrayList tabsToBeRemoved = new ArrayList();
        ArrayList tabsToBeAdded = new ArrayList();
        int insertIndex = -1;
        while (change.next()) {
            if (change.wasPermutated()) {
                Tab selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
                ArrayList<Object> permutatedTabs = new ArrayList<Object>(change.getTo() - change.getFrom());
                ((TabPane)this.getSkinnable()).getSelectionModel().clearSelection();
                for (int i = change.getFrom(); i < change.getTo(); ++i) {
                    permutatedTabs.add(((TabPane)this.getSkinnable()).getTabs().get(i));
                }
                this.removeTabs(permutatedTabs);
                this.addTabs(permutatedTabs, change.getFrom());
                ((TabPane)this.getSkinnable()).getSelectionModel().select((Object)selectedTab);
            }
            if (change.wasRemoved()) {
                tabsToBeRemoved.addAll(change.getRemoved());
            }
            if (!change.wasAdded()) continue;
            tabsToBeAdded.addAll(change.getAddedSubList());
            insertIndex = change.getFrom();
        }
        tabsToBeRemoved.removeAll(tabsToBeAdded);
        this.removeTabs(tabsToBeRemoved);
        if (!tabsToBeAdded.isEmpty()) {
            for (TabContentHolder tabContentHolder : this.tabContentHolders) {
                TabHeaderContainer tabHeaderContainer = this.headerContainer.getTabHeaderContainer(tabContentHolder.tab);
                if (tabHeaderContainer.isClosing || !tabsToBeAdded.contains(tabContentHolder.tab)) continue;
                tabsToBeAdded.remove(tabContentHolder.tab);
            }
            this.addTabs(tabsToBeAdded, insertIndex == -1 ? this.tabContentHolders.size() : insertIndex);
        }
        ((TabPane)this.getSkinnable()).requestLayout();
    }

    private /* synthetic */ void lambda$new$429(MouseEvent me) {
        this.dragStart = me.getSceneX();
        this.offsetStart = this.headerContainer.scrollOffset;
    }

    private /* synthetic */ void lambda$new$428(MouseEvent me) {
        this.headerContainer.updateScrollOffset(this.offsetStart + me.getSceneX() - this.dragStart);
    }

    static /* synthetic */ void access$lambda$0(JFXTabPaneSkin jFXTabPaneSkin, MouseEvent mouseEvent) {
        jFXTabPaneSkin.lambda$new$428(mouseEvent);
    }

    static /* synthetic */ void access$lambda$1(JFXTabPaneSkin jFXTabPaneSkin, MouseEvent mouseEvent) {
        jFXTabPaneSkin.lambda$new$429(mouseEvent);
    }

    static /* synthetic */ void access$lambda$2(JFXTabPaneSkin jFXTabPaneSkin, ListChangeListener.Change change) {
        jFXTabPaneSkin.lambda$new$430(change);
    }

    protected class HeaderControl
    extends StackPane {
        private StackPane inner;
        private boolean showControlButtons;
        private boolean isLeftArrow;
        private Timeline arrowAnimation;
        private SVGGlyph arrowButton;
        private SVGGlyph leftChevron = new SVGGlyph(0, "CHEVRON_LEFT", "M 742,-37 90,614 Q 53,651 53,704.5 53,758 90,795 l 652,651 q 37,37 90.5,37 53.5,0 90.5,-37 l 75,-75 q 37,-37 37,-90.5 0,-53.5 -37,-90.5 L 512,704 998,219 q 37,-38 37,-91 0,-53 -37,-90 L 923,-37 Q 886,-74 832.5,-74 779,-74 742,-37 z", (Paint)Color.WHITE);
        private SVGGlyph rightChevron = new SVGGlyph(0, "CHEVRON_RIGHT", "m 1099,704 q 0,-52 -37,-91 L 410,-38 q -37,-37 -90,-37 -53,0 -90,37 l -76,75 q -37,39 -37,91 0,53 37,90 l 486,486 -486,485 q -37,39 -37,91 0,53 37,90 l 76,75 q 36,38 90,38 54,0 90,-38 l 652,-651 q 37,-37 37,-90 z", (Paint)Color.WHITE);
        private boolean showTabsHeaderControls = false;

        public HeaderControl(ArrowPosition pos) {
            this.getStyleClass().setAll((Object[])new String[]{"control-buttons-tab"});
            this.isLeftArrow = pos == ArrowPosition.LEFT;
            this.arrowButton = this.isLeftArrow ? this.leftChevron : this.rightChevron;
            this.arrowButton.setStyle("-fx-min-width:0.8em;-fx-max-width:0.8em;-fx-min-height:1.3em;-fx-max-height:1.3em;");
            this.arrowButton.getStyleClass().setAll((Object[])new String[]{"tab-down-button"});
            this.arrowButton.setVisible(this.isControlButtonShown());
            this.arrowButton.setFill((Paint)JFXTabPaneSkin.this.selectedTabText);
            SimpleDoubleProperty offsetProperty = new SimpleDoubleProperty(0.0);
            offsetProperty.addListener(JFXTabPaneSkin$HeaderControl$$Lambda$1.lambdaFactory$(this));
            StackPane container = new StackPane(new Node[]{this.arrowButton});
            container.getStyleClass().add((Object)"container");
            container.setPadding(new Insets(7.0));
            container.setCursor(Cursor.HAND);
            container.setOnMousePressed(JFXTabPaneSkin$HeaderControl$$Lambda$2.lambdaFactory$(this, (DoubleProperty)offsetProperty));
            container.setOnMouseReleased(JFXTabPaneSkin$HeaderControl$$Lambda$3.lambdaFactory$(this));
            final JFXRippler arrowRippler = new JFXRippler((Node)container, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK);
            arrowRippler.ripplerFillProperty().bind(this.arrowButton.fillProperty());
            StackPane.setMargin((Node)this.arrowButton, (Insets)new Insets(0.0, 0.0, 0.0, this.isLeftArrow ? -4.0 : 4.0));
            this.inner = new StackPane(){

                protected double computePrefWidth(double height) {
                    double preferWidth = 0.0;
                    double maxArrowWidth = !HeaderControl.this.isControlButtonShown() ? 0.0 : this.snapSize(arrowRippler.prefWidth(this.getHeight()));
                    return preferWidth += (preferWidth += HeaderControl.this.isControlButtonShown() ? maxArrowWidth : 0.0) > 0.0 ? this.snappedLeftInset() + this.snappedRightInset() : 0.0;
                }

                protected double computePrefHeight(double width) {
                    double prefHeight = 0.0;
                    prefHeight = HeaderControl.this.isControlButtonShown() ? Math.max(prefHeight, this.snapSize(arrowRippler.prefHeight(width))) : 0.0;
                    return prefHeight += prefHeight > 0.0 ? this.snappedTopInset() + this.snappedBottomInset() : 0.0;
                }

                protected void layoutChildren() {
                    if (HeaderControl.this.isControlButtonShown()) {
                        double x = 0.0;
                        double y = this.snappedTopInset();
                        double width = this.snapSize(this.getWidth()) - x + this.snappedLeftInset();
                        double height = this.snapSize(this.getHeight()) - y + this.snappedBottomInset();
                        this.positionArrow(arrowRippler, x, y, width, height);
                    }
                }

                private void positionArrow(JFXRippler rippler, double x, double y, double width, double height) {
                    rippler.resize(width, height);
                    this.positionInArea((Node)rippler, x, y, width, height, 0.0, HPos.CENTER, VPos.CENTER);
                }
            };
            arrowRippler.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
            this.inner.getChildren().add((Object)arrowRippler);
            StackPane.setMargin((Node)arrowRippler, (Insets)new Insets(0.0, 4.0, 0.0, 4.0));
            this.getChildren().add((Object)this.inner);
            this.showControlButtons = false;
            if (this.isControlButtonShown()) {
                this.showControlButtons = true;
                this.requestLayout();
            }
        }

        private void showTabsMenu(boolean value) {
            boolean wasTabsMenuShowing = this.isControlButtonShown();
            this.showTabsHeaderControls = value;
            if (this.showTabsHeaderControls && !wasTabsMenuShowing) {
                this.arrowButton.setVisible(true);
                this.showControlButtons = true;
                this.inner.requestLayout();
                JFXTabPaneSkin.this.headerContainer.requestLayout();
            } else if (!this.showTabsHeaderControls && wasTabsMenuShowing) {
                if (this.isControlButtonShown()) {
                    this.showControlButtons = true;
                } else {
                    this.setVisible(false);
                }
                this.requestLayout();
            }
        }

        private boolean isControlButtonShown() {
            return this.showTabsHeaderControls;
        }

        protected double computePrefWidth(double height) {
            double prefWidth = this.snapSize(this.inner.prefWidth(height));
            if (prefWidth > 0.0) {
                prefWidth += this.snappedLeftInset() + this.snappedRightInset();
            }
            return prefWidth;
        }

        protected double computePrefHeight(double width) {
            return Math.max(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMinHeight(), this.snapSize(this.inner.prefHeight(width))) + this.snappedTopInset() + this.snappedBottomInset();
        }

        protected void layoutChildren() {
            double x = this.snappedLeftInset();
            double y = this.snappedTopInset();
            double width = this.snapSize(this.getWidth()) - x + this.snappedRightInset();
            double height = this.snapSize(this.getHeight()) - y + this.snappedBottomInset();
            if (this.showControlButtons) {
                this.setVisible(true);
                this.showControlButtons = false;
            }
            this.inner.resize(width, height);
            this.positionInArea((Node)this.inner, x, y, width, height, 0.0, HPos.CENTER, VPos.BOTTOM);
        }

        private /* synthetic */ void lambda$new$442(MouseEvent release) {
            this.arrowAnimation.stop();
        }

        private /* synthetic */ void lambda$new$441(DoubleProperty offsetProperty, MouseEvent press) {
            offsetProperty.set(JFXTabPaneSkin.this.headerContainer.scrollOffset);
            double offset = this.isLeftArrow ? JFXTabPaneSkin.this.headerContainer.scrollOffset + JFXTabPaneSkin.this.headerContainer.headersRegion.getWidth() : JFXTabPaneSkin.this.headerContainer.scrollOffset - JFXTabPaneSkin.this.headerContainer.headersRegion.getWidth();
            this.arrowAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{new KeyValue((WritableValue)offsetProperty, (Object)offset, Interpolator.LINEAR)})});
            this.arrowAnimation.play();
        }

        private /* synthetic */ void lambda$new$440(ObservableValue o, Number oldVal, Number newVal) {
            JFXTabPaneSkin.this.headerContainer.updateScrollOffset(newVal.doubleValue());
        }

        static /* synthetic */ void access$lambda$0(HeaderControl headerControl, ObservableValue observableValue, Number number, Number number2) {
            headerControl.lambda$new$440(observableValue, number, number2);
        }

        static /* synthetic */ void access$lambda$1(HeaderControl headerControl, DoubleProperty doubleProperty, MouseEvent mouseEvent) {
            headerControl.lambda$new$441(doubleProperty, mouseEvent);
        }

        static /* synthetic */ void access$lambda$2(HeaderControl headerControl, MouseEvent mouseEvent) {
            headerControl.lambda$new$442(mouseEvent);
        }
    }

    private static enum ArrowPosition {
        RIGHT,
        LEFT;

    }

    protected class TabContentHolder
    extends StackPane {
        private Tab tab;
        private InvalidationListener tabContentListener = JFXTabPaneSkin$TabContentHolder$$Lambda$1.lambdaFactory$(this);
        private InvalidationListener tabSelectedListener = JFXTabPaneSkin$TabContentHolder$$Lambda$2.lambdaFactory$(this);
        private WeakInvalidationListener weakTabContentListener = new WeakInvalidationListener(this.tabContentListener);
        private WeakInvalidationListener weakTabSelectedListener = new WeakInvalidationListener(this.tabSelectedListener);

        public TabContentHolder(Tab tab) {
            this.tab = tab;
            this.getStyleClass().setAll((Object[])new String[]{"tab-content-area"});
            this.setManaged(false);
            this.updateContent();
            this.setVisible(tab.isSelected());
            tab.selectedProperty().addListener((InvalidationListener)this.weakTabSelectedListener);
            tab.contentProperty().addListener((InvalidationListener)this.weakTabContentListener);
        }

        private void updateContent() {
            Node newContent = this.tab.getContent();
            if (newContent == null) {
                this.getChildren().clear();
            } else {
                this.getChildren().setAll((Object[])new Node[]{newContent});
            }
        }

        private void removeListeners(Tab tab) {
            tab.selectedProperty().removeListener((InvalidationListener)this.weakTabSelectedListener);
            tab.contentProperty().removeListener((InvalidationListener)this.weakTabContentListener);
        }

        private /* synthetic */ void lambda$new$439(Observable valueModel) {
            this.setVisible(this.tab.isSelected());
        }

        private /* synthetic */ void lambda$new$438(Observable valueModel) {
            this.updateContent();
        }

        static /* synthetic */ void access$lambda$0(TabContentHolder tabContentHolder, Observable observable) {
            tabContentHolder.lambda$new$438(observable);
        }

        static /* synthetic */ void access$lambda$1(TabContentHolder tabContentHolder, Observable observable) {
            tabContentHolder.lambda$new$439(observable);
        }
    }

    protected class TabHeaderContainer
    extends StackPane {
        private Tab tab = null;
        private Label tabText;
        private Tooltip oldTooltip;
        private Tooltip tooltip;
        private BorderPane inner;
        private JFXRippler rippler;
        private boolean systemChange = false;
        private boolean isClosing = false;
        private MultiplePropertyChangeListenerHandler listener = new MultiplePropertyChangeListenerHandler(JFXTabPaneSkin$TabHeaderContainer$$Lambda$1.lambdaFactory$(this));
        private final ListChangeListener<String> styleClassListener = JFXTabPaneSkin$TabHeaderContainer$$Lambda$2.lambdaFactory$(this);
        private final WeakListChangeListener<String> weakStyleClassListener = new WeakListChangeListener(this.styleClassListener);

        public TabHeaderContainer(Tab tab) {
            this.tab = tab;
            this.getStyleClass().setAll((Collection)tab.getStyleClass());
            this.setId(tab.getId());
            this.setStyle(tab.getStyle());
            this.tabText = new Label(tab.getText(), tab.getGraphic());
            this.tabText.setFont(Font.font((String)"", (FontWeight)FontWeight.BOLD, (double)16.0));
            this.tabText.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
            this.tabText.getStyleClass().setAll((Object[])new String[]{"tab-label"});
            this.inner = new BorderPane();
            this.inner.setCenter((Node)this.tabText);
            this.inner.getStyleClass().add((Object)"tab-container");
            this.rippler = new JFXRippler((Node)this.inner, JFXRippler.RipplerPos.FRONT);
            this.rippler.setRipplerFill((Paint)JFXTabPaneSkin.this.ripplerColor);
            this.getChildren().addAll((Object[])new Node[]{this.rippler});
            this.tooltip = tab.getTooltip();
            if (this.tooltip != null) {
                Tooltip.install((Node)this, (Tooltip)this.tooltip);
                this.oldTooltip = this.tooltip;
            }
            if (tab.isSelected()) {
                this.tabText.setTextFill((Paint)JFXTabPaneSkin.this.selectedTabText);
            } else {
                this.tabText.setTextFill((Paint)JFXTabPaneSkin.this.tempLabelColor.deriveColor(0.0, 0.0, 0.9, 1.0));
            }
            this.tabText.textFillProperty().addListener(JFXTabPaneSkin$TabHeaderContainer$$Lambda$3.lambdaFactory$(this));
            tab.selectedProperty().addListener(JFXTabPaneSkin$TabHeaderContainer$$Lambda$4.lambdaFactory$(this));
            this.listener.registerChangeListener((ObservableValue)tab.selectedProperty(), "SELECTED");
            this.listener.registerChangeListener((ObservableValue)tab.textProperty(), "TEXT");
            this.listener.registerChangeListener((ObservableValue)tab.graphicProperty(), "GRAPHIC");
            this.listener.registerChangeListener((ObservableValue)tab.tooltipProperty(), "TOOLTIP");
            this.listener.registerChangeListener((ObservableValue)tab.disableProperty(), "DISABLE");
            this.listener.registerChangeListener((ObservableValue)tab.styleProperty(), "STYLE");
            this.listener.registerChangeListener((ObservableValue)((TabPane)JFXTabPaneSkin.this.getSkinnable()).tabMinWidthProperty(), "TAB_MIN_WIDTH");
            this.listener.registerChangeListener((ObservableValue)((TabPane)JFXTabPaneSkin.this.getSkinnable()).tabMaxWidthProperty(), "TAB_MAX_WIDTH");
            this.listener.registerChangeListener((ObservableValue)((TabPane)JFXTabPaneSkin.this.getSkinnable()).tabMinHeightProperty(), "TAB_MIN_HEIGHT");
            this.listener.registerChangeListener((ObservableValue)((TabPane)JFXTabPaneSkin.this.getSkinnable()).tabMaxHeightProperty(), "TAB_MAX_HEIGHT");
            tab.getStyleClass().addListener(this.weakStyleClassListener);
            this.getProperties().put(Tab.class, (Object)tab);
            this.setOnMouseClicked(JFXTabPaneSkin$TabHeaderContainer$$Lambda$5.lambdaFactory$(this, tab));
            this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, tab.isSelected());
            this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, tab.isDisable());
        }

        private void handlePropertyChanged(String p) {
            if ("SELECTED".equals(p)) {
                this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, this.tab.isSelected());
                this.inner.requestLayout();
                this.requestLayout();
            } else if ("TEXT".equals(p)) {
                this.tabText.setText(this.tab.getText());
            } else if ("GRAPHIC".equals(p)) {
                this.tabText.setGraphic(this.tab.getGraphic());
            } else if ("TOOLTIP".equals(p)) {
                if (this.oldTooltip != null) {
                    Tooltip.uninstall((Node)this, (Tooltip)this.oldTooltip);
                }
                this.tooltip = this.tab.getTooltip();
                if (this.tooltip != null) {
                    Tooltip.install((Node)this, (Tooltip)this.tooltip);
                    this.oldTooltip = this.tooltip;
                }
            } else if ("DISABLE".equals(p)) {
                this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, this.tab.isDisable());
                this.inner.requestLayout();
                this.requestLayout();
            } else if ("STYLE".equals(p)) {
                this.setStyle(this.tab.getStyle());
            } else if ("TAB_MIN_WIDTH".equals(p)) {
                this.requestLayout();
                ((TabPane)JFXTabPaneSkin.this.getSkinnable()).requestLayout();
            } else if ("TAB_MAX_WIDTH".equals(p)) {
                this.requestLayout();
                ((TabPane)JFXTabPaneSkin.this.getSkinnable()).requestLayout();
            } else if ("TAB_MIN_HEIGHT".equals(p)) {
                this.requestLayout();
                ((TabPane)JFXTabPaneSkin.this.getSkinnable()).requestLayout();
            } else if ("TAB_MAX_HEIGHT".equals(p)) {
                this.requestLayout();
                ((TabPane)JFXTabPaneSkin.this.getSkinnable()).requestLayout();
            }
        }

        private void removeListeners(Tab tab) {
            this.listener.dispose();
            this.inner.getChildren().clear();
            this.getChildren().clear();
        }

        protected double computePrefWidth(double height) {
            double minWidth = this.snapSize(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMinWidth());
            double maxWidth = this.snapSize(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMaxWidth());
            double paddingRight = this.snappedRightInset();
            double paddingLeft = this.snappedLeftInset();
            double tmpPrefWidth = this.snapSize(this.tabText.prefWidth(-1.0));
            if (tmpPrefWidth > maxWidth) {
                tmpPrefWidth = maxWidth;
            } else if (tmpPrefWidth < minWidth) {
                tmpPrefWidth = minWidth;
            }
            return tmpPrefWidth += paddingRight + paddingLeft;
        }

        protected double computePrefHeight(double width) {
            double minHeight = this.snapSize(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMinHeight());
            double maxHeight = this.snapSize(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMaxHeight());
            double paddingTop = this.snappedTopInset();
            double paddingBottom = this.snappedBottomInset();
            double tmpPrefHeight = this.snapSize(this.tabText.prefHeight(width));
            if (tmpPrefHeight > maxHeight) {
                tmpPrefHeight = maxHeight;
            } else if (tmpPrefHeight < minHeight) {
                tmpPrefHeight = minHeight;
            }
            return tmpPrefHeight += paddingTop + paddingBottom;
        }

        protected void layoutChildren() {
            double w = this.snapSize(this.getWidth()) - this.snappedRightInset() - this.snappedLeftInset();
            this.rippler.resize(w, this.snapSize(this.getHeight()) - this.snappedTopInset() - this.snappedBottomInset());
            this.rippler.relocate(this.snappedLeftInset(), this.snappedTopInset());
        }

        protected void setWidth(double value) {
            super.setWidth(value);
        }

        protected void setHeight(double value) {
            super.setHeight(value);
        }

        private /* synthetic */ void lambda$new$437(Tab tab, MouseEvent event) {
            if (tab.isDisable()) {
                return;
            }
            this.setOpacity(1.0);
            ((TabPaneBehavior)JFXTabPaneSkin.this.getBehavior()).selectTab(tab);
        }

        private /* synthetic */ void lambda$new$436(ObservableValue o, Boolean oldVal, Boolean newVal) {
            this.systemChange = true;
            if (newVal.booleanValue()) {
                this.tabText.setTextFill((Paint)JFXTabPaneSkin.this.tempLabelColor);
            } else {
                this.tabText.setTextFill((Paint)JFXTabPaneSkin.this.tempLabelColor.deriveColor(0.0, 0.0, 0.9, 1.0));
            }
            this.systemChange = false;
        }

        private /* synthetic */ void lambda$new$435(ObservableValue o, Paint oldVal, Paint newVal) {
            if (!this.systemChange) {
                JFXTabPaneSkin.this.tempLabelColor = (Color)newVal;
            }
        }

        private /* synthetic */ void lambda$new$434(ListChangeListener.Change change) {
            this.getStyleClass().setAll((Collection)this.tab.getStyleClass());
        }

        private /* synthetic */ Void lambda$new$433(String param) {
            this.handlePropertyChanged(param);
            return null;
        }

        static /* synthetic */ Void access$lambda$0(TabHeaderContainer tabHeaderContainer, String string) {
            return tabHeaderContainer.lambda$new$433(string);
        }

        static /* synthetic */ void access$lambda$1(TabHeaderContainer tabHeaderContainer, ListChangeListener.Change change) {
            tabHeaderContainer.lambda$new$434(change);
        }

        static /* synthetic */ void access$lambda$2(TabHeaderContainer tabHeaderContainer, ObservableValue observableValue, Paint paint, Paint paint2) {
            tabHeaderContainer.lambda$new$435(observableValue, paint, paint2);
        }

        static /* synthetic */ void access$lambda$3(TabHeaderContainer tabHeaderContainer, ObservableValue observableValue, Boolean bl, Boolean bl2) {
            tabHeaderContainer.lambda$new$436(observableValue, bl, bl2);
        }

        static /* synthetic */ void access$lambda$4(TabHeaderContainer tabHeaderContainer, Tab tab, MouseEvent mouseEvent) {
            tabHeaderContainer.lambda$new$437(tab, mouseEvent);
        }
    }

    protected class HeaderContainer
    extends StackPane {
        private Rectangle headerClip;
        private StackPane headersRegion;
        private StackPane headerBackground;
        private HeaderControl rightControlButton;
        private HeaderControl leftControlButton;
        private Line selectedTabLine;
        private boolean initialized = false;
        private boolean measureClosingTabs = false;
        private double scrollOffset;
        private double selectedTabLineOffset;
        private List<TabHeaderContainer> removedTabsHeaders = new ArrayList<TabHeaderContainer>();

        public HeaderContainer() {
            this.getStyleClass().setAll((Object[])new String[]{"tab-header-area"});
            this.setManaged(false);
            this.headerClip = new Rectangle();
            this.headersRegion = new StackPane(){

                protected double computePrefWidth(double height) {
                    double width = 0.0;
                    for (Node child : this.getChildren()) {
                        if (!(child instanceof TabHeaderContainer) || !child.isVisible() || !HeaderContainer.this.measureClosingTabs && ((TabHeaderContainer)child).isClosing) continue;
                        width += ((TabHeaderContainer)child).prefWidth(height);
                    }
                    return this.snapSize(width) + this.snappedLeftInset() + this.snappedRightInset();
                }

                protected double computePrefHeight(double width) {
                    double height = 0.0;
                    for (Node child : this.getChildren()) {
                        if (!(child instanceof TabHeaderContainer)) continue;
                        height = Math.max(height, ((TabHeaderContainer)child).prefHeight(width));
                    }
                    return this.snapSize(height) + this.snappedTopInset() + this.snappedBottomInset();
                }

                protected void layoutChildren() {
                    Object tabHeaderContainer;
                    double offset;
                    if (HeaderContainer.this.isTabsFitHeaderWidth()) {
                        HeaderContainer.this.updateScrollOffset(0.0);
                    } else if (!HeaderContainer.this.removedTabsHeaders.isEmpty()) {
                        offset = 0.0;
                        double w = JFXTabPaneSkin.this.headerContainer.getWidth() - this.snapSize(HeaderContainer.this.rightControlButton.prefWidth(-1.0)) - this.snapSize(HeaderContainer.this.leftControlButton.prefWidth(-1.0)) - this.snappedLeftInset() - 10.0;
                        Iterator itr = this.getChildren().iterator();
                        while (itr.hasNext()) {
                            Node temp = (Node)itr.next();
                            if (!(temp instanceof TabHeaderContainer)) continue;
                            tabHeaderContainer = (TabHeaderContainer)temp;
                            double containerPrefWidth = this.snapSize(tabHeaderContainer.prefWidth(-1.0));
                            if (HeaderContainer.this.removedTabsHeaders.contains(tabHeaderContainer)) {
                                if (offset < w) {
                                    JFXTabPaneSkin.this.isSelectingTab = true;
                                }
                                itr.remove();
                                HeaderContainer.this.removedTabsHeaders.remove(tabHeaderContainer);
                                if (HeaderContainer.this.removedTabsHeaders.isEmpty()) break;
                            }
                            offset += containerPrefWidth;
                        }
                    }
                    if (JFXTabPaneSkin.this.isSelectingTab) {
                        offset = 0.0;
                        double selectedTabOffset = 0.0;
                        double selectedTabWidth = 0.0;
                        for (Node node : HeaderContainer.this.headersRegion.getChildren()) {
                            if (!(node instanceof TabHeaderContainer)) continue;
                            TabHeaderContainer tabHeader = (TabHeaderContainer)node;
                            double tabHeaderPrefWidth = this.snapSize(tabHeader.prefWidth(-1.0));
                            if (JFXTabPaneSkin.this.selectedTab != null && JFXTabPaneSkin.this.selectedTab.equals(tabHeader.tab)) {
                                selectedTabOffset = offset;
                                selectedTabWidth = tabHeaderPrefWidth;
                            }
                            offset += tabHeaderPrefWidth;
                        }
                        HeaderContainer.this.runTimeline(selectedTabOffset + 1.0, selectedTabWidth - 2.0);
                        JFXTabPaneSkin.this.isSelectingTab = false;
                    } else {
                        HeaderContainer.this.updateScrollOffset(HeaderContainer.this.scrollOffset);
                    }
                    double tabBackgroundHeight = this.snapSize(this.prefHeight(-1.0));
                    double tabStartX = HeaderContainer.this.scrollOffset;
                    HeaderContainer.this.updateHeaderContainerClip();
                    for (Node node : this.getChildren()) {
                        if (!(node instanceof TabHeaderContainer)) continue;
                        tabHeaderContainer = (TabHeaderContainer)node;
                        double tabHeaderPrefWidth = this.snapSize(tabHeaderContainer.prefWidth(-1.0));
                        double tabHeaderPrefHeight = this.snapSize(tabHeaderContainer.prefHeight(-1.0));
                        tabHeaderContainer.resize(tabHeaderPrefWidth, tabHeaderPrefHeight);
                        double tabStartY = tabBackgroundHeight - tabHeaderPrefHeight - this.snappedBottomInset();
                        tabHeaderContainer.relocate(tabStartX, tabStartY);
                        tabStartX += tabHeaderPrefWidth;
                    }
                }
            };
            this.headersRegion.getStyleClass().setAll((Object[])new String[]{"headers-region"});
            this.headersRegion.setCache(true);
            this.headersRegion.setClip((Node)this.headerClip);
            this.headerBackground = new StackPane();
            this.headerBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)JFXTabPaneSkin.this.defaultColor, CornerRadii.EMPTY, Insets.EMPTY)}));
            this.headerBackground.getStyleClass().setAll((Object[])new String[]{"tab-header-background"});
            this.selectedTabLine = new Line();
            this.selectedTabLine.setCache(true);
            this.selectedTabLine.getStyleClass().add((Object)"tab-selected-line");
            this.selectedTabLine.setStrokeWidth(2.0);
            this.selectedTabLine.setStroke((Paint)JFXTabPaneSkin.this.ripplerColor);
            this.headersRegion.getChildren().add((Object)this.selectedTabLine);
            this.selectedTabLine.translateYProperty().bind((ObservableValue)Bindings.createDoubleBinding((Callable)JFXTabPaneSkin$HeaderContainer$$Lambda$1.lambdaFactory$(this), (Observable[])new Observable[]{this.headersRegion.heightProperty(), this.selectedTabLine.strokeWidthProperty()}));
            this.rightControlButton = new HeaderControl(ArrowPosition.RIGHT);
            this.leftControlButton = new HeaderControl(ArrowPosition.LEFT);
            this.rightControlButton.setVisible(false);
            this.leftControlButton.setVisible(false);
            this.rightControlButton.inner.prefHeightProperty().bind((ObservableValue)this.headersRegion.heightProperty());
            this.leftControlButton.inner.prefHeightProperty().bind((ObservableValue)this.headersRegion.heightProperty());
            this.getChildren().addAll((Object[])new Node[]{this.headerBackground, this.headersRegion, this.leftControlButton, this.rightControlButton});
            int i = 0;
            for (Tab tab : ((TabPane)JFXTabPaneSkin.this.getSkinnable()).getTabs()) {
                this.addTab(tab, i++, true);
            }
            this.addEventHandler(ScrollEvent.SCROLL, JFXTabPaneSkin$HeaderContainer$$Lambda$2.lambdaFactory$(this));
        }

        private void updateHeaderContainerClip() {
            double x = 0.0;
            double y = 0.0;
            double clipWidth = 0.0;
            double clipHeight = 0.0;
            double clipOffset = this.snappedLeftInset();
            double maxWidth = 0.0;
            double controlPrefWidth = 2.0 * this.snapSize(this.rightControlButton.prefWidth(-1.0));
            this.measureClosingTabs = true;
            double headersPrefWidth = this.snapSize(this.headersRegion.prefWidth(-1.0));
            this.measureClosingTabs = false;
            double headersPrefHeight = this.snapSize(this.headersRegion.prefHeight(-1.0));
            if (controlPrefWidth > 0.0) {
                controlPrefWidth += 10.0;
            }
            clipWidth = headersPrefWidth < (maxWidth = this.snapSize(this.getWidth()) - controlPrefWidth - clipOffset) ? headersPrefWidth : maxWidth;
            clipHeight = headersPrefHeight;
            this.headerClip.setX(x);
            this.headerClip.setY(y);
            this.headerClip.setWidth(clipWidth + 10.0);
            this.headerClip.setHeight(clipHeight);
        }

        private void addTab(Tab tab, int addToIndex, boolean visible) {
            TabHeaderContainer tabHeaderSkin = new TabHeaderContainer(tab);
            tabHeaderSkin.setVisible(visible);
            this.headersRegion.getChildren().add(addToIndex, (Object)tabHeaderSkin);
        }

        private void removeTab(Tab tab) {
            TabHeaderContainer tabHeaderContainer = this.getTabHeaderContainer(tab);
            if (tabHeaderContainer != null) {
                if (this.isTabsFitHeaderWidth()) {
                    this.headersRegion.getChildren().remove((Object)tabHeaderContainer);
                } else {
                    this.removedTabsHeaders.add(tabHeaderContainer);
                    tabHeaderContainer.removeListeners(tab);
                }
            }
        }

        private TabHeaderContainer getTabHeaderContainer(Tab tab) {
            for (Node child : this.headersRegion.getChildren()) {
                if (!(child instanceof TabHeaderContainer) || !((TabHeaderContainer)child).tab.equals(tab)) continue;
                return (TabHeaderContainer)child;
            }
            return null;
        }

        private boolean isTabsFitHeaderWidth() {
            double rightControlWidth;
            double headerPrefWidth = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double visibleWidth = headerPrefWidth + (rightControlWidth = 2.0 * this.snapSize(this.rightControlButton.prefWidth(-1.0))) + this.snappedLeftInset() + 10.0;
            return visibleWidth < this.getWidth();
        }

        private void runTimeline(double newTransX, double newWidth) {
            double oldWidth = this.selectedTabLine.getEndX();
            double oldTransX = this.selectedTabLineOffset;
            this.selectedTabLineOffset = newTransX;
            double transDiff = newTransX - oldTransX;
            Timeline timeline = transDiff > 0.0 ? new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.selectedTabLine.endXProperty(), (Object)oldWidth, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)(oldTransX + JFXTabPaneSkin.this.offsetStart), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.15), new KeyValue[]{new KeyValue((WritableValue)this.selectedTabLine.endXProperty(), (Object)transDiff, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)(oldTransX + JFXTabPaneSkin.this.offsetStart), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.33), new KeyValue[]{new KeyValue((WritableValue)this.selectedTabLine.endXProperty(), (Object)newWidth, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)(newTransX + JFXTabPaneSkin.this.offsetStart), Interpolator.EASE_BOTH)})}) : new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.selectedTabLine.endXProperty(), (Object)oldWidth, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)(oldTransX + JFXTabPaneSkin.this.offsetStart), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.15), new KeyValue[]{new KeyValue((WritableValue)this.selectedTabLine.endXProperty(), (Object)(-transDiff), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)(newTransX + JFXTabPaneSkin.this.offsetStart), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.33), new KeyValue[]{new KeyValue((WritableValue)this.selectedTabLine.endXProperty(), (Object)newWidth, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)(newTransX + JFXTabPaneSkin.this.offsetStart), Interpolator.EASE_BOTH)})});
            timeline.play();
        }

        public void updateScrollOffset(double newOffset) {
            double tabPaneWidth = this.snapSize(((TabPane)JFXTabPaneSkin.this.getSkinnable()).getWidth());
            double controlTabWidth = 2.0 * this.snapSize(this.rightControlButton.getWidth());
            double visibleWidth = tabPaneWidth - controlTabWidth - this.snappedLeftInset() - 10.0;
            double offset = 0.0;
            for (Node node : this.headersRegion.getChildren()) {
                if (!(node instanceof TabHeaderContainer)) continue;
                double tabHeaderPrefWidth = this.snapSize(((TabHeaderContainer)node).prefWidth(-1.0));
                offset += tabHeaderPrefWidth;
            }
            double actualOffset = newOffset;
            if (visibleWidth - newOffset > offset && newOffset < 0.0) {
                actualOffset = visibleWidth - offset;
            } else if (newOffset > 0.0) {
                actualOffset = 0.0;
            }
            if (actualOffset != this.scrollOffset) {
                this.scrollOffset = actualOffset;
                this.headersRegion.requestLayout();
                this.selectedTabLine.setTranslateX(this.selectedTabLineOffset + this.scrollOffset);
            }
        }

        protected double computePrefWidth(double height) {
            return this.snapSize(this.headersRegion.prefWidth(height)) + 2.0 * this.rightControlButton.prefWidth(height) + this.snappedLeftInset() + 10.0 + this.snappedLeftInset() + this.snappedRightInset();
        }

        protected double computePrefHeight(double width) {
            return this.snapSize(this.headersRegion.prefHeight(-1.0)) + this.snappedTopInset() + this.snappedBottomInset();
        }

        public double getBaselineOffset() {
            return this.headersRegion.getBaselineOffset() + this.snappedTopInset();
        }

        protected void layoutChildren() {
            double leftInset = this.snappedLeftInset();
            double rightInset = this.snappedRightInset();
            double topInset = this.snappedTopInset();
            double bottomInset = this.snappedBottomInset();
            double w = this.snapSize(this.getWidth()) - (leftInset + rightInset);
            double h = this.snapSize(this.getHeight()) - (topInset + bottomInset);
            double tabBackgroundHeight = this.snapSize(this.prefHeight(-1.0));
            double headersPrefWidth = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double headersPrefHeight = this.snapSize(this.headersRegion.prefHeight(-1.0));
            this.rightControlButton.showTabsMenu(!this.isTabsFitHeaderWidth());
            this.leftControlButton.showTabsMenu(!this.isTabsFitHeaderWidth());
            this.updateHeaderContainerClip();
            this.headersRegion.requestLayout();
            double btnWidth = this.snapSize(this.rightControlButton.prefWidth(-1.0));
            double btnHeight = this.rightControlButton.prefHeight(btnWidth);
            this.rightControlButton.resize(btnWidth, btnHeight);
            this.leftControlButton.resize(btnWidth, btnHeight);
            this.headersRegion.resize(headersPrefWidth, headersPrefHeight);
            this.headerBackground.resize(this.snapSize(this.getWidth()), this.snapSize(this.getHeight()));
            double startX = 0.0;
            double startY = 0.0;
            double controlStartX = 0.0;
            double controlStartY = 0.0;
            startX = leftInset;
            startY = tabBackgroundHeight - headersPrefHeight - bottomInset;
            controlStartX = w - btnWidth + leftInset;
            controlStartY = this.snapSize(this.getHeight()) - btnHeight - bottomInset;
            if (this.headerBackground.isVisible()) {
                this.positionInArea((Node)this.headerBackground, 0.0, 0.0, this.snapSize(this.getWidth()), this.snapSize(this.getHeight()), 0.0, HPos.CENTER, VPos.CENTER);
            }
            this.positionInArea((Node)this.headersRegion, startX + btnWidth, startY, w, h, 0.0, HPos.LEFT, VPos.CENTER);
            this.positionInArea((Node)this.rightControlButton, controlStartX, controlStartY, btnWidth, btnHeight, 0.0, HPos.CENTER, VPos.CENTER);
            this.positionInArea((Node)this.leftControlButton, 0.0, controlStartY, btnWidth, btnHeight, 0.0, HPos.CENTER, VPos.CENTER);
            if (!this.initialized) {
                double offset = 0.0;
                double selectedTabOffset = 0.0;
                double selectedTabWidth = 0.0;
                for (Node node : this.headersRegion.getChildren()) {
                    if (!(node instanceof TabHeaderContainer)) continue;
                    TabHeaderContainer tabHeader = (TabHeaderContainer)node;
                    double tabHeaderPrefWidth = this.snapSize(tabHeader.prefWidth(-1.0));
                    if (JFXTabPaneSkin.this.selectedTab != null && JFXTabPaneSkin.this.selectedTab.equals(tabHeader.tab)) {
                        selectedTabOffset = offset;
                        selectedTabWidth = tabHeaderPrefWidth;
                    }
                    offset += tabHeaderPrefWidth;
                }
                double selectedTabStartX = selectedTabOffset;
                this.runTimeline(selectedTabStartX + 1.0, selectedTabWidth - 2.0);
                this.initialized = true;
            }
        }

        private /* synthetic */ void lambda$new$432(ScrollEvent e) {
            this.updateScrollOffset(this.scrollOffset - e.getDeltaY());
        }

        private /* synthetic */ Double lambda$new$431() throws Exception {
            return this.headersRegion.getHeight() - this.selectedTabLine.getStrokeWidth() + 1.0;
        }

        static /* synthetic */ Double access$lambda$0(HeaderContainer headerContainer) {
            return headerContainer.lambda$new$431();
        }

        static /* synthetic */ void access$lambda$1(HeaderContainer headerContainer, ScrollEvent scrollEvent) {
            headerContainer.lambda$new$432(scrollEvent);
        }
    }
}

