/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.behavior.JFXDatePickerBehavior;
import com.jfoenix.skins.JFXDatePickerContent;
import com.jfoenix.skins.JFXDatePickerSkin$$Lambda$1;
import com.jfoenix.skins.JFXDatePickerSkin$$Lambda$2;
import com.jfoenix.skins.JFXTimePickerContent;
import com.jfoenix.svg.SVGGlyph;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import javafx.util.converter.LocalTimeStringConverter;

public class JFXDatePickerSkin
extends ComboBoxPopupControl<LocalDate> {
    private JFXDatePicker jfxDatePicker;
    private JFXTextField editorNode;
    private TextField displayNode;
    private JFXDatePickerContent jfxDatePickerContent;
    private JFXTimePickerContent timeContent;
    private JFXDialog dialog;

    public JFXDatePickerSkin(JFXDatePicker datePicker) {
        super((ComboBoxBase)datePicker, (ComboBoxBaseBehavior)new JFXDatePickerBehavior(datePicker));
        this.jfxDatePicker = datePicker;
        this.editorNode = new JFXTextField();
        this.editorNode.focusColorProperty().bind(datePicker.defaultColorProperty());
        this.editorNode.focusedProperty().addListener(JFXDatePickerSkin$$Lambda$1.lambdaFactory$(this));
        this.arrow = !((JFXDatePicker)this.getSkinnable()).isShowTime() ? new SVGGlyph(0, "calendar", "M320 384h128v128h-128zM512 384h128v128h-128zM704 384h128v128h-128zM128 768h128v128h-128zM320 768h128v128h-128zM512 768h128v128h-128zM320 576h128v128h-128zM512 576h128v128h-128zM704 576h128v128h-128zM128 576h128v128h-128zM832 0v64h-128v-64h-448v64h-128v-64h-128v1024h960v-1024h-128zM896 960h-832v-704h832v704z", (Paint)Color.BLACK) : new SVGGlyph(0, "clock", "M512 310.857v256q0 8-5.143 13.143t-13.143 5.143h-182.857q-8 0-13.143-5.143t-5.143-13.143v-36.571q0-8 5.143-13.143t13.143-5.143h128v-201.143q0-8 5.143-13.143t13.143-5.143h36.571q8 0 13.143 5.143t5.143 13.143zM749.714 512q0-84.571-41.714-156t-113.143-113.143-156-41.714-156 41.714-113.143 113.143-41.714 156 41.714 156 113.143 113.143 156 41.714 156-41.714 113.143-113.143 41.714-156zM877.714 512q0 119.429-58.857 220.286t-159.714 159.714-220.286 58.857-220.286-58.857-159.714-159.714-58.857-220.286 58.857-220.286 159.714-159.714 220.286-58.857 220.286 58.857 159.714 159.714 58.857 220.286z", (Paint)Color.BLACK);
        ((SVGGlyph)this.arrow).fillProperty().bind(this.jfxDatePicker.defaultColorProperty());
        ((SVGGlyph)this.arrow).setSize(20.0, 20.0);
        this.arrowButton.getChildren().setAll((Object[])new Node[]{this.arrow});
        this.arrowButton.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.registerChangeListener((ObservableValue)datePicker.converterProperty(), "CONVERTER");
        this.registerChangeListener((ObservableValue)datePicker.dayCellFactoryProperty(), "DAY_CELL_FACTORY");
        this.registerChangeListener((ObservableValue)datePicker.showWeekNumbersProperty(), "SHOW_WEEK_NUMBERS");
        this.registerChangeListener((ObservableValue)datePicker.valueProperty(), "VALUE");
        this.registerChangeListener((ObservableValue)datePicker.timeProperty(), "TIME");
    }

    public Node getPopupContent() {
        if (this.jfxDatePicker.isShowTime()) {
            if (this.timeContent == null) {
                this.timeContent = new JFXTimePickerContent(this.jfxDatePicker);
            }
            return this.timeContent;
        }
        if (this.jfxDatePickerContent == null) {
            this.jfxDatePickerContent = new JFXDatePickerContent(this.jfxDatePicker);
        }
        return this.jfxDatePickerContent;
    }

    public void show() {
        if (!((JFXDatePicker)this.getSkinnable()).isOverLay()) {
            super.show();
        }
        if (this.jfxDatePickerContent != null) {
            this.jfxDatePickerContent.init();
            this.jfxDatePickerContent.clearFocus();
        }
        if (((JFXDatePicker)this.getSkinnable()).isOverLay() && this.dialog == null) {
            StackPane dialogParent = this.jfxDatePicker.getDialogParent();
            if (dialogParent == null) {
                dialogParent = (StackPane)((ComboBoxBase)this.getSkinnable()).getScene().getRoot();
            }
            this.dialog = new JFXDialog(dialogParent, (Region)this.getPopupContent(), JFXDialog.DialogTransition.CENTER, true);
            this.arrowButton.setOnMouseClicked(JFXDatePickerSkin$$Lambda$2.lambdaFactory$(this));
        }
    }

    protected void handleControlPropertyChanged(String p) {
        if ("DAY_CELL_FACTORY".equals(p)) {
            this.updateDisplayNode();
            this.jfxDatePickerContent = null;
            this.popup = null;
        } else if ("CONVERTER".equals(p)) {
            this.updateDisplayNode();
        } else if ("EDITOR".equals(p)) {
            this.getEditableInputNode();
        } else if ("SHOWING".equals(p)) {
            if (this.jfxDatePicker.isShowing()) {
                if (this.jfxDatePickerContent != null) {
                    LocalDate date = (LocalDate)this.jfxDatePicker.getValue();
                    this.jfxDatePickerContent.displayedYearMonthProperty().set((Object)(date != null ? YearMonth.from(date) : YearMonth.now()));
                    this.jfxDatePickerContent.updateValues();
                }
                this.show();
            } else {
                this.hide();
            }
        } else if ("SHOW_WEEK_NUMBERS".equals(p)) {
            if (this.jfxDatePickerContent != null) {
                this.jfxDatePickerContent.updateContentGrid();
                this.jfxDatePickerContent.updateWeekNumberDateCells();
            }
        } else if ("VALUE".equals(p)) {
            this.updateDisplayNode();
            if (this.jfxDatePickerContent != null) {
                LocalDate date = (LocalDate)this.jfxDatePicker.getValue();
                this.jfxDatePickerContent.displayedYearMonthProperty().set((Object)(date != null ? YearMonth.from(date) : YearMonth.now()));
                this.jfxDatePickerContent.updateValues();
            }
            this.jfxDatePicker.fireEvent((Event)new ActionEvent());
        } else if ("TIME".equals(p)) {
            this.updateTimeDisplayNode();
        } else {
            super.handleControlPropertyChanged(p);
        }
    }

    protected void setTextFromTextFieldIntoComboBoxValue() {
        if (this.jfxDatePicker.isShowTime()) {
            if (this.getEditor() != null) {
                LocalTimeStringConverter converter = new LocalTimeStringConverter(FormatStyle.SHORT, Locale.ENGLISH);
                this.jfxDatePicker.setTime(converter.fromString(this.editorNode.getText()));
                this.updateTimeDisplayNode();
            }
        } else {
            super.setTextFromTextFieldIntoComboBoxValue();
        }
    }

    private void updateTimeDisplayNode() {
        if (this.jfxDatePicker.isShowTime()) {
            if (this.jfxDatePicker.getTime() == null) {
                this.displayNode.setText("");
                return;
            }
            DateTimeFormatter fmt = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
            this.displayNode.setText(fmt.format(this.jfxDatePicker.getTime()));
        }
    }

    protected TextField getEditor() {
        boolean parentListenerCall;
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        if (caller.getClassName().equals(((Object)((Object)this)).getClass().getName())) {
            caller = Thread.currentThread().getStackTrace()[3];
        }
        boolean bl = parentListenerCall = caller.getMethodName().contains("lambda") && caller.getClassName().equals(((Object)((Object)this)).getClass().getSuperclass().getName());
        if (parentListenerCall) {
            return null;
        }
        return this.editorNode;
    }

    protected StringConverter<LocalDate> getConverter() {
        return ((DatePicker)this.getSkinnable()).getConverter();
    }

    public Node getDisplayNode() {
        if (this.displayNode == null) {
            this.displayNode = this.getEditableInputNode();
            this.displayNode.getStyleClass().add((Object)"date-picker-display-node");
            this.updateDisplayNode();
            this.updateTimeDisplayNode();
        }
        this.displayNode.setEditable(this.jfxDatePicker.isEditable());
        return this.displayNode;
    }

    public void syncWithAutoUpdate() {
        if (!this.getPopup().isShowing() && this.jfxDatePicker.isShowing()) {
            this.jfxDatePicker.hide();
        }
    }

    private /* synthetic */ void lambda$show$352(MouseEvent click) {
        if (((JFXDatePicker)this.getSkinnable()).isOverLay()) {
            StackPane parent = this.jfxDatePicker.getDialogParent();
            if (parent == null) {
                parent = (StackPane)((ComboBoxBase)this.getSkinnable()).getScene().getRoot();
            }
            this.dialog.show(parent);
        }
    }

    private /* synthetic */ void lambda$new$351(ObservableValue obj, Boolean oldVal, Boolean newVal) {
        if (!newVal.booleanValue()) {
            this.setTextFromTextFieldIntoComboBoxValue();
        }
    }

    static /* synthetic */ void access$lambda$0(JFXDatePickerSkin jFXDatePickerSkin, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        jFXDatePickerSkin.lambda$new$351(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$1(JFXDatePickerSkin jFXDatePickerSkin, MouseEvent mouseEvent) {
        jFXDatePickerSkin.lambda$show$352(mouseEvent);
    }
}

