/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$1;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$10;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$2;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$3;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$4;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$5;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$6;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$7;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$8;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$9;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;

public class RecursiveTreeItem<T extends RecursiveTreeObject<T>>
extends TreeItem<T> {
    private Callback<RecursiveTreeObject<T>, ObservableList<T>> childrenFactory;
    private ObjectProperty<Predicate<TreeItem<T>>> predicate;
    ObservableList<TreeItem<T>> originalItems;
    FilteredList<TreeItem<T>> filteredItems;

    public RecursiveTreeItem(Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this(null, null, func);
    }

    public RecursiveTreeItem(T value, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this(value, null, func);
    }

    public RecursiveTreeItem(T value, Node graphic, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        super(value, graphic);
        this.predicate = new SimpleObjectProperty((Object)RecursiveTreeItem$$Lambda$1.lambdaFactory$());
        this.originalItems = FXCollections.observableArrayList();
        this.childrenFactory = func;
        this.init((RecursiveTreeObject<T>)value);
    }

    public RecursiveTreeItem(ObservableList<T> dataList, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this.predicate = new SimpleObjectProperty((Object)RecursiveTreeItem$$Lambda$2.lambdaFactory$());
        this.originalItems = FXCollections.observableArrayList();
        RecursiveTreeObject<T> root = new RecursiveTreeObject<T>();
        root.setChildren(dataList);
        this.childrenFactory = func;
        this.init(root);
    }

    private void init(RecursiveTreeObject<T> value) {
        if (value != null) {
            this.addChildrenListener(value);
        }
        this.valueProperty().addListener(RecursiveTreeItem$$Lambda$3.lambdaFactory$(this));
        this.filteredItems.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding((Callable)RecursiveTreeItem$$Lambda$4.lambdaFactory$(this), (Observable[])new Observable[]{this.predicate}));
        this.filteredItems.predicateProperty().addListener(RecursiveTreeItem$$Lambda$5.lambdaFactory$(this));
    }

    private void addChildrenListener(RecursiveTreeObject<T> value) {
        ObservableList children = (ObservableList)this.childrenFactory.call(value);
        this.originalItems = FXCollections.observableArrayList();
        for (RecursiveTreeObject child : children) {
            this.originalItems.add(new RecursiveTreeItem<RecursiveTreeObject>(child, this.getGraphic(), this.childrenFactory));
        }
        this.filteredItems = new FilteredList(this.originalItems, RecursiveTreeItem$$Lambda$6.lambdaFactory$());
        this.getChildren().addAll(this.originalItems);
        children.addListener(RecursiveTreeItem$$Lambda$7.lambdaFactory$(this));
    }

    public final ObjectProperty<Predicate<TreeItem<T>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<T>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<T>> predicate) {
        this.predicateProperty().set(predicate);
    }

    private /* synthetic */ void lambda$addChildrenListener$247(ListChangeListener.Change change) {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(RecursiveTreeItem$$Lambda$8.lambdaFactory$(this));
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(RecursiveTreeItem$$Lambda$9.lambdaFactory$(this));
        }
    }

    private /* synthetic */ void lambda$null$246(RecursiveTreeObject t) {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (!((RecursiveTreeObject)((TreeItem)this.getChildren().get(i)).getValue()).equals(t)) continue;
            this.originalItems.remove(this.getChildren().remove(i));
            --i;
        }
    }

    private /* synthetic */ void lambda$null$245(RecursiveTreeObject t) {
        RecursiveTreeItem<RecursiveTreeObject> newItem = new RecursiveTreeItem<RecursiveTreeObject>(t, this.getGraphic(), this.childrenFactory);
        this.getChildren().add(newItem);
        this.originalItems.add(newItem);
    }

    private static /* synthetic */ boolean lambda$addChildrenListener$244(TreeItem t) {
        return true;
    }

    private /* synthetic */ void lambda$init$243(ObservableValue o, Predicate oldVal, Predicate newVal) {
        JFXUtilities.runInFXAndWait(RecursiveTreeItem$$Lambda$10.lambdaFactory$(this));
    }

    private /* synthetic */ void lambda$null$242() {
        this.getChildren().clear();
        this.getChildren().addAll(this.filteredItems);
    }

    private /* synthetic */ Predicate lambda$init$241() throws Exception {
        Predicate newPredicate = new Predicate<TreeItem<T>>(){

            @Override
            public boolean test(TreeItem<T> child) {
                if (child instanceof RecursiveTreeItem && !((RecursiveTreeItem)child).originalItems.isEmpty()) {
                    RecursiveTreeItem filterableChild = (RecursiveTreeItem)child;
                    filterableChild.setPredicate((Predicate)RecursiveTreeItem.this.predicate.get());
                }
                if (RecursiveTreeItem.this.predicate.get() == null) {
                    return true;
                }
                if (child.getChildren().size() > 0) {
                    return true;
                }
                if (child.getValue() instanceof RecursiveTreeObject && ((RecursiveTreeObject)child.getValue()).getClass() == RecursiveTreeObject.class) {
                    return child.getChildren().size() != 0;
                }
                return ((Predicate)RecursiveTreeItem.this.predicate.get()).test(child);
            }
        };
        return newPredicate;
    }

    private /* synthetic */ void lambda$init$240(ObservableValue o, RecursiveTreeObject oldValue, RecursiveTreeObject newValue) {
        if (newValue != null) {
            this.addChildrenListener(newValue);
        }
    }

    private static /* synthetic */ boolean lambda$new$239(TreeItem t) {
        return true;
    }

    static /* synthetic */ boolean access$lambda$0(TreeItem treeItem) {
        return RecursiveTreeItem.lambda$new$239(treeItem);
    }

    static /* synthetic */ boolean access$lambda$1(TreeItem treeItem) {
        return RecursiveTreeItem.lambda$new$239(treeItem);
    }

    static /* synthetic */ void access$lambda$2(RecursiveTreeItem recursiveTreeItem, ObservableValue observableValue, RecursiveTreeObject recursiveTreeObject, RecursiveTreeObject recursiveTreeObject2) {
        recursiveTreeItem.lambda$init$240(observableValue, recursiveTreeObject, recursiveTreeObject2);
    }

    static /* synthetic */ Predicate access$lambda$3(RecursiveTreeItem recursiveTreeItem) {
        return recursiveTreeItem.lambda$init$241();
    }

    static /* synthetic */ void access$lambda$4(RecursiveTreeItem recursiveTreeItem, ObservableValue observableValue, Predicate predicate, Predicate predicate2) {
        recursiveTreeItem.lambda$init$243(observableValue, predicate, predicate2);
    }

    static /* synthetic */ boolean access$lambda$5(TreeItem treeItem) {
        return RecursiveTreeItem.lambda$addChildrenListener$244(treeItem);
    }

    static /* synthetic */ void access$lambda$6(RecursiveTreeItem recursiveTreeItem, ListChangeListener.Change change) {
        recursiveTreeItem.lambda$addChildrenListener$247(change);
    }

    static /* synthetic */ void access$lambda$7(RecursiveTreeItem recursiveTreeItem, RecursiveTreeObject recursiveTreeObject) {
        recursiveTreeItem.lambda$null$245(recursiveTreeObject);
    }

    static /* synthetic */ void access$lambda$8(RecursiveTreeItem recursiveTreeItem, RecursiveTreeObject recursiveTreeObject) {
        recursiveTreeItem.lambda$null$246(recursiveTreeObject);
    }

    static /* synthetic */ void access$lambda$9(RecursiveTreeItem recursiveTreeItem) {
        recursiveTreeItem.lambda$null$242();
    }
}

