/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXListCell;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.converters.base.NodeConverter;
import com.jfoenix.skins.JFXComboBoxListViewSkin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class JFXComboBox<T>
extends ComboBox<T> {
    private static final String DEFAULT_STYLE_CLASS = "jfx-combo-box";
    private TextField textField;
    private ReadOnlyObjectWrapper<TextField> jfxEditor;
    private ObjectProperty<NodeConverter<T>> nodeConverter = new SimpleObjectProperty((Object)this, "nodeConverter", JFXComboBox.<T>defaultNodeConverter());

    public JFXComboBox() {
        this.initialize();
    }

    public JFXComboBox(ObservableList<T> items) {
        super(items);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setCellFactory(new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> listView) {
                return new JFXListCell();
            }
        });
        this.setConverter(new StringConverter<T>(){

            public String toString(T object) {
                if (object == null) {
                    return null;
                }
                if (object instanceof Label) {
                    return ((Label)object).getText();
                }
                return object.toString();
            }

            public T fromString(String string) {
                return string;
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXComboBoxListViewSkin(this);
    }

    public final TextField getJFXEditor() {
        return (TextField)this.jfxEditorProperty().get();
    }

    public final ReadOnlyObjectProperty<TextField> jfxEditorProperty() {
        if (this.jfxEditor == null) {
            this.jfxEditor = new ReadOnlyObjectWrapper((Object)this, "editor");
            this.textField = new JFXTextField();
            this.jfxEditor.set((Object)this.textField);
        }
        return this.jfxEditor.getReadOnlyProperty();
    }

    public ObjectProperty<NodeConverter<T>> nodeConverterProperty() {
        return this.nodeConverter;
    }

    public final void setNodeConverter(NodeConverter<T> value) {
        this.nodeConverterProperty().set(value);
    }

    public final NodeConverter<T> getNodeConverter() {
        return (NodeConverter)this.nodeConverterProperty().get();
    }

    private static <T> NodeConverter<T> defaultNodeConverter() {
        return new NodeConverter<T>(){

            @Override
            public Node toNode(T object) {
                if (object == null) {
                    return null;
                }
                StackPane selectedValueContainer = new StackPane();
                selectedValueContainer.getStyleClass().add((Object)"combo-box-selected-value-container");
                selectedValueContainer.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
                Label selectedValueLabel = object instanceof Label ? new Label(((Label)object).getText()) : new Label(object.toString());
                selectedValueLabel.setTextFill((Paint)Color.BLACK);
                selectedValueContainer.getChildren().add((Object)selectedValueLabel);
                StackPane.setAlignment((Node)selectedValueLabel, (Pos)Pos.CENTER_LEFT);
                StackPane.setMargin((Node)selectedValueLabel, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
                return selectedValueContainer;
            }

            @Override
            public T fromNode(Node node) {
                return node;
            }

            @Override
            public String toString(T object) {
                if (object == null) {
                    return null;
                }
                if (object instanceof Label) {
                    return ((Label)object).getText();
                }
                return object.toString();
            }
        };
    }
}

