/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.controls.JFXTreeTableRow;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$1;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$10;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$11;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$2;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$3;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$4;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$5;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$6;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$7;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$8;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$9;
import com.jfoenix.controls.JFXTreeTableView$2$$Lambda$1;
import com.jfoenix.controls.JFXTreeTableView$2$$Lambda$2;
import com.jfoenix.controls.RecursiveTreeItem;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import com.jfoenix.skins.JFXTreeTableViewSkin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class JFXTreeTableView<S extends RecursiveTreeObject<S>>
extends TreeTableView<S> {
    private TreeItem<S> originalRoot;
    private boolean itemWasSelected = false;
    private ObservableList<TreeTableColumn<S, ?>> groupOrder = FXCollections.observableArrayList();
    private Semaphore groupingSemaphore = new Semaphore(1);
    private Timer t;
    private ObjectProperty<Predicate<TreeItem<S>>> predicate;
    private IntegerProperty currentItemsCount;
    private Map<Object, Map<Object, ?>> groups;

    public JFXTreeTableView() {
        this.predicate = new SimpleObjectProperty((Object)JFXTreeTableView$$Lambda$1.lambdaFactory$());
        this.currentItemsCount = new SimpleIntegerProperty(0);
        this.init();
    }

    public JFXTreeTableView(TreeItem<S> root, ObservableList<S> items) {
        super(root);
        this.predicate = new SimpleObjectProperty((Object)JFXTreeTableView$$Lambda$2.lambdaFactory$());
        this.currentItemsCount = new SimpleIntegerProperty(0);
        this.originalRoot = root;
        this.init();
    }

    public void propagateMouseEventsToParent() {
        this.addEventHandler(MouseEvent.ANY, JFXTreeTableView$$Lambda$3.lambdaFactory$(this));
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXTreeTableViewSkin(this);
    }

    protected void init() {
        this.setRowFactory(new Callback<TreeTableView<S>, TreeTableRow<S>>(){

            public TreeTableRow<S> call(TreeTableView<S> param) {
                return new JFXTreeTableRow();
            }
        });
        this.getSelectionModel().selectedItemProperty().addListener(JFXTreeTableView$$Lambda$4.lambdaFactory$(this));
        this.predicate.addListener(JFXTreeTableView$$Lambda$5.lambdaFactory$(this));
        this.rootProperty().addListener(JFXTreeTableView$$Lambda$6.lambdaFactory$(this));
        this.setCurrentItemsCount(this.count(this.getRoot()));
    }

    public int getTreeItemLevel(TreeItem<?> node) {
        TreeItem root = this.getRoot();
        if (node == null) {
            return -1;
        }
        if (node == root) {
            return 0;
        }
        int level = 0;
        for (TreeItem parent = node.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
            if (parent == root) break;
            if (((RecursiveTreeObject)parent.getValue()).getGroupedColumn() == null) continue;
            --level;
        }
        return level;
    }

    public void sort() {
        this.getSelectionModel().clearSelection();
        super.sort();
        if (this.itemWasSelected) {
            this.getSelectionModel().select(0);
        }
    }

    final ObservableList<TreeTableColumn<S, ?>> getGroupOrder() {
        return this.groupOrder;
    }

    public void group(TreeTableColumn<S, ?> ... treeTableColumns) {
        if (this.groupingSemaphore.tryAcquire()) {
            if (this.groupOrder.size() == 0) {
                this.groups = new HashMap();
            }
            try {
                if (this.originalRoot == null) {
                    this.originalRoot = this.getRoot();
                }
                for (TreeTableColumn<S, ?> treeTableColumn : treeTableColumns) {
                    this.groups = this.group(treeTableColumn, this.groups, null, (RecursiveTreeItem)this.originalRoot);
                }
                this.groupOrder.addAll((Object[])treeTableColumns);
                this.buildGroupedRoot(this.groups, null, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.groupingSemaphore.release();
        }
    }

    private void refreshGroups(List<TreeTableColumn<S, ?>> groupColumns) {
        this.groups = new HashMap();
        for (TreeTableColumn<S, ?> treeTableColumn : groupColumns) {
            this.groups = this.group(treeTableColumn, this.groups, null, (RecursiveTreeItem)this.originalRoot);
        }
        this.groupOrder.addAll(groupColumns);
        this.buildGroupedRoot(this.groups, null, 0);
    }

    public void unGroup(TreeTableColumn<S, ?> ... treeTableColumns) {
        if (this.groupingSemaphore.tryAcquire()) {
            try {
                if (this.groupOrder.size() > 0) {
                    this.groupOrder.removeAll((Object[])treeTableColumns);
                    ArrayList grouped = new ArrayList();
                    grouped.addAll((Collection<TreeTableColumn<S, ?>>)this.groupOrder);
                    this.groupOrder.clear();
                    JFXUtilities.runInFXAndWait(JFXTreeTableView$$Lambda$7.lambdaFactory$(this, grouped));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.groupingSemaphore.release();
        }
    }

    private Map group(TreeTableColumn<S, ?> column, Map parentGroup, Object key, RecursiveTreeItem<S> root) {
        if (parentGroup.isEmpty()) {
            parentGroup = this.groupByFunction((List<TreeItem<S>>)root.filteredItems, column);
            return parentGroup;
        }
        Object value = parentGroup.get(key);
        if (value instanceof List) {
            Map newGroup = this.groupByFunction((List)value, column);
            parentGroup.put(key, newGroup);
            return parentGroup;
        }
        if (value instanceof Map) {
            for (Object childKey : ((Map)value).keySet()) {
                value = this.group(column, (Map)value, childKey, root);
            }
            parentGroup.put(key, value);
            return parentGroup;
        }
        if (key == null) {
            for (Object childKey : parentGroup.keySet()) {
                parentGroup = this.group(column, parentGroup, childKey, root);
            }
            return parentGroup;
        }
        return parentGroup;
    }

    protected Map groupByFunction(List<TreeItem<S>> items, TreeTableColumn<S, ?> column) {
        HashMap map = new HashMap();
        for (TreeItem<S> child : items) {
            Object key = column.getCellData(child);
            if (map.get(key) == null) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(child);
        }
        return map;
    }

    private void buildGroupedRoot(Map groupedItems, RecursiveTreeItem parent, int groupIndex) {
        boolean setRoot = false;
        if (parent == null) {
            parent = new RecursiveTreeItem(new RecursiveTreeObject(), JFXTreeTableView$$Lambda$8.lambdaFactory$());
            setRoot = true;
        }
        for (Object key : groupedItems.keySet()) {
            RecursiveTreeObject groupItem = new RecursiveTreeObject();
            groupItem.setGroupedValue(key);
            groupItem.setGroupedColumn((TreeTableColumn)this.groupOrder.get(groupIndex));
            RecursiveTreeItem node = new RecursiveTreeItem(groupItem, JFXTreeTableView$$Lambda$9.lambdaFactory$());
            node.expandedProperty().addListener(JFXTreeTableView$$Lambda$10.lambdaFactory$(this));
            parent.originalItems.add(node);
            parent.getChildren().add(node);
            Object children = groupedItems.get(key);
            if (children instanceof List) {
                node.originalItems.addAll((Collection)((List)children));
                node.getChildren().addAll((Collection)((List)children));
                continue;
            }
            if (!(children instanceof Map)) continue;
            this.buildGroupedRoot((Map)children, node, groupIndex + 1);
        }
        if (setRoot) {
            RecursiveTreeItem newParent = parent;
            JFXUtilities.runInFX(JFXTreeTableView$$Lambda$11.lambdaFactory$(this, newParent));
        }
    }

    private final void filter(final Predicate<TreeItem<S>> predicate) {
        if (this.originalRoot == null) {
            this.originalRoot = this.getRoot();
        }
        if (this.t != null) {
            this.t.cancel();
            this.t.purge();
        }
        this.t = new Timer();
        this.t.schedule(new TimerTask(){

            @Override
            public void run() {
                new Thread(JFXTreeTableView$2$$Lambda$1.lambdaFactory$(this, predicate)).start();
            }

            private /* synthetic */ void lambda$run$237(Predicate predicate2) {
                ((RecursiveTreeItem)JFXTreeTableView.this.originalRoot).setPredicate(predicate2);
                JFXTreeTableView.this.reGroup();
                Platform.runLater((Runnable)JFXTreeTableView$2$$Lambda$2.lambdaFactory$(this));
            }

            private /* synthetic */ void lambda$null$236() {
                JFXTreeTableView.this.getSelectionModel().select(0);
                JFXTreeTableView.this.setCurrentItemsCount(JFXTreeTableView.this.count(JFXTreeTableView.this.getRoot()));
            }

            static /* synthetic */ void access$lambda$0(2 var0, Predicate predicate2) {
                var0.lambda$run$237(predicate2);
            }

            static /* synthetic */ void access$lambda$1(2 var0) {
                var0.lambda$null$236();
            }
        }, 500L);
    }

    public void reGroup() {
        if (!this.groupOrder.isEmpty()) {
            ArrayList tempGroups = new ArrayList(this.groupOrder);
            this.groupOrder.clear();
            this.group(tempGroups.toArray(new TreeTableColumn[tempGroups.size()]));
        }
    }

    public final ObjectProperty<Predicate<TreeItem<S>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<S>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<S>> predicate) {
        this.predicateProperty().set(predicate);
    }

    public final IntegerProperty currentItemsCountProperty() {
        return this.currentItemsCount;
    }

    public final int getCurrentItemsCount() {
        return this.currentItemsCountProperty().get();
    }

    public final void setCurrentItemsCount(int currentItemsCount) {
        this.currentItemsCountProperty().set(currentItemsCount);
    }

    private int count(TreeItem<?> node) {
        if (node == null) {
            return 0;
        }
        int count = 1;
        if (node.getValue() == null || node.getValue() != null && node.getValue().getClass().equals(RecursiveTreeObject.class)) {
            count = 0;
        }
        for (TreeItem child : node.getChildren()) {
            count += this.count(child);
        }
        return count;
    }

    private static /* synthetic */ boolean lambda$new$238(TreeItem t) {
        return true;
    }

    private /* synthetic */ void lambda$buildGroupedRoot$235(RecursiveTreeItem newParent) {
        ArrayList sortOrder = new ArrayList();
        sortOrder.addAll(this.getSortOrder());
        this.setRoot(newParent);
        this.getSortOrder().addAll(sortOrder);
        this.getSelectionModel().select(0);
    }

    private /* synthetic */ void lambda$buildGroupedRoot$234(ObservableValue o, Boolean oldVal, Boolean newVal) {
        this.getSelectionModel().clearSelection();
    }

    private /* synthetic */ void lambda$unGroup$233(List grouped) {
        ArrayList sortOrder = new ArrayList();
        sortOrder.addAll(this.getSortOrder());
        List<Object> children = Arrays.asList(this.originalRoot.getChildren().toArray());
        this.originalRoot.getChildren().clear();
        this.originalRoot.getChildren().setAll(children);
        this.setRoot(this.originalRoot);
        this.getSelectionModel().select(0);
        this.getSortOrder().addAll(sortOrder);
        if (grouped.size() != 0) {
            this.refreshGroups(grouped);
        }
    }

    private /* synthetic */ void lambda$init$232(ObservableValue o, TreeItem oldVal, TreeItem newVal) {
        if (newVal != null) {
            this.setCurrentItemsCount(this.count(this.getRoot()));
        }
    }

    private /* synthetic */ void lambda$init$231(ObservableValue o, Predicate oldVal, Predicate newVal) {
        this.filter(newVal);
    }

    private /* synthetic */ void lambda$init$230(ObservableValue o, TreeItem oldVal, TreeItem newVal) {
        if (newVal != null && newVal.getValue() != null) {
            this.itemWasSelected = true;
        }
    }

    private /* synthetic */ void lambda$propagateMouseEventsToParent$229(MouseEvent e) {
        e.consume();
        this.getParent().fireEvent((Event)e);
    }

    static /* synthetic */ boolean access$lambda$0(TreeItem treeItem) {
        return JFXTreeTableView.lambda$new$238(treeItem);
    }

    static /* synthetic */ boolean access$lambda$1(TreeItem treeItem) {
        return JFXTreeTableView.lambda$new$238(treeItem);
    }

    static /* synthetic */ void access$lambda$2(JFXTreeTableView jFXTreeTableView, MouseEvent mouseEvent) {
        jFXTreeTableView.lambda$propagateMouseEventsToParent$229(mouseEvent);
    }

    static /* synthetic */ void access$lambda$3(JFXTreeTableView jFXTreeTableView, ObservableValue observableValue, TreeItem treeItem, TreeItem treeItem2) {
        jFXTreeTableView.lambda$init$230(observableValue, treeItem, treeItem2);
    }

    static /* synthetic */ void access$lambda$4(JFXTreeTableView jFXTreeTableView, ObservableValue observableValue, Predicate predicate, Predicate predicate2) {
        jFXTreeTableView.lambda$init$231(observableValue, predicate, predicate2);
    }

    static /* synthetic */ void access$lambda$5(JFXTreeTableView jFXTreeTableView, ObservableValue observableValue, TreeItem treeItem, TreeItem treeItem2) {
        jFXTreeTableView.lambda$init$232(observableValue, treeItem, treeItem2);
    }

    static /* synthetic */ void access$lambda$6(JFXTreeTableView jFXTreeTableView, List list) {
        jFXTreeTableView.lambda$unGroup$233(list);
    }

    static /* synthetic */ void access$lambda$7(JFXTreeTableView jFXTreeTableView, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        jFXTreeTableView.lambda$buildGroupedRoot$234(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$8(JFXTreeTableView jFXTreeTableView, RecursiveTreeItem recursiveTreeItem) {
        jFXTreeTableView.lambda$buildGroupedRoot$235(recursiveTreeItem);
    }
}

