/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import java.net.URI;
import java.net.URL;
import java.util.Comparator;
import java.util.LinkedHashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import org.apache.http.HttpHost;
import org.silentsoft.actlist.plugin.DebugApp;
import org.silentsoft.actlist.plugin.DuplicateNameException;
import org.silentsoft.actlist.plugin.PluginConfig;
import org.silentsoft.actlist.plugin.tray.TrayNotification;

public abstract class ActlistPlugin {
    private String version = "1.4.0";
    private String pluginName;
    private SupportedPlatform[] supportedPlatforms;
    private boolean oneTimePlugin;
    private String pluginDescription;
    private URI pluginDescriptionURI;
    private String pluginChangeLog;
    private URI pluginChangeLogURI;
    private String pluginLicense;
    private URI pluginLicenseURI;
    private String pluginVersion;
    private URI pluginUpdateCheckURI;
    private URI pluginArchivesURI;
    private String pluginAuthor;
    private URI pluginAuthorURI;
    private String minimumCompatibleVersion;
    private String warningText;
    private PluginConfig pluginConfig;
    private LinkedHashMap<String, Function> functionMap;
    private ObjectProperty<SupportedPlatform> currentPlatformObject;
    private ObjectProperty<ClassLoader> classLoaderObject;
    private ObjectProperty<HttpHost> proxyHostObject;
    private BooleanProperty shouldShowLoadingBar;
    private ObjectProperty<Throwable> exceptionObject;
    private ObjectProperty<TrayNotification> showTrayNotificationObject;
    private ObjectProperty<TrayNotification> dismissTrayNotificationObject;
    private BooleanProperty shouldDismissTrayNotifications;
    private BooleanProperty shouldBrowseActlistArchives;
    private ObjectProperty<Boolean> shouldRequestShowActlist;
    private BooleanProperty shouldRequestDeactivate;
    Class<?> buildVersionClass;
    private Comparator<String> versionComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            Integer o2Major;
            if (o1.equals(o2)) {
                return 0;
            }
            String[] _o1 = o1.split("\\.");
            String[] _o2 = o2.split("\\.");
            Integer o1Major = Integer.valueOf(_o1[0]);
            int majorCompare = o1Major.compareTo(o2Major = Integer.valueOf(_o2[0]));
            if (majorCompare == 0) {
                Integer o2Minor;
                Integer o1Minor = Integer.valueOf(_o1[1]);
                int minorCompare = o1Minor.compareTo(o2Minor = Integer.valueOf(_o2[1]));
                if (minorCompare == 0) {
                    Integer o1Patch = Integer.valueOf(_o1[2]);
                    Integer o2Patch = Integer.valueOf(_o2[2]);
                    return o1Patch.compareTo(o2Patch);
                }
                return minorCompare;
            }
            return majorCompare;
        }
    };
    private Boolean existsIcon;
    private ImageView icon;
    private Boolean existsGraphic;
    private Node graphic;

    public ActlistPlugin(String pluginName) {
        this.pluginName = pluginName;
        this.oneTimePlugin = false;
        this.functionMap = new LinkedHashMap();
        this.currentPlatformObject = new SimpleObjectProperty(null);
        this.classLoaderObject = new SimpleObjectProperty(null);
        this.proxyHostObject = new SimpleObjectProperty(null);
        this.shouldShowLoadingBar = new SimpleBooleanProperty(false);
        this.exceptionObject = new SimpleObjectProperty(null);
        this.showTrayNotificationObject = new SimpleObjectProperty(null);
        this.dismissTrayNotificationObject = new SimpleObjectProperty(null);
        this.shouldDismissTrayNotifications = new SimpleBooleanProperty(false);
        this.shouldBrowseActlistArchives = new SimpleBooleanProperty(false);
        this.shouldRequestShowActlist = new SimpleObjectProperty(null);
        this.shouldRequestDeactivate = new SimpleBooleanProperty(false);
    }

    protected static void debug() {
        DebugApp.debug();
    }

    protected boolean isDebugMode() {
        return DebugApp.isDebugMode;
    }

    protected abstract void initialize() throws Exception;

    public abstract void pluginActivated() throws Exception;

    public abstract void pluginDeactivated() throws Exception;

    public void pluginUpdateFound() throws Exception {
    }

    public void applicationActivated() throws Exception {
    }

    public void applicationDeactivated() throws Exception {
    }

    public void applicationCloseRequested() throws Exception {
    }

    protected String getActlistVersion() {
        String actlistVersion = null;
        Class<?> buildVersionClass = this.getBuildVersionClass();
        if (buildVersionClass != null) {
            try {
                actlistVersion = (String)buildVersionClass.getField("VERSION").get(null);
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return actlistVersion;
    }

    protected String getActlistBuildTime() {
        String actlistBuildTime = null;
        Class<?> buildVersionClass = this.getBuildVersionClass();
        if (buildVersionClass != null) {
            try {
                actlistBuildTime = (String)buildVersionClass.getField("BUILD_TIME").get(null);
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return actlistBuildTime;
    }

    Class<?> getBuildVersionClass() {
        if (this.buildVersionClass == null) {
            try {
                this.buildVersionClass = Class.forName("org.silentsoft.actlist.version.BuildVersion");
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return this.buildVersionClass;
    }

    protected boolean isActlistVersionLowerThan(int major, int minor, int patch) {
        return this.versionComparator.compare(this.getActlistVersion(), String.format("%d.%d.%d", major, minor, patch)) < 0;
    }

    protected boolean isActlistVersionSameWith(int major, int minor, int patch) {
        return this.versionComparator.compare(this.getActlistVersion(), String.format("%d.%d.%d", major, minor, patch)) == 0;
    }

    protected boolean isActlistVersionHigherThan(int major, int minor, int patch) {
        return this.versionComparator.compare(this.getActlistVersion(), String.format("%d.%d.%d", major, minor, patch)) > 0;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public SupportedPlatform[] getSupportedPlatforms() {
        return this.supportedPlatforms;
    }

    public void setSupportedPlatforms(SupportedPlatform ... supportedPlatforms) {
        this.supportedPlatforms = supportedPlatforms;
    }

    public boolean isOneTimePlugin() {
        return this.oneTimePlugin;
    }

    public void setOneTimePlugin(boolean oneTimePlugin) {
        this.oneTimePlugin = oneTimePlugin;
    }

    public String getPluginDescription() {
        return this.pluginDescription;
    }

    protected void setPluginDescription(String pluginDescription) {
        this.pluginDescription = pluginDescription;
    }

    protected void setPluginDescription(URI uri) {
        this.pluginDescriptionURI = uri;
    }

    public URI getPluginDescriptionURI() {
        return this.pluginDescriptionURI;
    }

    public String getPluginChangeLog() {
        return this.pluginChangeLog;
    }

    protected void setPluginChangeLog(String pluginChangeLog) {
        this.pluginChangeLog = pluginChangeLog;
    }

    protected void setPluginChangeLog(URI uri) {
        this.pluginChangeLogURI = uri;
    }

    public URI getPluginChangeLogURI() {
        return this.pluginChangeLogURI;
    }

    public String getPluginLicense() {
        return this.pluginLicense;
    }

    protected void setPluginLicense(String pluginLicense) {
        this.pluginLicense = pluginLicense;
    }

    protected void setPluginLicense(URI uri) {
        this.pluginLicenseURI = uri;
    }

    public URI getPluginLicenseURI() {
        return this.pluginLicenseURI;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    protected void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getPluginAuthor() {
        return this.pluginAuthor;
    }

    protected void setPluginAuthor(String pluginAuthor) {
        this.pluginAuthor = pluginAuthor;
    }

    protected void setPluginAuthor(String pluginAuthor, URI uri) {
        this.pluginAuthor = pluginAuthor;
        this.pluginAuthorURI = uri;
    }

    public URI getPluginAuthorURI() {
        return this.pluginAuthorURI;
    }

    public URI getPluginArchivesURI() {
        return this.pluginArchivesURI;
    }

    public void setPluginArchivesURI(URI pluginArchivesURI) {
        this.pluginArchivesURI = pluginArchivesURI;
    }

    public URI getPluginUpdateCheckURI() {
        return this.pluginUpdateCheckURI;
    }

    public void setPluginUpdateCheckURI(URI pluginUpdateCheckURI) {
        this.setPluginUpdateCheckURI(pluginUpdateCheckURI, null);
    }

    public void setPluginUpdateCheckURI(URI pluginUpdateCheckURI, URI pluginArchivesURI) {
        this.pluginUpdateCheckURI = pluginUpdateCheckURI;
        this.pluginArchivesURI = pluginArchivesURI;
    }

    public String getMinimumCompatibleVersion() {
        return this.minimumCompatibleVersion;
    }

    protected void setMinimumCompatibleVersion(int major, int minor, int patch) {
        this.minimumCompatibleVersion = String.format("%d.%d.%d", major, minor, patch);
    }

    public String getWarningText() {
        return this.warningText;
    }

    protected void setWarningText(String warningText) {
        this.warningText = warningText;
    }

    PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    private URL getPNG() {
        return this.getClassLoader().getResource(this.getClass().getSimpleName().concat(".png"));
    }

    private URL getFXML() {
        return this.getClassLoader().getResource(this.getClass().getSimpleName().concat(".fxml"));
    }

    public boolean existsIcon() {
        if (this.existsIcon == null) {
            this.existsIcon = true;
            try {
                this.getPNG().openStream().close();
            }
            catch (Exception e) {
                this.existsIcon = false;
            }
        }
        return this.existsIcon;
    }

    public ImageView getIcon() throws Exception {
        if (this.icon == null) {
            this.icon = new ImageView(this.getPNG().toExternalForm());
        }
        return this.icon;
    }

    public boolean existsGraphic() {
        if (this.existsGraphic == null) {
            this.existsGraphic = true;
            try {
                this.getFXML().openStream().close();
            }
            catch (Exception e) {
                this.existsGraphic = false;
            }
        }
        return this.existsGraphic;
    }

    public Node getGraphic() throws Exception {
        if (this.graphic == null) {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getFXML());
            fxmlLoader.setClassLoader(this.getClassLoader());
            fxmlLoader.setController((Object)this);
            this.graphic = (Node)fxmlLoader.load();
        }
        return this.graphic;
    }

    LinkedHashMap<String, Function> getFunctionMap() {
        return this.functionMap;
    }

    ObjectProperty<SupportedPlatform> currentPlatformObject() {
        return this.currentPlatformObject;
    }

    ObjectProperty<ClassLoader> classLoaderObject() {
        return this.classLoaderObject;
    }

    ObjectProperty<HttpHost> proxyHostObject() {
        return this.proxyHostObject;
    }

    BooleanProperty shouldShowLoadingBar() {
        return this.shouldShowLoadingBar;
    }

    ObjectProperty<Throwable> exceptionObject() {
        return this.exceptionObject;
    }

    ObjectProperty<TrayNotification> showTrayNotificationObject() {
        return this.showTrayNotificationObject;
    }

    ObjectProperty<TrayNotification> dismissTrayNotificationObject() {
        return this.dismissTrayNotificationObject;
    }

    BooleanProperty shouldDismissTrayNotifications() {
        return this.shouldDismissTrayNotifications;
    }

    BooleanProperty shouldBrowseActlistArchives() {
        return this.shouldBrowseActlistArchives;
    }

    ObjectProperty<Boolean> shouldRequestShowActlist() {
        return this.shouldRequestShowActlist;
    }

    BooleanProperty shouldRequestDeactivate() {
        return this.shouldRequestDeactivate;
    }

    protected void putFunction(String functionName, Function function) throws DuplicateNameException {
        if (this.getFunctionMap().containsKey(functionName)) {
            throw new DuplicateNameException("The function '{}' is already exists !", new Object[]{functionName});
        }
        this.getFunctionMap().put(functionName, function);
    }

    protected void removeFunction(String functionName) {
        this.getFunctionMap().remove(functionName);
    }

    protected void replaceFunction(String functionName, Function function) {
        this.getFunctionMap().replace(functionName, function);
    }

    public <T> T getConfig(String key) throws Exception {
        return this.getPluginConfig().get(key);
    }

    public void putConfig(String key, Object value) throws Exception {
        this.getPluginConfig().put(key, value);
    }

    public void removeConfig(String key) throws Exception {
        this.getPluginConfig().remove(key);
    }

    public SupportedPlatform getCurrentPlatform() {
        return (SupportedPlatform)((Object)this.currentPlatformObject().get());
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoaderObject().get();
    }

    public HttpHost getProxyHost() {
        return (HttpHost)this.proxyHostObject().get();
    }

    public void showLoadingBar() {
        this.shouldShowLoadingBar().set(true);
    }

    public void hideLoadingBar() {
        this.shouldShowLoadingBar().set(false);
    }

    public void throwException(Throwable exception) {
        this.exceptionObject().set((Object)exception);
    }

    public void showTrayNotification(TrayNotification trayNotification) {
        this.showTrayNotificationObject().set((Object)trayNotification);
    }

    public void dismissTrayNotification(TrayNotification trayNotification) {
        this.dismissTrayNotificationObject().set((Object)trayNotification);
    }

    public void dismissTrayNotifications() {
        this.shouldDismissTrayNotifications().set(true);
    }

    public void browseActlistArchives() {
        this.shouldBrowseActlistArchives().set(true);
    }

    public void requestShowActlist() {
        this.shouldRequestShowActlist().set((Object)true);
    }

    public void requestHideActlist() {
        this.shouldRequestShowActlist().set((Object)false);
    }

    public void requestDeactivate() {
        this.shouldRequestDeactivate().set(true);
    }

    public class GraphicFunction
    extends Function {
        public GraphicFunction(Node graphic, Runnable action) {
            super(graphic, action);
        }
    }

    public class TextFunction
    extends Function {
        public TextFunction(String text, Runnable action) {
            super((Node)new Label(text), action);
        }
    }

    public class Function {
        Node graphic;
        Runnable action;

        Function(Node graphic, Runnable action) {
            this.graphic = graphic;
            this.action = action;
        }
    }

    public static enum SupportedPlatform {
        WINDOWS,
        MACOSX;

    }
}

