/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.core.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);
    public static final String DATEFORMAT_TIME_NORMAL = "hh:mm:ss";
    public static final String DATEFORMAT_WINDOWS_NORMAL = "yy-MM-dd";
    public static final String DATEFORMAT_WINDOWS_BLENDED = "MM-dd-yy";
    public static final String DATEFORMAT_WINDOWS_REVERSE = "dd-MM-yy";
    public static final String DATEFORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String DATEFORMAT_YYYYMMDD_MASK = "yyyy-MM-dd";
    public static final String DATEFORMAT_YYYYMMDDHHMMSS = "yyyyMMddhhmmss";
    public static final String DATEFORMAT_YYYYMMDDHHMMSS_MASK = "yyyy-MM-dd hh:mm:ss";
    public static final String DATEFORMAT_YYYYMMDDHH24MISS = "YYYYMMDDHH24MISS";
    public static final String DATEFORMAT_YYYYMMDDHH24MISS_MASK = "YYYY-MM-DD HH24:MI:SS";
    public static final char UPPER_CHAR_YEAR = 'Y';
    public static final char UPPER_CHAR_MONTH = 'M';
    public static final char UPPER_CHAR_DATE = 'D';
    public static final String UPPER_STR_YMD = "YMD";
    public static final String UPPER_STR_MDY = "MDY";
    public static final String UPPER_STR_DMY = "DMY";

    private static boolean isContain(char source, char[] target) {
        for (char c : target) {
            if (Character.compare(c, source) != 0) continue;
            return true;
        }
        return false;
    }

    private static Date getBigDate(Date date1, Date date2) {
        return date1.compareTo(date2) > 0 ? date1 : date2;
    }

    private static Date getSmallDate(Date date1, Date date2) {
        return date1.compareTo(date2) > 0 ? date2 : date1;
    }

    public static String getDateAsStr(Date date, String format) {
        return new SimpleDateFormat(format, Locale.ENGLISH).format(date);
    }

    public static String getDateAsStr(String date, String fromFormat, String toFormat) {
        String returnDate = "";
        try {
            returnDate = new SimpleDateFormat(toFormat).format(new SimpleDateFormat(fromFormat).parse(date));
        }
        catch (ParseException e) {
            returnDate = date;
        }
        return returnDate;
    }

    public static String getSystemDateAsStr(String format) {
        return new SimpleDateFormat(format).format(new Date());
    }

    public static String getSystemDateFormat() {
        char[] localFormat = new SimpleDateFormat().toPattern().toCharArray();
        char[] dateChars = new char[]{'Y', 'M', 'D'};
        StringBuffer patternFormat = new StringBuffer();
        for (char cFormat : localFormat) {
            if (dateChars.length <= patternFormat.length()) break;
            if (!DateUtil.isContain(cFormat = Character.toUpperCase(cFormat), dateChars) || DateUtil.isContain(cFormat, patternFormat.toString().toCharArray())) continue;
            patternFormat.append(cFormat);
        }
        switch (patternFormat.toString()) {
            case "YMD": {
                return DATEFORMAT_WINDOWS_NORMAL;
            }
            case "MDY": {
                return DATEFORMAT_WINDOWS_BLENDED;
            }
            case "DMY": {
                return DATEFORMAT_WINDOWS_REVERSE;
            }
        }
        LOGGER.error("Not defined system date format <{}>", new Object[]{patternFormat.toString()});
        return null;
    }

    public static void setSystemDateByNTP(String serverIp) throws IOException {
        DateUtil.setSystemDate(DateUtil.getServerDate(serverIp));
    }

    public static Date getServerDate(String serverIp) {
        NTPUDPClient client = new NTPUDPClient();
        client.setDefaultTimeout(10000);
        try {
            client.open();
            try {
                InetAddress hostAddr = InetAddress.getByName(serverIp);
                NtpV3Packet message = client.getTime(hostAddr).getMessage();
                return message.getReceiveTimeStamp().getDate();
            }
            catch (IOException ioe) {
                LOGGER.error(ioe.toString());
            }
        }
        catch (SocketException e) {
            LOGGER.error(e.toString());
        }
        return null;
    }

    public static void setSystemDate(Date date) throws IOException {
        String strSysDateFormat = DateUtil.getSystemDateFormat();
        if (strSysDateFormat != null) {
            String strDate = DateUtil.getDateAsStr(date, strSysDateFormat);
            String strTime = DateUtil.getDateAsStr(date, DATEFORMAT_TIME_NORMAL);
            DateUtil.setSystemDate(strDate, strTime);
        } else {
            LOGGER.error("Cannot change system date. It may cause wrong format !");
        }
    }

    public static void setSystemDate(String date, String time) throws IOException {
        Runtime.getRuntime().exec("cmd /c date " + date);
        Runtime.getRuntime().exec("cmd /c time " + time);
    }

    public static int getDifferenceSeconds(Date date1, Date date2) {
        return DateUtil.getDifference(date1, date2, TimeType.SECONDS);
    }

    public static int getDifferenceSecondsFromNow(Date date) {
        return DateUtil.getDifference(new Date(), date, TimeType.SECONDS);
    }

    public static int getDifferenceMinutes(Date date1, Date date2) {
        return DateUtil.getDifference(date1, date2, TimeType.MINUTES);
    }

    public static int getDifferenceMinutesFromNow(Date date) {
        return DateUtil.getDifference(new Date(), date, TimeType.MINUTES);
    }

    public static int getDifferenceHours(Date date1, Date date2) {
        return DateUtil.getDifference(date1, date2, TimeType.HOURS);
    }

    public static int getDifferenceHoursFromNow(Date date) {
        return DateUtil.getDifference(new Date(), date, TimeType.HOURS);
    }

    public static int getDifferenceDays(Date date1, Date date2) {
        return DateUtil.getDifference(date1, date2, TimeType.DAYS);
    }

    public static int getDifferenceDaysFromNow(Date date) {
        return DateUtil.getDifference(new Date(), date, TimeType.DAYS);
    }

    public static int getDifferenceWeeks(Date date1, Date date2) {
        return DateUtil.getDifference(date1, date2, TimeType.WEEKS);
    }

    public static int getDifferenceWeeksFromNow(Date date) {
        return DateUtil.getDifference(new Date(), date, TimeType.WEEKS);
    }

    public static int getDifference(Date date1, Date date2, TimeType timeType) {
        int difference = 0;
        long diff = Math.abs(DateUtil.getBigDate(date1, date2).getTime() - DateUtil.getSmallDate(date1, date2).getTime());
        switch (timeType) {
            case SECONDS: {
                difference = (int)(diff / 1000L);
                break;
            }
            case MINUTES: {
                difference = (int)(diff / 60000L);
                break;
            }
            case HOURS: {
                difference = (int)(diff / 3600000L);
                break;
            }
            case DAYS: {
                difference = (int)(diff / 86400000L);
                break;
            }
            case WEEKS: {
                difference = (int)(diff / 604800000L);
            }
        }
        return difference;
    }

    public static enum TimeType {
        SECONDS,
        MINUTES,
        HOURS,
        DAYS,
        WEEKS;

    }
}

