/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.io.event;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.silentsoft.io.event.EventHistory;
import org.silentsoft.io.event.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHandler.class);
    private static final int MAX_THREAD_POOL = 5;
    private static int historyCapacity = 0;
    private static List<EventHistory> histories = new CopyOnWriteArrayList<EventHistory>();
    private static List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();

    static {
        EventHandler.initHistory(100);
    }

    public static synchronized void initHistory(int capacity) {
        EventHandler.getHistories().clear();
        EventHandler.setHistoryCapacity(capacity);
    }

    public static synchronized List<EventHistory> getHistories() {
        return histories;
    }

    private static synchronized void setHistoryCapacity(int capacity) {
        historyCapacity = capacity;
    }

    private static synchronized void addHistory(EventHistory eventHistory) {
        if (EventHandler.getHistoryCapacity() > 0) {
            if (EventHandler.getHistories().size() >= EventHandler.getHistoryCapacity()) {
                EventHandler.getHistories().remove(0);
            }
            EventHandler.getHistories().add(eventHistory);
        }
        eventHistory = null;
    }

    private static synchronized int getHistoryCapacity() {
        return historyCapacity;
    }

    public static synchronized void addListener(EventListener eventListener) {
        if (EventHandler.getListeners().indexOf(eventListener) == -1) {
            EventHandler.getListeners().add(eventListener);
        }
    }

    private static synchronized List<EventListener> getListeners() {
        return listeners;
    }

    public static synchronized void removeListener(EventListener eventListener) {
        if (EventHandler.getListeners().indexOf(eventListener) != -1) {
            EventHandler.getListeners().remove(eventListener);
        }
    }

    public static synchronized void callEvent(Class<?> caller, String event) {
        EventHandler.callEvent(caller, event, true);
    }

    public static synchronized void callEvent(Class<?> caller, String event, boolean doAsynch) {
        EventHandler.addHistory(new EventHistory(EventHistory.EventType.OCCUR, event, doAsynch, caller, null));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[Event occur : <{}> by <{}>]", new Object[]{event, caller.getName()});
        }
        if (doAsynch) {
            EventHandler.callEventByAsynch(caller, event);
        } else {
            EventHandler.callEventBySynch(caller, event);
        }
    }

    private static synchronized void callEventByAsynch(Class<?> caller, String event) {
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        for (EventListener listener : listeners) {
            executorService.execute(EventHandler.createEventStub(caller, event, listener, true));
        }
        executorService.shutdown();
    }

    private static synchronized void callEventBySynch(Class<?> caller, String event) {
        for (EventListener listener : listeners) {
            EventHandler.createEventStub(caller, event, listener, false).run();
        }
    }

    private static synchronized Runnable createEventStub(final Class<?> caller, final String event, final EventListener listener, final boolean isAsynch) {
        return new Runnable(){

            @Override
            public void run() {
                if (listener.getClass().getName().equals(caller.getName())) {
                    EventHandler.addHistory(new EventHistory(EventHistory.EventType.SKIP, event, isAsynch, caller, listener));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[Event skip : <{}> by self <{}>]", new Object[]{event, caller.getName()});
                    }
                } else {
                    EventHandler.addHistory(new EventHistory(EventHistory.EventType.CATCH, event, isAsynch, caller, listener));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[Event catch : <{}> by <{}>]", new Object[]{event, listener.getClass().getName()});
                    }
                    try {
                        EventHandler.addHistory(new EventHistory(EventHistory.EventType.SCHEDULED, event, isAsynch, caller, listener));
                        listener.onEvent(event);
                        EventHandler.addHistory(new EventHistory(EventHistory.EventType.PROCESSED, event, isAsynch, caller, listener));
                    }
                    catch (Exception e) {
                        EventHandler.addHistory(new EventHistory(EventHistory.EventType.FAILURE, event, isAsynch, caller, listener));
                        LOGGER.error("[Event failure : <{}> on <{}>]", new Object[]{event, listener.getClass().getName(), e});
                    }
                }
            }
        };
    }
}

