/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.ui.viewer;

import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import org.silentsoft.ui.viewer.AbstractViewerController;
import org.silentsoft.ui.viewer.Terminatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractViewer
implements Terminatable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractViewer.class);
    private Parent viewer;
    private AbstractViewerController controller;

    public AbstractViewer(Object ... parameters) {
        this(null, parameters);
    }

    public AbstractViewer(ResourceBundle resources) {
        this(resources, new Object[0]);
    }

    public AbstractViewer(ResourceBundle resources, Object ... parameters) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource(this.getClass().getSimpleName().concat(".fxml")));
            if (resources != null) {
                fxmlLoader.setResources(resources);
            }
            this.viewer = (Parent)fxmlLoader.load();
            this.controller = (AbstractViewerController)fxmlLoader.getController();
            this.viewer.sceneProperty().addListener((observable, oldValue, newValue) -> {
                if (oldValue == null && newValue != null) {
                    Platform.runLater(() -> this.controller.initialize(this.viewer, parameters));
                } else if (oldValue != null && newValue == null) {
                    Platform.runLater(() -> {
                        this.controller.terminate();
                        this.controller = null;
                        this.terminate();
                        this.viewer = null;
                    });
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("I got catch an error during initialize the viewer !", (Throwable)e);
        }
    }

    @Override
    public void terminate() {
    }

    public Parent getViewer() {
        return this.viewer;
    }
}

