/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.ui.component.popup;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.silentsoft.ui.component.popup.PopupController;
import org.silentsoft.ui.util.StageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Popup {
    private static final Logger LOGGER = LoggerFactory.getLogger(Popup.class);
    private static Map<Parent, Map<Stage, Effect>> popupMap = new HashMap<Parent, Map<Stage, Effect>>();

    public static void show(Window owner, final Node backgroundNode, String title, final Parent popup, final CloseType closeType, boolean isModal, final boolean showColorAdjustEffect) {
        if (popup == null) {
            return;
        }
        Parent parent = null;
        PopupController controller = null;
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(Popup.class.getResource(Popup.class.getSimpleName().concat(".fxml")));
            parent = (Parent)fxmlLoader.load();
            controller = (PopupController)fxmlLoader.getController();
            controller.initialize(backgroundNode, title, popup, closeType);
        }
        catch (IOException e) {
            LOGGER.error("Popup show failure !");
            LOGGER.error(e.toString());
        }
        if (parent == null || controller == null) {
            return;
        }
        Stage stage = new Stage();
        StageUtil.registerStage(stage);
        stage.initOwner(owner);
        if (isModal) {
            stage.initModality(Modality.APPLICATION_MODAL);
        } else {
            stage.initModality(Modality.NONE);
        }
        if (closeType == CloseType.PLATFORM_FRAME_BASE) {
            stage.initStyle(StageStyle.DECORATED);
        } else {
            stage.initStyle(StageStyle.TRANSPARENT);
        }
        stage.setTitle(title);
        HashMap<Stage, Effect> value = new HashMap<Stage, Effect>();
        value.put(stage, backgroundNode.getEffect());
        popupMap.put(popup, value);
        stage.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!oldValue.booleanValue() && newValue.booleanValue()) {
                    if (backgroundNode != null) {
                        if (showColorAdjustEffect) {
                            backgroundNode.setEffect((Effect)new ColorAdjust(0.0, 0.0, -0.5, 0.0));
                        }
                        backgroundNode.setDisable(true);
                    }
                } else if (oldValue.booleanValue() && !newValue.booleanValue() && closeType == CloseType.FOCUS_BASE) {
                    Popup.close(popup, backgroundNode);
                }
            }
        });
        stage.setScene(new Scene(parent));
        stage.setX(owner.getX() + owner.getWidth() / 2.0 - parent.prefWidth(0.0) / 2.0);
        stage.setY(owner.getY() + owner.getHeight() / 2.0 - parent.prefHeight(0.0) / 2.0);
        if (isModal) {
            stage.showAndWait();
        } else {
            stage.show();
        }
    }

    public static void close(Parent popup, Node backgroundNode) {
        Map.Entry<Stage, Effect> entrySet;
        Stage stage;
        if (popup == null) {
            return;
        }
        Iterator<Map.Entry<Stage, Effect>> iterator = popupMap.get(popup).entrySet().iterator();
        if (iterator.hasNext() && (stage = (entrySet = iterator.next()).getKey()) != null) {
            stage.close();
            if (backgroundNode != null) {
                backgroundNode.setEffect(entrySet.getValue());
                backgroundNode.setDisable(false);
            }
            popupMap.remove(popup);
        }
    }

    public static enum CloseType {
        FOCUS_BASE,
        BUTTON_BASE,
        BUILT_IN_BASE,
        PLATFORM_FRAME_BASE;

    }
}

