/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import org.silentsoft.ui.model.Delta;
import org.silentsoft.ui.model.MaximizeProperty;
import org.silentsoft.ui.util.StageDragResizer;

public class Console {
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane head;
    @FXML
    private AnchorPane body;
    @FXML
    private Button appMinimizeBtn;
    @FXML
    private Button appMaximizeBtn;
    @FXML
    private Button appCloseBtn;
    @FXML
    private TextArea console;
    private PrintStream printStream;
    private MaximizeProperty maximizeProperty;

    public void initialize(Stage stage) {
        this.console.setContextMenu(new ContextMenu());
        this.printStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int n) throws IOException {
                Platform.runLater(() -> Console.this.console.appendText(String.valueOf((char)n)));
            }
        }, true);
        this.maximizeProperty = new MaximizeProperty(stage);
        this.makeDraggable(stage, (Node)this.head);
        this.makeNormalizable(stage, (Node)this.head);
        this.makeMinimizable(stage, (Node)this.appMinimizeBtn);
        this.makeMaximizable(stage, (Node)this.appMaximizeBtn);
        this.makeClosable(stage, (Node)this.appCloseBtn);
        this.makeResizable(stage, (Region)this.root);
    }

    private void makeDraggable(Stage stage, Node node) {
        Delta delta = new Delta();
        node.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                delta.setX(stage.getX() - mouseEvent.getScreenX());
                delta.setY(stage.getY() - mouseEvent.getScreenY());
                node.setOpacity(0.8);
            }
        });
        node.setOnMouseDragged(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (this.maximizeProperty.isMaximized()) {
                    double d = mouseEvent.getScreenX() - stage.getX();
                    double d2 = mouseEvent.getScreenY() - stage.getY();
                    this.changeMaximizeProperty(stage);
                    delta.setX(-1.0 * (stage.getWidth() / 2.0));
                    delta.setY(-1.0 * mouseEvent.getSceneY());
                } else {
                    stage.setX(mouseEvent.getScreenX() + delta.getX());
                    stage.setY(mouseEvent.getScreenY() + delta.getY());
                }
            }
        });
        node.setOnMouseReleased(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                node.setOpacity(1.0);
            }
        });
    }

    private void makeNormalizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getClickCount() >= 2) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeMinimizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                stage.setIconified(true);
            }
        });
    }

    private void makeMaximizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeClosable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                stage.close();
            }
        });
    }

    private void makeResizable(Stage stage, Region region) {
        StageDragResizer.makeResizable((Stage)stage, (Region)region, (int)7, (int)10);
    }

    private void changeMaximizeProperty(Stage stage) {
        this.maximizeProperty.setMaximized(stage, !this.maximizeProperty.isMaximized());
        if (this.maximizeProperty.isMaximized()) {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.head, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.head, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.head, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)25.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)0.0);
        } else {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setLeftAnchor((Node)this.head, (Double)2.0);
            AnchorPane.setRightAnchor((Node)this.head, (Double)2.0);
            AnchorPane.setTopAnchor((Node)this.head, (Double)2.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)27.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)2.0);
        }
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }
}

