/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.io.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class DataSet {
    private Map<String, Map<Integer, Object>> column = new TreeMap<String, Map<Integer, Object>>();
    private Map<Integer, Map<String, Map<Integer, Object>>> dataset = new TreeMap<Integer, Map<String, Map<Integer, Object>>>();

    public DataSet(String[] columnName) {
        int nColCnt = columnName.length;
        int i = 0;
        while (i < nColCnt) {
            this.column.put(columnName[i], new HashMap());
            this.column.get(columnName[i]).put(i, new Object());
            ++i;
        }
    }

    public int getColumn(String sName) {
        return this.column.get(sName).keySet().iterator().next();
    }

    public String getColumnName(int nCol) {
        String colName = "";
        Iterator<String> colNameItr = this.column.keySet().iterator();
        while ((colName = colNameItr.next()) != null) {
            if (this.column.get(colName).keySet().iterator().next() == nCol) break;
        }
        return colName;
    }

    public int getColumnCount() {
        return this.column.size();
    }

    public int getRowCount() {
        return this.dataset.size();
    }

    public Object getData(int nRow, int nCol) {
        return this.dataset.get(nRow).get(this.getColumnName(nCol)).values().iterator().next();
    }

    public void setData(int nRow, int nCol, Object oValue) {
        this.dataset.get(nRow).get(this.getColumnName(nCol)).put(nCol, oValue);
    }

    public Object getDataByName(String sName, int nRow) {
        return this.dataset.get(nRow).get(sName).values().iterator().next();
    }

    public void setDataByName(String sName, int nRow, Object oValue) {
        this.dataset.get(nRow).get(sName).put(this.getColumn(sName), oValue);
    }

    public void init() {
        int nLength = this.getRowCount();
        int i = 0;
        while (i < nLength) {
            this.removeRow(i);
            ++i;
        }
    }

    public void insertRow(int nRow) {
        int nRowCnt = this.getRowCount();
        int nColCnt = this.getColumnCount();
        TreeMap column = new TreeMap();
        int i = 0;
        while (i < nColCnt) {
            column.put(this.getColumnName(i), new HashMap());
            ((Map)column.get(this.getColumnName(i))).put(this.column.get(this.getColumnName(i)).keySet().iterator().next(), new Object());
            ++i;
        }
        i = 0;
        while (i < nRow) {
            if (this.dataset.get(i) == null) {
                this.dataset.put(i, column);
            }
            ++i;
        }
        if (this.dataset.get(nRow) != null) {
            i = nRowCnt - 1;
            while (i >= nRow) {
                this.dataset.put(i + 1, this.dataset.get(i));
                --i;
            }
        }
        this.dataset.put(nRow, column);
    }

    public void removeRow(int nRowIdx) {
        int nRowCnt = this.getRowCount();
        int i = nRowIdx + 1;
        while (i < nRowCnt) {
            this.dataset.put(i - 1, this.dataset.get(i));
            ++i;
        }
        this.dataset.remove(nRowCnt - 1);
    }
}

