/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$1;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$10;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$11;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$2;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$3;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$4;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$5;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$6;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$7;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$8;
import com.jfoenix.skins.JFXTimePickerContent$$Lambda$9;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.chrono.Chronology;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;
import javafx.util.converter.LocalTimeStringConverter;
import javafx.util.converter.NumberStringConverter;

public class JFXTimePickerContent
extends VBox {
    protected JFXDatePicker datePicker;
    private Color fadedColor = Color.rgb((int)255, (int)255, (int)255, (double)0.67);
    private double contentCircleRadius = 100.0;
    private Label selectedHourLabel = new Label();
    private Label selectedMinLabel = new Label();
    private Label periodPMLabel;
    private Label periodAMLabel;
    private StackPane calendarPlaceHolder = new StackPane();
    private StackPane hoursContent;
    private StackPane minutesContent;
    private Rotate hoursPointerRotate;
    private Rotate minsPointerRotate;
    private ObjectProperty<TimeUnit> unit = new SimpleObjectProperty((Object)TimeUnit.HOURS);
    private DoubleProperty angle = new SimpleDoubleProperty(Math.toDegrees(0.5235987755982988));
    private StringProperty period = new SimpleStringProperty("AM");
    private ObjectProperty<Rotate> pointerRotate = new SimpleObjectProperty();
    private ObjectProperty<Label> timeLabel = new SimpleObjectProperty();
    private NumberStringConverter unitConverter = new NumberStringConverter("#00");
    private ObjectProperty<LocalTime> selectedTime = new SimpleObjectProperty((Object)this, "selectedTime");

    ObjectProperty<LocalTime> displayedTimeProperty() {
        return this.selectedTime;
    }

    JFXTimePickerContent(DatePicker datePicker) {
        this.datePicker = (JFXDatePicker)datePicker;
        LocalTime time = this.datePicker.getTime() == null ? LocalTime.now() : this.datePicker.getTime();
        this.datePicker.timeProperty().addListener(JFXTimePickerContent$$Lambda$1.lambdaFactory$(this));
        this.getStyleClass().add((Object)"date-picker-popup");
        this.getChildren().add((Object)this.createHeaderPane(time));
        VBox contentHolder = new VBox();
        contentHolder.getChildren().add((Object)this.createContentPane(time));
        this.calendarPlaceHolder.getChildren().add((Object)contentHolder);
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.calendarPlaceHolder.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.calendarPlaceHolder.heightProperty());
        this.calendarPlaceHolder.setClip((Node)clip);
        StackPane contentPlaceHolder = new StackPane(new Node[]{this.calendarPlaceHolder});
        this.getChildren().add((Object)contentPlaceHolder);
        this.unit.addListener(JFXTimePickerContent$$Lambda$2.lambdaFactory$(this));
        this.period.addListener(JFXTimePickerContent$$Lambda$3.lambdaFactory$(this));
    }

    void init() {
        this.calendarPlaceHolder.setOpacity(1.0);
        this.selectedHourLabel.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
    }

    protected StackPane createHeaderPane(LocalTime time) {
        int hour = time.getHour();
        this.selectedHourLabel.setText((hour % 12 == 0 ? 12 : hour % 12) + "");
        this.selectedHourLabel.getStyleClass().add((Object)"spinner-label");
        this.selectedHourLabel.setTextFill((Paint)Color.WHITE);
        this.selectedHourLabel.setFont(Font.font((String)"Roboto", (FontWeight)FontWeight.BOLD, (double)42.0));
        this.selectedHourLabel.setOnMouseClicked(JFXTimePickerContent$$Lambda$4.lambdaFactory$(this));
        this.selectedHourLabel.setMinWidth(49.0);
        this.selectedHourLabel.setAlignment(Pos.CENTER_RIGHT);
        this.timeLabel.set((Object)this.selectedHourLabel);
        this.selectedMinLabel.setText(this.unitConverter.toString((Number)time.getMinute()) + "");
        this.selectedMinLabel.getStyleClass().add((Object)"spinner-label");
        this.selectedMinLabel.setTextFill((Paint)this.fadedColor);
        this.selectedMinLabel.setFont(Font.font((String)"Roboto", (FontWeight)FontWeight.BOLD, (double)42.0));
        this.selectedMinLabel.setOnMouseClicked(JFXTimePickerContent$$Lambda$5.lambdaFactory$(this));
        Label separatorLabel = new Label(":");
        separatorLabel.setPadding(new Insets(0.0, 0.0, 4.0, 0.0));
        separatorLabel.setTextFill((Paint)this.fadedColor);
        separatorLabel.setFont(Font.font((String)"Roboto", (FontWeight)FontWeight.BOLD, (double)42.0));
        this.periodPMLabel = new Label("PM");
        this.periodPMLabel.getStyleClass().add((Object)"spinner-label");
        this.periodPMLabel.setTextFill((Paint)this.fadedColor);
        this.periodPMLabel.setFont(Font.font((String)"Roboto", (FontWeight)FontWeight.BOLD, (double)14.0));
        this.periodPMLabel.setOnMouseClicked(JFXTimePickerContent$$Lambda$6.lambdaFactory$(this));
        this.periodAMLabel = new Label("AM");
        this.periodAMLabel.getStyleClass().add((Object)"spinner-label");
        this.periodAMLabel.setTextFill((Paint)this.fadedColor);
        this.periodAMLabel.setFont(Font.font((String)"Roboto", (FontWeight)FontWeight.BOLD, (double)14.0));
        this.periodAMLabel.setOnMouseClicked(JFXTimePickerContent$$Lambda$7.lambdaFactory$(this));
        if (hour < 12) {
            this.periodAMLabel.setTextFill((Paint)Color.WHITE);
        } else {
            this.periodPMLabel.setTextFill((Paint)Color.WHITE);
        }
        this.period.set((Object)(hour < 12 ? "AM" : "PM"));
        VBox periodContainer = new VBox();
        periodContainer.setPadding(new Insets(0.0, 0.0, 0.0, 4.0));
        periodContainer.getChildren().addAll((Object[])new Node[]{this.periodAMLabel, this.periodPMLabel});
        HBox selectedTimeContainer = new HBox();
        selectedTimeContainer.getStyleClass().add((Object)"spinner");
        selectedTimeContainer.getChildren().addAll((Object[])new Node[]{this.selectedHourLabel, separatorLabel, this.selectedMinLabel, periodContainer});
        selectedTimeContainer.setAlignment(Pos.CENTER);
        selectedTimeContainer.setFillHeight(false);
        StackPane headerPanel = new StackPane();
        headerPanel.getStyleClass().add((Object)"time-pane");
        headerPanel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.datePicker.getDefaultColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        headerPanel.setPadding(new Insets(8.0, 24.0, 8.0, 24.0));
        headerPanel.getChildren().add((Object)selectedTimeContainer);
        return headerPanel;
    }

    protected BorderPane createContentPane(LocalTime time) {
        Circle circle = new Circle(this.contentCircleRadius);
        circle.setFill((Paint)Color.rgb((int)224, (int)224, (int)224, (double)0.67));
        EventHandler mouseActionHandler = JFXTimePickerContent$$Lambda$8.lambdaFactory$(this);
        circle.setOnMousePressed(mouseActionHandler);
        circle.setOnMouseDragged(mouseActionHandler);
        this.hoursContent = this.createHoursContent(time);
        this.hoursContent.setMouseTransparent(true);
        this.minutesContent = this.createMinutesContent(time);
        this.minutesContent.setOpacity(0.0);
        this.minutesContent.setMouseTransparent(true);
        StackPane contentPane = new StackPane();
        contentPane.getChildren().addAll((Object[])new Node[]{circle, this.hoursContent, this.minutesContent});
        contentPane.setPadding(new Insets(12.0));
        BorderPane contentContainer = new BorderPane();
        contentContainer.setCenter((Node)contentPane);
        contentContainer.setMinHeight(50.0);
        contentContainer.setPadding(new Insets(2.0, 12.0, 2.0, 12.0));
        return contentContainer;
    }

    private StackPane createMinutesContent(LocalTime time) {
        StackPane minsPointer = new StackPane();
        Circle selectionCircle = new Circle(this.contentCircleRadius / 6.0);
        selectionCircle.fillProperty().bind(this.datePicker.defaultColorProperty());
        Circle minCircle = new Circle(selectionCircle.getRadius() / 8.0);
        minCircle.setFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
        minCircle.setTranslateX(selectionCircle.getRadius() - minCircle.getRadius());
        minCircle.setVisible(time.getMinute() % 5 != 0);
        this.selectedMinLabel.textProperty().addListener(JFXTimePickerContent$$Lambda$9.lambdaFactory$(minCircle));
        double shift = 9.0;
        Line line = new Line(shift, 0.0, this.contentCircleRadius, 0.0);
        line.fillProperty().bind(this.datePicker.defaultColorProperty());
        line.strokeProperty().bind((ObservableValue)line.fillProperty());
        line.setStrokeWidth(1.5);
        minsPointer.getChildren().addAll((Object[])new Node[]{line, selectionCircle, minCircle});
        StackPane.setAlignment((Node)selectionCircle, (Pos)Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)minCircle, (Pos)Pos.CENTER_LEFT);
        Group pointerGroup = new Group();
        pointerGroup.getChildren().add((Object)minsPointer);
        pointerGroup.setTranslateX((-this.contentCircleRadius + shift) / 2.0);
        this.minsPointerRotate = new Rotate(0.0, this.contentCircleRadius - shift, selectionCircle.getRadius());
        pointerGroup.getTransforms().add((Object)this.minsPointerRotate);
        Pane clockLabelsContainer = new Pane();
        double radius = this.contentCircleRadius - shift - selectionCircle.getRadius();
        for (int i = 0; i < 12; ++i) {
            StackPane labelContainer = new StackPane();
            int val = (i + 3) * 5 % 60 == 0 ? 0 : (i + 3) * 5 % 60;
            Label label = new Label(this.unitConverter.toString((Number)val) + "");
            label.setFont(Font.font((String)"Roboto", (FontWeight)FontWeight.BOLD, (double)12.0));
            if (val == time.getMinute()) {
                label.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
            } else {
                label.setTextFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.87));
            }
            this.selectedMinLabel.textProperty().addListener(JFXTimePickerContent$$Lambda$10.lambdaFactory$(label));
            labelContainer.getChildren().add((Object)label);
            double labelSize = selectionCircle.getRadius() / Math.sqrt(2.0) * 2.0;
            labelContainer.setMinSize(labelSize, labelSize);
            double angle = (double)(2 * i) * Math.PI / 12.0;
            double xOffset = radius * Math.cos(angle);
            double yOffset = radius * Math.sin(angle);
            double startx = this.contentCircleRadius + xOffset;
            double starty = this.contentCircleRadius + yOffset;
            labelContainer.setLayoutX(startx - labelContainer.getMinWidth() / 2.0);
            labelContainer.setLayoutY(starty - labelContainer.getMinHeight() / 2.0);
            clockLabelsContainer.getChildren().add((Object)labelContainer);
        }
        this.minsPointerRotate.setAngle(180.0 + (double)((time.getMinute() + 45) % 60) * Math.toDegrees(0.10471975511965977));
        return new StackPane(new Node[]{pointerGroup, clockLabelsContainer});
    }

    private StackPane createHoursContent(LocalTime time) {
        StackPane hoursPointer = new StackPane();
        Circle selectionCircle = new Circle(this.contentCircleRadius / 6.0);
        selectionCircle.fillProperty().bind(this.datePicker.defaultColorProperty());
        double shift = 9.0;
        Line line = new Line(shift, 0.0, this.contentCircleRadius, 0.0);
        line.fillProperty().bind(this.datePicker.defaultColorProperty());
        line.strokeProperty().bind((ObservableValue)line.fillProperty());
        line.setStrokeWidth(1.5);
        hoursPointer.getChildren().addAll((Object[])new Node[]{line, selectionCircle});
        StackPane.setAlignment((Node)selectionCircle, (Pos)Pos.CENTER_LEFT);
        Group pointerGroup = new Group();
        pointerGroup.getChildren().add((Object)hoursPointer);
        pointerGroup.setTranslateX((-this.contentCircleRadius + shift) / 2.0);
        this.hoursPointerRotate = new Rotate(0.0, this.contentCircleRadius - shift, selectionCircle.getRadius());
        this.pointerRotate.set((Object)this.hoursPointerRotate);
        pointerGroup.getTransforms().add((Object)this.hoursPointerRotate);
        Pane clockLabelsContainer = new Pane();
        double radius = this.contentCircleRadius - shift - selectionCircle.getRadius();
        for (int i = 0; i < 12; ++i) {
            int val = (i + 3) % 12 == 0 ? 12 : (i + 3) % 12;
            Label label = new Label(val + "");
            label.setFont(Font.font((String)"Roboto", (FontWeight)FontWeight.BOLD, (double)12.0));
            if (val == time.getHour() % 12 || val == 12 && time.getHour() % 12 == 0) {
                label.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
            } else {
                label.setTextFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.87));
            }
            this.selectedHourLabel.textProperty().addListener(JFXTimePickerContent$$Lambda$11.lambdaFactory$(label));
            StackPane labelContainer = new StackPane();
            labelContainer.getChildren().add((Object)label);
            double labelSize = selectionCircle.getRadius() / Math.sqrt(2.0) * 2.0;
            labelContainer.setMinSize(labelSize, labelSize);
            double angle = (double)(2 * i) * Math.PI / 12.0;
            double xOffset = radius * Math.cos(angle);
            double yOffset = radius * Math.sin(angle);
            double startx = this.contentCircleRadius + xOffset;
            double starty = this.contentCircleRadius + yOffset;
            labelContainer.setLayoutX(startx - labelContainer.getMinWidth() / 2.0);
            labelContainer.setLayoutY(starty - labelContainer.getMinHeight() / 2.0);
            clockLabelsContainer.getChildren().add((Object)labelContainer);
            if (val != time.getHour() % 12 && (val != 12 || time.getHour() % 12 != 0)) continue;
            this.hoursPointerRotate.setAngle(180.0 + Math.toDegrees(angle));
        }
        return new StackPane(new Node[]{pointerGroup, clockLabelsContainer});
    }

    private void swapLabelsColor(Label lbl1, Label lbl2) {
        Paint color = lbl1.getTextFill();
        lbl1.setTextFill(lbl2.getTextFill());
        lbl2.setTextFill(color);
    }

    private void switchTimeUnit(TimeUnit newVal) {
        if (newVal == TimeUnit.HOURS) {
            Timeline fadeout = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.minutesContent.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)})});
            Timeline fadein = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.hoursContent.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})});
            new ParallelTransition(new Animation[]{fadeout, fadein}).play();
        } else {
            Timeline fadeout = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.hoursContent.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)})});
            Timeline fadein = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.minutesContent.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})});
            new ParallelTransition(new Animation[]{fadeout, fadein}).play();
        }
    }

    void updateValue() {
        LocalTimeStringConverter converter = new LocalTimeStringConverter(FormatStyle.SHORT, Locale.ENGLISH);
        this.datePicker.setTime(converter.fromString(this.selectedHourLabel.getText() + ":" + this.selectedMinLabel.getText() + " " + (String)this.period.get()));
    }

    private void goToTime(LocalTime time) {
        int hour = time.getHour();
        this.selectedHourLabel.setText((hour % 12 == 0 ? 12 : hour % 12) + "");
        this.selectedMinLabel.setText(this.unitConverter.toString((Number)time.getMinute()) + "");
        this.period.set((Object)(hour < 12 ? "AM" : "PM"));
        this.minsPointerRotate.setAngle(180.0 + (double)((time.getMinute() + 45) % 60) * Math.toDegrees(0.10471975511965977));
        this.hoursPointerRotate.setAngle(180.0 + Math.toDegrees((double)(2 * (hour - 3)) * Math.PI / 12.0));
    }

    void clearFocus() {
        LocalDate focusDate = (LocalDate)this.datePicker.getValue();
        if (focusDate == null) {
            focusDate = LocalDate.now();
        }
    }

    protected boolean isValidDate(Chronology chrono, LocalDate date, int offset, ChronoUnit unit) {
        if (date != null) {
            return this.isValidDate(chrono, date.plus(offset, unit));
        }
        return false;
    }

    protected boolean isValidDate(Chronology chrono, LocalDate date) {
        try {
            if (date != null) {
                chrono.date(date);
            }
            return true;
        }
        catch (DateTimeException ex) {
            return false;
        }
    }

    private static /* synthetic */ void lambda$createHoursContent$363(Label label, ObservableValue o, String oldVal, String newVal) {
        if (Integer.parseInt(newVal) == Integer.parseInt(label.getText())) {
            label.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
        } else {
            label.setTextFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.87));
        }
    }

    private static /* synthetic */ void lambda$createMinutesContent$362(Label label, ObservableValue o, String oldVal, String newVal) {
        if (Integer.parseInt(newVal) == Integer.parseInt(label.getText())) {
            label.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
        } else {
            label.setTextFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.87));
        }
    }

    private static /* synthetic */ void lambda$createMinutesContent$361(Circle minCircle, ObservableValue o, String oldVal, String newVal) {
        if (Integer.parseInt(newVal) % 5 == 0) {
            minCircle.setVisible(false);
        } else {
            minCircle.setVisible(true);
        }
    }

    private /* synthetic */ void lambda$createContentPane$360(MouseEvent event) {
        int timeValue;
        double dx = event.getX();
        double dy = event.getY();
        double theta = Math.atan2(dy, dx);
        int index = (int)Math.round((180.0 + Math.toDegrees(theta)) / this.angle.get());
        ((Rotate)this.pointerRotate.get()).setAngle((double)index * this.angle.get());
        int n = timeValue = (index + 9) % 12 == 0 ? 12 : (index + 9) % 12;
        if (this.unit.get() == TimeUnit.MINUTES) {
            timeValue = (index + 45) % 60 == 0 ? 0 : (index + 45) % 60;
        }
        ((Label)this.timeLabel.get()).setText(this.unit.get() == TimeUnit.MINUTES ? this.unitConverter.toString((Number)timeValue) : timeValue + "");
        this.updateValue();
    }

    private /* synthetic */ void lambda$createHeaderPane$359(MouseEvent click) {
        this.period.set((Object)"AM");
    }

    private /* synthetic */ void lambda$createHeaderPane$358(MouseEvent click) {
        this.period.set((Object)"PM");
    }

    private /* synthetic */ void lambda$createHeaderPane$357(MouseEvent click) {
        this.unit.set((Object)TimeUnit.MINUTES);
    }

    private /* synthetic */ void lambda$createHeaderPane$356(MouseEvent click) {
        this.unit.set((Object)TimeUnit.HOURS);
    }

    private /* synthetic */ void lambda$new$355(ObservableValue o, String oldVal, String newVal) {
        this.swapLabelsColor(this.periodPMLabel, this.periodAMLabel);
        this.updateValue();
    }

    private /* synthetic */ void lambda$new$354(ObservableValue o, TimeUnit oldVal, TimeUnit newVal) {
        if (newVal == TimeUnit.HOURS) {
            this.angle.set(Math.toDegrees(0.5235987755982988));
            this.pointerRotate.set((Object)this.hoursPointerRotate);
            this.timeLabel.set((Object)this.selectedHourLabel);
        } else if (newVal == TimeUnit.MINUTES) {
            this.angle.set(Math.toDegrees(0.10471975511965977));
            this.pointerRotate.set((Object)this.minsPointerRotate);
            this.timeLabel.set((Object)this.selectedMinLabel);
        }
        this.swapLabelsColor(this.selectedHourLabel, this.selectedMinLabel);
        this.switchTimeUnit(newVal);
    }

    private /* synthetic */ void lambda$new$353(ObservableValue o, LocalTime oldVal, LocalTime newVal) {
        this.goToTime(newVal);
    }

    static /* synthetic */ void access$lambda$0(JFXTimePickerContent jFXTimePickerContent, ObservableValue observableValue, LocalTime localTime, LocalTime localTime2) {
        jFXTimePickerContent.lambda$new$353(observableValue, localTime, localTime2);
    }

    static /* synthetic */ void access$lambda$1(JFXTimePickerContent jFXTimePickerContent, ObservableValue observableValue, TimeUnit timeUnit, TimeUnit timeUnit2) {
        jFXTimePickerContent.lambda$new$354(observableValue, timeUnit, timeUnit2);
    }

    static /* synthetic */ void access$lambda$2(JFXTimePickerContent jFXTimePickerContent, ObservableValue observableValue, String string, String string2) {
        jFXTimePickerContent.lambda$new$355(observableValue, string, string2);
    }

    static /* synthetic */ void access$lambda$3(JFXTimePickerContent jFXTimePickerContent, MouseEvent mouseEvent) {
        jFXTimePickerContent.lambda$createHeaderPane$356(mouseEvent);
    }

    static /* synthetic */ void access$lambda$4(JFXTimePickerContent jFXTimePickerContent, MouseEvent mouseEvent) {
        jFXTimePickerContent.lambda$createHeaderPane$357(mouseEvent);
    }

    static /* synthetic */ void access$lambda$5(JFXTimePickerContent jFXTimePickerContent, MouseEvent mouseEvent) {
        jFXTimePickerContent.lambda$createHeaderPane$358(mouseEvent);
    }

    static /* synthetic */ void access$lambda$6(JFXTimePickerContent jFXTimePickerContent, MouseEvent mouseEvent) {
        jFXTimePickerContent.lambda$createHeaderPane$359(mouseEvent);
    }

    static /* synthetic */ void access$lambda$7(JFXTimePickerContent jFXTimePickerContent, MouseEvent mouseEvent) {
        jFXTimePickerContent.lambda$createContentPane$360(mouseEvent);
    }

    static /* synthetic */ void access$lambda$8(Circle circle, ObservableValue observableValue, String string, String string2) {
        JFXTimePickerContent.lambda$createMinutesContent$361(circle, observableValue, string, string2);
    }

    static /* synthetic */ void access$lambda$9(Label label, ObservableValue observableValue, String string, String string2) {
        JFXTimePickerContent.lambda$createMinutesContent$362(label, observableValue, string, string2);
    }

    static /* synthetic */ void access$lambda$10(Label label, ObservableValue observableValue, String string, String string2) {
        JFXTimePickerContent.lambda$createHoursContent$363(label, observableValue, string, string2);
    }

    private static enum TimeUnit {
        HOURS,
        MINUTES;

    }
}

