/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin.about;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.ui.viewer.AbstractViewerController;

public class PluginAboutController
extends AbstractViewerController {
    @FXML
    private VBox rootVBox;
    @FXML
    private ImageView iconImage;
    @FXML
    private Label name;
    @FXML
    private HBox versionAndAuthorBox;
    @FXML
    private Label version;
    @FXML
    private Label authorText;
    @FXML
    private Hyperlink authorLink;
    @FXML
    private HBox newVersionBox;
    @FXML
    private Hyperlink newVersionLink;

    public void initialize(Parent parent, Object ... objectArray) {
        Object object;
        if (objectArray != null && objectArray.length > 0 && (object = objectArray[0]) instanceof ActlistPlugin) {
            Object object2;
            ActlistPlugin actlistPlugin = (ActlistPlugin)object;
            if (actlistPlugin.existsIcon()) {
                try {
                    this.iconImage.setImage(actlistPlugin.getIcon().getImage());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginName())) {
                this.name.setText(actlistPlugin.getPluginName());
            }
            if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginVersion())) {
                this.version.setText(actlistPlugin.getPluginVersion());
            }
            if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginAuthor())) {
                if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginAuthorURI())) {
                    this.authorLink.setText(actlistPlugin.getPluginAuthor());
                    this.authorLink.setOnAction(actionEvent -> {
                        this.authorLink.setVisited(false);
                        try {
                            Desktop.getDesktop().browse(actlistPlugin.getPluginAuthorURI());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    });
                } else {
                    this.authorText.setText(" by ".concat(actlistPlugin.getPluginAuthor()));
                }
            }
            if ((object2 = objectArray[1]) == null || !(object2 instanceof URI)) {
                this.newVersionBox.setVisible(false);
                VBox vBox = (VBox)this.newVersionBox.getParent();
                vBox.getChildren().remove((Object)this.newVersionBox);
            } else {
                this.newVersionBox.setVisible(true);
                URI uRI = (URI)object2;
                this.newVersionLink.setOnAction(actionEvent -> {
                    this.newVersionLink.setVisited(false);
                    try {
                        Desktop.getDesktop().browse(uRI);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                });
            }
            if (this.haveContentToShow(actlistPlugin)) {
                object2 = this.createContentTabPane();
                this.makeTabIfContentExists((TabPane)object2, "Description", actlistPlugin.getPluginDescriptionURI(), actlistPlugin.getPluginDescription());
                this.makeTabIfContentExists((TabPane)object2, "Change Log", actlistPlugin.getPluginChangeLogURI(), actlistPlugin.getPluginChangeLog());
                this.makeTabIfContentExists((TabPane)object2, "License", actlistPlugin.getPluginLicenseURI(), actlistPlugin.getPluginLicense());
                parent.getScene().getWindow().sizeToScene();
            }
        }
    }

    private boolean haveContentToShow(ActlistPlugin actlistPlugin) {
        boolean bl = false;
        if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginDescriptionURI()) || ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginDescription())) {
            bl = true;
        } else if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginChangeLogURI()) || ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginChangeLog())) {
            bl = true;
        } else if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginLicenseURI()) || ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginLicense())) {
            bl = true;
        }
        return bl;
    }

    private TabPane createContentTabPane() {
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        ScrollPane scrollPane = new ScrollPane((Node)tabPane);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setPrefWidth(330.0);
        scrollPane.setPrefHeight(310.0);
        VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        this.rootVBox.getChildren().add((Object)scrollPane);
        return tabPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeTabIfContentExists(TabPane tabPane, String string, URI uRI, String string2) {
        boolean bl;
        boolean bl2 = bl = ObjectUtil.isNotEmpty((Object)uRI) || ObjectUtil.isNotEmpty((Object)string2);
        if (bl) {
            WebView webView = new WebView();
            BufferedReader bufferedReader = null;
            try {
                if (ObjectUtil.isNotEmpty((Object)uRI)) {
                    if ("jar".equals(uRI.getScheme())) {
                        bufferedReader = new BufferedReader(new InputStreamReader(uRI.toURL().openStream(), Charset.forName("UTF-8")));
                        StringBuffer stringBuffer = new StringBuffer();
                        String string3 = null;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            stringBuffer.append(string3.concat("\r\n"));
                        }
                        webView.getEngine().loadContent(stringBuffer.toString(), "text/plain");
                    } else {
                        webView.getEngine().load(uRI.toString());
                    }
                } else if (ObjectUtil.isNotEmpty((Object)string2)) {
                    webView.getEngine().loadContent(string2, "text/plain");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            tabPane.getTabs().add((Object)new Tab(string, (Node)webView));
        }
    }
}

