/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.core.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.silentsoft.core.exception.ActionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(ActionUtil.class);
    private static final int MAX_THREAD_POOL = 5;

    private static <T> boolean isValidAction(Runnable action) {
        boolean result = true;
        if (action == null) {
            result = false;
        }
        return result;
    }

    private static <T> boolean isNotValidAction(Runnable action) {
        return !ActionUtil.isValidAction(action);
    }

    public static <T> void doAction(Runnable action) throws ActionException, ExecutionException {
        if (ActionUtil.isNotValidAction(action)) {
            throw new ActionException("Action is not valid !");
        }
        ExecutorService executorService = null;
        try {
            executorService = Executors.newFixedThreadPool(5);
            executorService.submit(action).get();
        }
        catch (ExecutionException e) {
            throw new ExecutionException(e);
        }
        catch (Exception e) {
            throw new ActionException(e);
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
            }
        }
    }

    public static <T> boolean doAction(Runnable action, int retryCount) throws ActionException {
        if (retryCount < 0) {
            throw new ActionException("Retry count cannot be negative number !");
        }
        boolean result = true;
        int errorCount = 0;
        boolean workAction = true;
        while (workAction) {
            boolean errorOccur;
            block4: {
                errorOccur = false;
                try {
                    ActionUtil.doAction(action);
                }
                catch (ExecutionException e) {
                    errorOccur = true;
                    if (++errorCount <= retryCount) break block4;
                    result = false;
                    workAction = false;
                    LOGGER.error("Unfortunately, I got catch an error during action with retry for <{}> times.", new Object[]{retryCount, e});
                }
            }
            if (errorOccur) continue;
            result = true;
            workAction = false;
        }
        return result;
    }
}

