/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.configuration;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javax.swing.KeyStroke;
import org.apache.http.conn.util.InetAddressUtils;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventHandler;
import org.silentsoft.ui.viewer.AbstractViewerController;

public class ConfigurationController
extends AbstractViewerController {
    @FXML
    private JFXSlider stageOpacity;
    @FXML
    private JFXTextField showHideActlistHotKey;
    @FXML
    private JFXCheckBox alwaysOnTop;
    private AtomicBoolean hotKeyMakingMode;
    @FXML
    private JFXRadioButton noneProxy;
    @FXML
    private JFXRadioButton automaticProxy;
    @FXML
    private JFXRadioButton manualProxy;
    @FXML
    private JFXComboBox<String> proxyScheme;
    @FXML
    private JFXTextField proxyAddress;
    @FXML
    private JFXTextField proxyPort;
    @FXML
    private JFXCheckBox manualProxyValidator;
    private AtomicBoolean isValidAddress;
    private AtomicBoolean isValidPort;

    public void initialize(Parent parent, Object ... objectArray) {
        String string3;
        this.stageOpacity.setValue(ConfigUtil.getStageOpacity() * 100.0);
        this.showHideActlistHotKey.setText(ConfigUtil.getShowHideActlistHotKeyText());
        this.alwaysOnTop.setSelected(ConfigUtil.isAlwaysOnTop());
        this.hotKeyMakingMode = new AtomicBoolean(false);
        this.stageOpacity.valueProperty().addListener((observableValue, number, number2) -> App.getStage().setOpacity(number2.doubleValue() / 100.0));
        this.stageOpacity.setOnMouseReleased(mouseEvent -> {
            try {
                ConfigUtil.setStageOpacity(this.stageOpacity.getValue() / 100.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.stageOpacity.setOnKeyReleased(keyEvent -> {
            try {
                ConfigUtil.setStageOpacity(this.stageOpacity.getValue() / 100.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.showHideActlistHotKey.setOnKeyPressed(keyEvent -> this.hotKeyMakingMode.set(true));
        this.showHideActlistHotKey.setOnKeyReleased(keyEvent -> {
            try {
                if (this.hotKeyMakingMode.get() && (keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown()) && keyEvent.getCode().getName().length() == 1) {
                    int n = 0;
                    String string = "";
                    if (keyEvent.isControlDown()) {
                        n += 128;
                        string = string.concat("Ctrl + ");
                    }
                    if (keyEvent.isAltDown()) {
                        n += 512;
                        string = string.concat("Alt + ");
                    }
                    if (keyEvent.isShiftDown()) {
                        n += 64;
                        string = string.concat("Shift + ");
                    }
                    if (keyEvent.isMetaDown()) {
                        n += 256;
                        string = SystemUtil.isWindows() ? string.concat("Win + ") : (SystemUtil.isMac() ? string.concat("Cmd + ") : string.concat("Meta + "));
                    }
                    string = string.concat(keyEvent.getCode().getName());
                    ConfigUtil.setShowHideActlistHotKeyModifier(n);
                    ConfigUtil.setShowHideActlistHotKeyCode(keyEvent.getCode().getName().charAt(0));
                    App.getProvider().reset();
                    App.getProvider().register(KeyStroke.getKeyStroke((int)keyEvent.getCode().getName().charAt(0), n), new HotKeyListener(){

                        public void onHotKey(HotKey hotKey) {
                            EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_SHOW_HIDE");
                        }
                    });
                    this.showHideActlistHotKey.setText(string);
                    this.hotKeyMakingMode.set(false);
                    EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_REGISTER_TRAY_ICON");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.proxyScheme.setItems(FXCollections.observableArrayList((Object[])new String[]{"http", "https"}));
        this.proxyScheme.getSelectionModel().select((Object)"http");
        this.proxyScheme.getSelectionModel().selectedItemProperty().addListener((observableValue, string, string2) -> {
            try {
                if (string2 != null && this.proxyAddress.validate() && this.proxyPort.validate()) {
                    this.saveProxy();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.isValidAddress = new AtomicBoolean(false);
        this.proxyAddress.getValidators().add((Object)new ValidatorBase(){
            {
                this.setMessage("Invalid IPv4");
            }

            protected void eval() {
                this.hasErrors.set(true);
                try {
                    String string = ((TextInputControl)this.srcControl.get()).getText();
                    this.hasErrors.set(!InetAddressUtils.isIPv4Address((String)string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.proxyAddress.focusedProperty().addListener((observableValue, bl, bl2) -> {
            try {
                if (!bl2.booleanValue()) {
                    this.isValidAddress.set(this.proxyAddress.validate());
                    if (!this.proxyPort.getText().isEmpty()) {
                        this.isValidPort.set(this.proxyPort.validate());
                    }
                    if (this.isValidAddress.get() && this.isValidPort.get()) {
                        this.saveProxy();
                        this.manualProxyValidator.setSelected(true);
                    } else {
                        this.manualProxyValidator.setSelected(false);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.isValidPort = new AtomicBoolean(false);
        this.proxyPort.getValidators().add((Object)new ValidatorBase(){
            {
                this.setMessage("Invalid");
            }

            protected void eval() {
                this.hasErrors.set(true);
                try {
                    String string = ((TextInputControl)this.srcControl.get()).getText();
                    int n = Integer.parseInt(string);
                    if (n >= 0 && n <= 65535) {
                        this.hasErrors.set(false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.proxyPort.focusedProperty().addListener((observableValue, bl, bl2) -> {
            try {
                if (!bl2.booleanValue()) {
                    this.isValidPort.set(this.proxyPort.validate());
                    if (!this.proxyAddress.getText().isEmpty()) {
                        this.isValidAddress.set(this.proxyAddress.validate());
                    }
                    if (this.isValidAddress.get() && this.isValidPort.get()) {
                        this.saveProxy();
                        this.manualProxyValidator.setSelected(true);
                    } else {
                        this.manualProxyValidator.setSelected(false);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.manualProxyValidator.setSelected(false);
        switch (string3 = ConfigUtil.getProxyMode()) {
            case "NONE": {
                this.noneProxy.setSelected(true);
                break;
            }
            case "AUTOMATIC": {
                this.automaticProxy.setSelected(true);
                break;
            }
            case "MANUAL": {
                this.manualProxy.setSelected(true);
                URI uRI = URI.create(ConfigUtil.getProxyHost());
                this.proxyScheme.getSelectionModel().select((Object)uRI.getScheme());
                this.proxyAddress.setText(uRI.getHost());
                this.proxyPort.setText(String.valueOf(uRI.getPort()));
            }
        }
        this.proxyScheme.setDisable(!"MANUAL".equals(string3));
        this.proxyAddress.setDisable(!"MANUAL".equals(string3));
        this.proxyPort.setDisable(!"MANUAL".equals(string3));
    }

    @FXML
    private void alwaysOnTop() throws Exception {
        ConfigUtil.setAlwaysOnTop(this.alwaysOnTop.selectedProperty().get());
        App.getStage().setAlwaysOnTop(this.alwaysOnTop.selectedProperty().get());
    }

    @FXML
    private void proxy() throws Exception {
        boolean bl = this.manualProxy.selectedProperty().get();
        if (!bl) {
            this.proxyAddress.setText("");
            this.proxyPort.setText("");
            this.isValidAddress.set(false);
            this.isValidPort.set(false);
            this.manualProxyValidator.setSelected(false);
        }
        this.proxyScheme.setDisable(!bl);
        this.proxyAddress.setDisable(!bl);
        this.proxyPort.setDisable(!bl);
        if (this.noneProxy.selectedProperty().get() || this.automaticProxy.selectedProperty().get()) {
            this.saveProxy();
        }
    }

    private void saveProxy() throws Exception {
        if (this.noneProxy.selectedProperty().get()) {
            ConfigUtil.setProxyMode("NONE");
            ConfigUtil.setProxyHost("");
        } else if (this.automaticProxy.selectedProperty().get()) {
            ConfigUtil.setProxyMode("AUTOMATIC");
            ConfigUtil.setProxyHost("");
        } else if (this.manualProxy.selectedProperty().get()) {
            ConfigUtil.setProxyMode("MANUAL");
            ConfigUtil.setProxyHost(String.join((CharSequence)"", (CharSequence)this.proxyScheme.getSelectionModel().getSelectedItem(), "://", this.proxyAddress.getText(), ":", this.proxyPort.getText()));
        }
        EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_UPDATE_PROXY_HOST");
    }
}

