/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXSnackbar$$Lambda$1;
import com.jfoenix.controls.JFXSnackbar$$Lambda$2;
import com.jfoenix.controls.JFXSnackbar$$Lambda$3;
import com.jfoenix.controls.JFXSnackbar$$Lambda$4;
import com.jfoenix.controls.JFXSnackbar$$Lambda$5;
import com.jfoenix.controls.JFXSnackbar$$Lambda$6;
import com.jfoenix.controls.JFXSnackbar$$Lambda$7;
import com.jfoenix.controls.JFXSnackbar$$Lambda$8;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class JFXSnackbar
extends StackPane {
    private Label toast;
    private JFXButton action;
    private Pane snackbarContainer;
    private BorderPane content;
    private Group popup;
    private ChangeListener<? super Number> sizeListener;
    private AtomicBoolean proccessingQueue = new AtomicBoolean(false);
    private ConcurrentLinkedQueue<SnackbarEvent> eventQueue = new ConcurrentLinkedQueue();
    private StackPane actionContainer;

    public JFXSnackbar() {
        this(null);
    }

    public JFXSnackbar(Pane snackbarContainer) {
        BorderPane bpane = new BorderPane();
        this.toast = new Label();
        this.toast.setMinWidth(Double.NEGATIVE_INFINITY);
        this.toast.getStyleClass().add((Object)"jfx-snackbar-toast");
        this.toast.setWrapText(true);
        StackPane toastContainer = new StackPane(new Node[]{this.toast});
        toastContainer.setPadding(new Insets(20.0));
        bpane.setLeft((Node)toastContainer);
        this.action = new JFXButton();
        this.action.setMinWidth(Double.NEGATIVE_INFINITY);
        this.action.setButtonType(JFXButton.ButtonType.FLAT);
        this.action.getStyleClass().add((Object)"jfx-snackbar-action");
        this.actionContainer = new StackPane(new Node[]{this.action});
        this.actionContainer.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        bpane.setRight((Node)this.actionContainer);
        this.toast.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding((Callable)JFXSnackbar$$Lambda$1.lambdaFactory$(this), (Observable[])new Observable[]{this.prefWidthProperty(), this.actionContainer.widthProperty(), this.actionContainer.visibleProperty()}));
        bpane.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        this.content = bpane;
        this.content.getStyleClass().add((Object)"jfx-snackbar-content");
        this.popup = new Group();
        this.popup.getChildren().add((Object)this.content);
        this.popup.setManaged(false);
        this.popup.setVisible(false);
        this.sizeListener = JFXSnackbar$$Lambda$2.lambdaFactory$(this);
        this.registerSnackbarContainer(snackbarContainer);
        this.popup.layoutBoundsProperty().addListener(JFXSnackbar$$Lambda$3.lambdaFactory$(this));
        this.addEventHandler(SnackbarEvent.SNACKBAR, JFXSnackbar$$Lambda$4.lambdaFactory$(this));
        this.setVisible(false);
        this.setManaged(false);
    }

    public Pane getPopupContainer() {
        return this.snackbarContainer;
    }

    public void registerSnackbarContainer(Pane snackbarContainer) {
        if (snackbarContainer != null) {
            if (this.snackbarContainer != null) {
                throw new IllegalArgumentException("Snackbar Container already set");
            }
            this.snackbarContainer = snackbarContainer;
            this.snackbarContainer.getChildren().add((Object)this.popup);
            this.snackbarContainer.heightProperty().addListener(this.sizeListener);
            this.snackbarContainer.widthProperty().addListener(this.sizeListener);
        }
    }

    public void unregisterSnackbarContainer(Pane snackbarContainer) {
        if (snackbarContainer != null) {
            if (this.snackbarContainer == null) {
                throw new IllegalArgumentException("Snackbar Container not set");
            }
            this.snackbarContainer.getChildren().remove((Object)this.popup);
            this.snackbarContainer.heightProperty().removeListener(this.sizeListener);
            this.snackbarContainer.widthProperty().removeListener(this.sizeListener);
            this.snackbarContainer = null;
        }
    }

    public void show(String toastMessage, long timeout) {
        this.show(toastMessage, null, timeout, null);
    }

    public void show(String message, String actionText, long timeout, EventHandler<? super MouseEvent> actionHandler) {
        this.toast.setText(message);
        if (actionText != null && !actionText.isEmpty()) {
            this.action.setVisible(true);
            this.actionContainer.setVisible(true);
            this.actionContainer.setManaged(true);
            this.action.setText("");
            this.action.setText(actionText);
            this.action.setOnMouseClicked(actionHandler);
        } else {
            this.actionContainer.setVisible(false);
            this.actionContainer.setManaged(false);
            this.action.setVisible(false);
        }
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, JFXSnackbar$$Lambda$5.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)this.popup.getLayoutBounds().getHeight(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), JFXSnackbar$$Lambda$6.lambdaFactory$(this), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)350.0), new KeyValue[]{new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)(timeout / 2L)), new KeyValue[0])});
        animation.setAutoReverse(true);
        animation.setCycleCount(2);
        animation.setOnFinished(JFXSnackbar$$Lambda$7.lambdaFactory$(this));
        animation.play();
    }

    public void refreshPopup() {
        Bounds contentBound = this.popup.getLayoutBounds();
        double offsetX = Math.ceil(this.snackbarContainer.getWidth() / 2.0) - Math.ceil(contentBound.getWidth() / 2.0);
        double offsetY = this.snackbarContainer.getHeight() - contentBound.getHeight();
        this.popup.setLayoutX(offsetX);
        this.popup.setLayoutY(offsetY);
    }

    public void enqueue(SnackbarEvent event) {
        this.eventQueue.add(event);
        if (this.proccessingQueue.compareAndSet(false, true)) {
            Platform.runLater((Runnable)JFXSnackbar$$Lambda$8.lambdaFactory$(this));
        }
    }

    private /* synthetic */ void lambda$enqueue$205() {
        SnackbarEvent qevent = this.eventQueue.poll();
        if (qevent != null) {
            this.show(qevent.getMessage(), qevent.getActionText(), qevent.getTimeout(), qevent.getActionHandler());
        }
    }

    private /* synthetic */ void lambda$show$204(ActionEvent e) {
        SnackbarEvent qevent = this.eventQueue.poll();
        if (qevent != null) {
            this.show(qevent.getMessage(), qevent.getActionText(), qevent.getTimeout(), qevent.getActionHandler());
        } else {
            this.proccessingQueue.getAndSet(false);
        }
    }

    private /* synthetic */ void lambda$show$203(ActionEvent e) {
        this.popup.toFront();
    }

    private /* synthetic */ void lambda$show$202(ActionEvent e) {
        this.popup.toBack();
    }

    private /* synthetic */ void lambda$new$201(SnackbarEvent e) {
        this.enqueue(e);
    }

    private /* synthetic */ void lambda$new$200(ObservableValue o, Bounds oldVal, Bounds newVal) {
        this.refreshPopup();
    }

    private /* synthetic */ void lambda$new$199(ObservableValue o, Number oldVal, Number newVal) {
        this.refreshPopup();
    }

    private /* synthetic */ Double lambda$new$198() throws Exception {
        if (this.getPrefWidth() == -1.0) {
            return this.getPrefWidth();
        }
        double actionWidth = this.actionContainer.isVisible() ? this.actionContainer.getWidth() : 0.0;
        return this.prefWidthProperty().get() - actionWidth;
    }

    static /* synthetic */ Double access$lambda$0(JFXSnackbar jFXSnackbar) {
        return jFXSnackbar.lambda$new$198();
    }

    static /* synthetic */ void access$lambda$1(JFXSnackbar jFXSnackbar, ObservableValue observableValue, Number number, Number number2) {
        jFXSnackbar.lambda$new$199(observableValue, number, number2);
    }

    static /* synthetic */ void access$lambda$2(JFXSnackbar jFXSnackbar, ObservableValue observableValue, Bounds bounds, Bounds bounds2) {
        jFXSnackbar.lambda$new$200(observableValue, bounds, bounds2);
    }

    static /* synthetic */ void access$lambda$3(JFXSnackbar jFXSnackbar, SnackbarEvent snackbarEvent) {
        jFXSnackbar.lambda$new$201(snackbarEvent);
    }

    static /* synthetic */ void access$lambda$4(JFXSnackbar jFXSnackbar, ActionEvent actionEvent) {
        jFXSnackbar.lambda$show$202(actionEvent);
    }

    static /* synthetic */ void access$lambda$5(JFXSnackbar jFXSnackbar, ActionEvent actionEvent) {
        jFXSnackbar.lambda$show$203(actionEvent);
    }

    static /* synthetic */ void access$lambda$6(JFXSnackbar jFXSnackbar, ActionEvent actionEvent) {
        jFXSnackbar.lambda$show$204(actionEvent);
    }

    static /* synthetic */ void access$lambda$7(JFXSnackbar jFXSnackbar) {
        jFXSnackbar.lambda$enqueue$205();
    }

    public static class SnackbarEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final String message;
        private final String actionText;
        private final long timeout;
        private final EventHandler<? super MouseEvent> actionHandler;
        public static final EventType<SnackbarEvent> SNACKBAR = new EventType(Event.ANY, "SNACKBAR");

        public String getMessage() {
            return this.message;
        }

        public String getActionText() {
            return this.actionText;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public EventHandler<? super MouseEvent> getActionHandler() {
            return this.actionHandler;
        }

        public SnackbarEvent(String message) {
            this(message, null, 3000L, null);
        }

        public SnackbarEvent(String message, String actionText, long timeout, EventHandler<? super MouseEvent> actionHandler) {
            super(SNACKBAR);
            this.message = message;
            this.actionText = actionText;
            this.timeout = timeout < 1L ? 3000L : timeout;
            this.actionHandler = actionHandler;
        }

        public EventType<? extends SnackbarEvent> getEventType() {
            return super.getEventType();
        }
    }
}

