/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.core.util;

import org.silentsoft.core.util.CSVUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportUtil.class);
    private CSVUtil report = new CSVUtil();
    String[] headers = null;

    public ReportUtil(ReportCase reportCase, String reportPath) {
        switch (reportCase) {
            case BUILD: {
                this.headers = new String[]{ReportContent.fctName.toString(), ReportContent.version.toString(), ReportContent.srcZipPath.toString(), ReportContent.tarZipPath.toString(), ReportContent.ntpPath.toString(), ReportContent.successYn.toString(), ReportContent.errorMsg.toString(), ReportContent.buildTime.toString()};
                break;
            }
            case DEPLOY: {
                this.headers = new String[]{ReportContent.fctName.toString(), ReportContent.hostIp.toString(), ReportContent.version.toString(), ReportContent.masterPath.toString(), ReportContent.backupPath.toString(), ReportContent.backupTime.toString(), ReportContent.srcJsonPath.toString(), ReportContent.srcZipPath.toString(), ReportContent.tarJsonPath.toString(), ReportContent.tarZipPath.toString(), ReportContent.successYn.toString(), ReportContent.errorMsg.toString(), ReportContent.deployTime.toString()};
                break;
            }
            case RECOVERY: {
                this.headers = new String[]{ReportContent.fctName.toString(), ReportContent.hostIp.toString(), ReportContent.backupPath.toString(), ReportContent.masterPath.toString(), ReportContent.successYn.toString(), ReportContent.errorMsg.toString(), ReportContent.recoveryTime.toString()};
                break;
            }
            case TESTRESULT: {
                this.headers = new String[]{ReportContent.fctName.toString(), ReportContent.hostIp.toString(), ReportContent.version.toString(), ReportContent.tarZipPath.toString(), ReportContent.successYn.toString(), ReportContent.errorMsg.toString(), ReportContent.testTime.toString()};
                break;
            }
            case AUTHENTICATE: {
                this.headers = new String[]{ReportContent.hostIp.toString(), ReportContent.tarSecPath.toString(), ReportContent.successYn.toString(), ReportContent.errorMsg.toString(), ReportContent.authenticateTime.toString()};
            }
        }
        this.report.make(reportPath, this.headers);
        this.report.save();
    }

    public boolean write(String[] contents) {
        int nHeaderCnt = this.headers.length;
        int nConentCnt = contents.length;
        if (nHeaderCnt != nConentCnt) {
            LOGGER.error("Report header size<{}> and content size<{}> is mismatch !", new Object[]{nHeaderCnt, nConentCnt});
            return false;
        }
        int nRowIdx = this.report.getDataSet().getRowCount();
        this.report.getDataSet().insertRow(nRowIdx);
        for (int i = 0; i < nHeaderCnt; ++i) {
            this.report.getDataSet().setDataByName(this.headers[i], nRowIdx, (Object)contents[i]);
        }
        this.report.save();
        return true;
    }

    public static enum ReportContent {
        fctName,
        hostIp,
        version,
        masterPath,
        backupPath,
        srcJsonPath,
        srcZipPath,
        tarJsonPath,
        tarZipPath,
        tarSecPath,
        ntpPath,
        successYn,
        errorMsg,
        backupTime,
        buildTime,
        deployTime,
        recoveryTime,
        testTime,
        authenticateTime;

    }

    public static enum ReportCase {
        BUILD,
        DEPLOY,
        RECOVERY,
        TESTRESULT,
        AUTHENTICATE;

    }
}

