/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.ui.component.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class JTextFieldHint
extends BasicTextFieldUI
implements FocusListener {
    private String hint;
    private Color hintColor;

    public JTextFieldHint(String hint) {
        this.hint = "ex.. " + hint;
        this.hintColor = Color.blue;
    }

    public JTextFieldHint(String hint, Color hintColor) {
        this.hint = "ex.. " + hint;
        this.hintColor = hintColor;
    }

    private void repaint() {
        if (this.getComponent() != null) {
            this.getComponent().repaint();
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        super.paintSafely(g);
        JTextComponent component = this.getComponent();
        if (component.getText().length() == 0 && !component.hasFocus()) {
            g.setColor(this.hintColor);
            int padding = (component.getHeight() - component.getFont().getSize()) / 2;
            int inset = 3;
            g.drawString(this.hint, inset, component.getHeight() - padding - inset);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this);
    }
}

