/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.ui.component.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AutoJTextField
extends JTextField {
    private static final long serialVersionUID = -1721385295372597718L;
    private static final String PROPERTY_ADJUST = "PROPERTY_ADJUST";

    private boolean isAdjusting() {
        if (this.getClientProperty(PROPERTY_ADJUST) instanceof Boolean) {
            return (Boolean)this.getClientProperty(PROPERTY_ADJUST);
        }
        return false;
    }

    private void setAdjusting(boolean adjust) {
        this.putClientProperty(PROPERTY_ADJUST, adjust);
    }

    public void setAutoComplete(final ArrayList<String> items, ListCellRenderer<? super String> renderer) {
        final DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        final JComboBox<String> cbInput = new JComboBox<String>(model){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 0);
            }
        };
        this.setAdjusting(false);
        for (String item : items) {
            model.addElement(item);
        }
        cbInput.setSelectedItem(null);
        cbInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AutoJTextField.this.isAdjusting() && cbInput.getSelectedItem() != null) {
                    AutoJTextField.this.setText(cbInput.getSelectedItem().toString());
                }
            }
        });
        if (renderer != null) {
            cbInput.setRenderer(renderer);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AutoJTextField.this.setAdjusting(true);
                if (e.getKeyCode() == 32 && cbInput.isPopupVisible()) {
                    e.setKeyCode(10);
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    e.setSource(cbInput);
                    cbInput.dispatchEvent(e);
                    if (e.getKeyCode() == 10) {
                        AutoJTextField.this.setText(cbInput.getSelectedItem().toString());
                        cbInput.setPopupVisible(false);
                    }
                }
                if (e.getKeyCode() == 27) {
                    cbInput.setPopupVisible(false);
                }
                AutoJTextField.this.setAdjusting(false);
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateList();
            }

            private void updateList() {
                AutoJTextField.this.setAdjusting(true);
                model.removeAllElements();
                String input = AutoJTextField.this.getText();
                if (!input.isEmpty()) {
                    for (String item : items) {
                        if (!item.toLowerCase().startsWith(input.toLowerCase())) continue;
                        model.addElement(item);
                    }
                }
                cbInput.hidePopup();
                cbInput.setPopupVisible(model.getSize() > 0);
                AutoJTextField.this.setAdjusting(false);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)cbInput, "South");
    }
}

