/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import com.jfoenix.controls.JFXHamburger;
import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXToggleButton;
import java.awt.Desktop;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.PopOver;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.comparator.VersionComparator;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.actlist.plugin.PluginConfig;
import org.silentsoft.actlist.plugin.PluginManager;
import org.silentsoft.actlist.plugin.about.PluginAbout;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.actlist.plugin.tray.TrayNotification;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.JSONUtil;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;
import tray.animations.AnimationType;

public class PluginComponent
implements EventListener {
    @FXML
    private AnchorPane root;
    @FXML
    private JFXHamburger hand;
    @FXML
    private HBox pluginLoadingBox;
    @FXML
    private Label lblPluginName;
    @FXML
    private Label warningLabel;
    @FXML
    private Label updateAlarmLabel;
    @FXML
    private JFXToggleButton togActivator;
    @FXML
    private VBox contentLoadingBox;
    @FXML
    private VBox contentBox;
    private String pluginFileName;
    private ActlistPlugin plugin;
    private PopOver popOver;
    private ObservableList<Node> functions;
    private HashMap<TrayNotification, tray.notification.TrayNotification> trayNotifications = new HashMap();
    private boolean isAvailableNewPlugin = false;
    private URI newPluginURI;
    private Stage aboutStage;

    public String getPluginFileName() {
        return this.pluginFileName;
    }

    public void initialize() {
    }

    public void initialize(String string, Class<? extends ActlistPlugin> clazz, boolean bl) {
        this.pluginFileName = string;
        new Thread(() -> {
            AtomicBoolean atomicBoolean = new AtomicBoolean(true);
            try {
                String string2;
                PluginConfig pluginConfig;
                this.makeConsumable();
                this.makeDraggable();
                this.plugin = (ActlistPlugin)clazz.newInstance();
                String string3 = this.plugin.getMinimumCompatibleVersion();
                if (string3 != null && VersionComparator.getInstance().compare("1.2.7", string3) < 0) {
                    atomicBoolean.set(false);
                    String string4 = String.join((CharSequence)"", "This plugin requires at least Actlist ", string3);
                    Runnable runnable = () -> {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirmation");
                        alert.setHeaderText(string4);
                        alert.setContentText("Would you like to check latest Actlist now ?");
                        Optional optional = alert.showAndWait();
                        if (optional.isPresent() && optional.get() == ButtonType.OK) {
                            try {
                                Desktop.getDesktop().browse(new URI("http://silentsoft.org/actlist/archives/"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    this.lblPluginName.setOnMouseClicked(mouseEvent -> runnable.run());
                    this.warningLabel.setOnMouseClicked(mouseEvent -> runnable.run());
                    this.warningLabel.setVisible(true);
                    throw new Exception(string4);
                }
                new Thread(() -> {
                    block11: {
                        try {
                            URI uRI = this.plugin.getPluginUpdateCheckURI();
                            if (uRI == null) break block11;
                            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
                            arrayList.add(new BasicNameValuePair("version", this.plugin.getPluginVersion()));
                            HashMap hashMap = RESTfulAPI.doGet(uRI.toString(), arrayList, HashMap.class);
                            if (hashMap == null) {
                                return;
                            }
                            if (!hashMap.containsKey("available")) break block11;
                            this.isAvailableNewPlugin = Boolean.parseBoolean((String)hashMap.get("available"));
                            if (!this.isAvailableNewPlugin) break block11;
                            if (hashMap.containsKey("url")) {
                                try {
                                    this.newPluginURI = new URI((String)hashMap.get("url"));
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            try {
                                this.plugin.pluginUpdateFound();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            URI uRI2 = this.plugin.getPluginArchivesURI();
                            if (uRI2 != null) {
                                this.newPluginURI = uRI2;
                            }
                            if (this.newPluginURI != null) {
                                this.updateAlarmLabel.setVisible(true);
                            } else {
                                this.updateAlarmLabel.setVisible(false);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }).start();
                HashMap hashMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
                this.plugin.classLoaderObject().set(hashMap.get(string));
                this.plugin.proxyHostObject().set((Object)RESTfulAPI.getProxyHost());
                this.plugin.setPluginConfig(new PluginConfig(string));
                File file = Paths.get(System.getProperty("user.dir"), "plugins", "config", string.concat(".config")).toFile();
                if (file.exists() && (pluginConfig = (PluginConfig)JSONUtil.JSONToObject((String)(string2 = FileUtil.readFile((File)file)), PluginConfig.class)) != null) {
                    this.plugin.setPluginConfig(pluginConfig);
                }
                Platform.runLater(() -> {
                    try {
                        String string2;
                        String string3 = this.plugin.getPluginName();
                        String string4 = this.plugin.getPluginDescription();
                        this.lblPluginName.setText(string3);
                        if (ObjectUtil.isNotEmpty((Object)string4)) {
                            this.lblPluginName.setTooltip(new Tooltip(string4));
                        }
                        if (ObjectUtil.isNotEmpty((Object)(string2 = this.plugin.getWarningText()))) {
                            this.warningLabel.setVisible(true);
                        } else {
                            this.warningLabel.setVisible(false);
                        }
                        this.togActivator.setSelected(bl);
                        this.popOver = new PopOver((Node)new VBox());
                        ((VBox)this.popOver.getContentNode()).setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
                        this.popOver.setArrowLocation(PopOver.ArrowLocation.TOP_LEFT);
                        this.plugin.shouldShowLoadingBar().addListener((observableValue, bl, bl2) -> {
                            if (bl == bl2) {
                                return;
                            }
                            this.displayLoadingBar((boolean)bl2);
                        });
                        this.plugin.exceptionObject().addListener((observableValue, throwable, throwable2) -> {
                            if (throwable2 != null) {
                                this.makeDisable((Throwable)throwable2, true);
                            }
                        });
                        this.plugin.showTrayNotificationObject().addListener((observableValue, trayNotification, trayNotification2) -> {
                            if (trayNotification2 != null) {
                                tray.notification.TrayNotification trayNotification3 = new tray.notification.TrayNotification();
                                HashMap<TrayNotification, tray.notification.TrayNotification> hashMap = this.trayNotifications;
                                synchronized (hashMap) {
                                    this.trayNotifications.put((TrayNotification)trayNotification2, trayNotification3);
                                }
                                trayNotification3.setRectangleFill(Paint.valueOf((String)"#222222"));
                                trayNotification3.setImage(App.getIcons().get(4));
                                trayNotification3.setAnimationType(AnimationType.POPUP);
                                if (trayNotification2.getTitle() == null) {
                                    trayNotification3.setTitle("Actlist message has been arrived.");
                                } else {
                                    trayNotification3.setTitle(trayNotification2.getTitle());
                                }
                                if (trayNotification2.getMessage() == null) {
                                    trayNotification3.setMessage(string3);
                                } else {
                                    trayNotification3.setMessage(trayNotification2.getMessage());
                                }
                                if (trayNotification2.getDuration() == null) {
                                    trayNotification3.setOnDismiss((EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                                        HashMap<TrayNotification, tray.notification.TrayNotification> hashMap = this.trayNotifications;
                                        synchronized (hashMap) {
                                            this.trayNotifications.remove(trayNotification3);
                                        }
                                        org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_BRING_TO_FRONT");
                                    }));
                                    trayNotification3.showAndWait();
                                } else {
                                    trayNotification3.showAndDismiss(trayNotification2.getDuration());
                                }
                            }
                        });
                        this.plugin.dismissTrayNotificationObject().addListener((observableValue, trayNotification, trayNotification2) -> {
                            if (trayNotification2 != null) {
                                HashMap<TrayNotification, tray.notification.TrayNotification> hashMap = this.trayNotifications;
                                synchronized (hashMap) {
                                    if (this.trayNotifications.containsKey(trayNotification2)) {
                                        tray.notification.TrayNotification trayNotification3 = this.trayNotifications.get(trayNotification2);
                                        trayNotification3.setOnDismiss((EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.trayNotifications.remove(trayNotification2)));
                                        trayNotification3.dismiss();
                                    }
                                }
                            }
                        });
                        this.plugin.shouldDismissTrayNotifications().addListener((observableValue, bl, bl2) -> {
                            if (bl2.booleanValue()) {
                                HashMap<TrayNotification, tray.notification.TrayNotification> hashMap = this.trayNotifications;
                                synchronized (hashMap) {
                                    for (Map.Entry<TrayNotification, tray.notification.TrayNotification> entry : this.trayNotifications.entrySet()) {
                                        tray.notification.TrayNotification trayNotification = entry.getValue();
                                        trayNotification.setOnDismiss((EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.trayNotifications.remove(bl2)));
                                        trayNotification.dismiss();
                                    }
                                    this.plugin.shouldDismissTrayNotifications().set(false);
                                }
                            }
                        });
                        this.plugin.shouldBrowseActlistArchives().addListener((observableValue, bl, bl2) -> {
                            if (bl2.booleanValue()) {
                                try {
                                    Desktop.getDesktop().browse(new URI("http://silentsoft.org/actlist/archives/"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        if (this.plugin.existsGraphic()) {
                            this.plugin.getGraphic();
                        }
                        this.plugin.initialize();
                        this.functions = FXCollections.observableArrayList();
                        for (ActlistPlugin.Function function : this.plugin.getFunctionMap().values()) {
                            this.addFunction(function);
                        }
                        if (bl) {
                            this.activated();
                        }
                        org.silentsoft.io.event.EventHandler.addListener((EventListener)this);
                    }
                    catch (Throwable throwable3) {
                        this.lblPluginName.setText(string);
                        this.makeDisable(throwable3, atomicBoolean.get());
                    }
                    finally {
                        this.pluginLoadingBox.setVisible(false);
                    }
                });
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> {
                    this.lblPluginName.setText(string);
                    this.makeDisable(throwable, atomicBoolean.get());
                    this.pluginLoadingBox.setVisible(false);
                });
            }
        }).start();
    }

    void clear() {
        if (this.isActivated()) {
            try {
                this.clearPluginGraphicAndDeactivate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.plugin.classLoaderObject().set(null);
        this.plugin = null;
    }

    private void makeDisable(Throwable throwable, boolean bl) {
        new Thread(() -> {
            if (this.togActivator.selectedProperty().get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Platform.runLater(() -> {
                this.lblPluginName.setCursor(Cursor.HAND);
                if (bl) {
                    Runnable runnable = () -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Exception Dialog");
                        alert.setHeaderText(this.pluginFileName);
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        throwable.printStackTrace(printWriter);
                        String string = stringWriter.toString();
                        TextArea textArea = new TextArea(string);
                        textArea.setEditable(false);
                        textArea.setWrapText(true);
                        textArea.setMaxWidth(Double.MAX_VALUE);
                        textArea.setMaxHeight(Double.MAX_VALUE);
                        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
                        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
                        GridPane gridPane = new GridPane();
                        gridPane.setMaxWidth(Double.MAX_VALUE);
                        gridPane.add((Node)textArea, 0, 0);
                        alert.getDialogPane().setContent((Node)gridPane);
                        alert.showAndWait();
                    };
                    this.lblPluginName.setTooltip(new Tooltip("Click to show the exception log."));
                    this.lblPluginName.setOnMouseClicked(mouseEvent -> runnable.run());
                    this.warningLabel.setOnMouseClicked(mouseEvent -> runnable.run());
                    this.warningLabel.setVisible(true);
                } else {
                    this.lblPluginName.setTooltip(new Tooltip(throwable.getMessage()));
                }
                this.togActivator.setUnToggleLineColor(Paint.valueOf((String)"#da4242"));
                this.togActivator.setDisable(true);
                this.togActivator.setOpacity(1.0);
                this.togActivator.setSelected(false);
                this.clearPluginGraphic();
                org.silentsoft.io.event.EventHandler.removeListener((EventListener)this);
            });
        }).start();
    }

    private void makeConsumable() {
        this.root.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> mouseEvent.consume());
    }

    private void makeDraggable() {
        this.hand.setOnDragDetected(mouseEvent -> {
            this.createSnapshot((MouseEvent)mouseEvent);
            this.root.startFullDrag();
        });
        this.root.addEventFilter(MouseDragEvent.MOUSE_DRAG_ENTERED, mouseDragEvent -> {
            this.root.setStyle("-fx-background-color: #f2f2f2;");
            mouseDragEvent.consume();
        });
        this.root.addEventFilter(MouseDragEvent.MOUSE_DRAG_RELEASED, mouseDragEvent -> {
            this.deleteSnapshot();
            VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
            int n = vBox.getChildren().indexOf(mouseDragEvent.getGestureSource());
            int n2 = vBox.getChildren().indexOf((Object)this.root);
            if (n >= 0 && n2 >= 0) {
                Node node = (Node)vBox.getChildren().remove(n);
                vBox.getChildren().add(n2, (Object)node);
            }
            org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_PRIORITY_OF_PLUGINS");
            mouseDragEvent.consume();
        });
        this.root.addEventFilter(MouseDragEvent.MOUSE_DRAG_EXITED, mouseDragEvent -> {
            this.root.setStyle("-fx-background-color: #ffffff;");
            mouseDragEvent.consume();
        });
        this.hand.setOnMouseReleased(mouseEvent -> this.deleteSnapshot());
    }

    private void createSnapshot(MouseEvent mouseEvent) {
        ImageView imageView = new ImageView((Image)this.root.snapshot(null, null));
        imageView.setManaged(false);
        imageView.setMouseTransparent(true);
        imageView.setEffect((Effect)new DropShadow(3.0, 0.0, 1.5, Color.valueOf((String)"#333333")));
        VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
        vBox.getChildren().add((Object)imageView);
        vBox.setUserData((Object)imageView);
        vBox.setOnMouseDragged(mouseEvent2 -> imageView.relocate(mouseEvent2.getX() - mouseEvent.getX(), mouseEvent2.getY() - mouseEvent.getY()));
    }

    private void deleteSnapshot() {
        VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
        vBox.setOnMouseDragged(null);
        vBox.getChildren().remove(vBox.getUserData());
        vBox.setUserData(null);
    }

    private void addFunction(ActlistPlugin.Function function) {
        this.functions.add((Object)this.createFunctionBox((Node)new Label("", function.graphic), (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            try {
                if (function.action != null) {
                    function.action.run();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.popOver.hide();
            }
        })));
    }

    private HBox createFunctionBox(Node node, EventHandler<? super MouseEvent> eventHandler) {
        HBox hBox = new HBox(new Node[]{node});
        hBox.setAlignment(Pos.CENTER);
        hBox.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        hBox.setStyle("-fx-background-color: white;");
        hBox.setOnMouseEntered(mouseEvent -> hBox.setStyle("-fx-background-color: lightgray;"));
        hBox.setOnMouseExited(mouseEvent -> hBox.setStyle("-fx-background-color: white;"));
        hBox.setOnMouseClicked(eventHandler);
        return hBox;
    }

    private HBox createAboutFunction() {
        return this.createFunctionBox((Node)new Label("About"), (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> this.showAboutStage()));
    }

    @FXML
    private void showAboutStage() {
        HBox hBox;
        if (this.updateAlarmLabel.isVisible() && (hBox = (HBox)this.updateAlarmLabel.getParent()) != null) {
            hBox.getChildren().remove((Object)this.updateAlarmLabel);
        }
        if (this.aboutStage != null) {
            this.aboutStage.close();
            this.aboutStage = null;
        }
        this.aboutStage = new Stage();
        this.aboutStage.initOwner((Window)App.getStage());
        this.aboutStage.initStyle(StageStyle.UTILITY);
        hBox = new BorderPane();
        hBox.setCenter((Node)new PluginAbout(this.plugin, this.newPluginURI).getViewer());
        this.aboutStage.setScene(new Scene((Parent)hBox));
        this.aboutStage.show();
    }

    @FXML
    private void showWarningText() {
        try {
            String string = this.plugin.getWarningText();
            if (ObjectUtil.isNotEmpty((Object)string)) {
                MessageBox.showWarning((Object)App.getStage(), (String)string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private HBox createUpgradeFunction() {
        return this.createFunctionBox((Node)new Label("Upgrade"), (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            HashMap hashMap;
            FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter("Actlist Plugin File", new String[]{"*.jar"});
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Select a new Actlist plugin file to upgrade");
            fileChooser.setInitialDirectory(Paths.get(System.getProperty("user.dir"), "plugins").toFile());
            fileChooser.getExtensionFilters().add((Object)extensionFilter);
            fileChooser.setSelectedExtensionFilter(extensionFilter);
            File file = fileChooser.showOpenDialog((Window)App.getStage());
            if (file == null) {
                return;
            }
            if (!file.getName().equals(this.pluginFileName) && Paths.get(System.getProperty("user.dir"), "plugins", file.getName()).toFile().exists() && (hashMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP")).containsKey(file.getName())) {
                MessageBox.showError((Object)App.getStage(), (String)"The selected file name is already in use by another plugin !");
                return;
            }
            try {
                this.pluginLoadingBox.setVisible(true);
                boolean bl = PluginManager.install(file);
                if (bl) {
                    VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
                    int n = vBox.getChildren().indexOf((Object)this.root);
                    PluginManager.delete(this.pluginFileName);
                    PluginManager.load(file.getName(), true, n);
                    org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_PRIORITY_OF_PLUGINS");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MessageBox.showError((Object)App.getStage(), (String)"Oops... something is weird !");
            }
            finally {
                this.pluginLoadingBox.setVisible(false);
            }
        }));
    }

    private HBox createDeleteFunction() {
        Label label = new Label("Delete");
        label.setTextFill(Paint.valueOf((String)"#db0018"));
        return this.createFunctionBox((Node)label, (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            Optional optional = MessageBox.showConfirm((Object)App.getStage(), (String)"Are you sure you want to delete this plugin ?");
            if (optional.isPresent() && optional.get() == ButtonType.OK) {
                try {
                    PluginManager.delete(this.pluginFileName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    MessageBox.showError((Object)App.getStage(), (String)exception.getMessage());
                }
            }
        }));
    }

    private void displayLoadingBar(final boolean bl) {
        if (this.plugin.existsGraphic()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PluginComponent.this.contentLoadingBox.getChildren().clear();
                    if (bl) {
                        PluginComponent.this.contentLoadingBox.getChildren().add((Object)new JFXSpinner());
                    }
                    PluginComponent.this.contentLoadingBox.setVisible(bl);
                }
            };
            if (Platform.isFxApplicationThread()) {
                runnable.run();
            } else {
                Platform.runLater(() -> runnable.run());
            }
        }
    }

    @FXML
    private void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.SECONDARY && this.popOver != null) {
            ((VBox)this.popOver.getContentNode()).getChildren().clear();
            ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createAboutFunction());
            if (this.isActivated()) {
                if (this.plugin.getFunctionMap().size() > 0) {
                    ((VBox)this.popOver.getContentNode()).getChildren().add((Object)new Separator(Orientation.HORIZONTAL));
                }
                ((VBox)this.popOver.getContentNode()).getChildren().addAll(this.functions);
            }
            this.popOver.show((Node)this.pluginLoadingBox, mouseEvent.getScreenX(), mouseEvent.getScreenY());
        }
    }

    @FXML
    private void toggleOnAction() {
        if (this.isActivated()) {
            this.activated();
        } else {
            this.deactivated();
        }
    }

    private void loadPluginGraphic() {
        try {
            Node node;
            if (this.plugin.existsGraphic() && (node = this.plugin.getGraphic()) != null) {
                this.contentBox.getChildren().add((Object)new BorderPane(node));
                Separator separator = new Separator();
                separator.setPrefWidth(215.0);
                separator.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
                this.contentBox.getChildren().add((Object)separator);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void clearPluginGraphic() {
        this.contentBox.getChildren().clear();
        this.contentLoadingBox.getChildren().clear();
        if (this.popOver != null) {
            this.popOver.hide();
        }
    }

    boolean isActivated() {
        return this.togActivator.selectedProperty().get();
    }

    void clearPluginGraphicAndDeactivate() throws Exception {
        this.clearPluginGraphic();
        this.plugin.pluginDeactivated();
    }

    private void activated() {
        this.displayLoadingBar(true);
        new Thread(() -> Platform.runLater(() -> {
            try {
                this.plugin.pluginActivated();
                this.loadPluginGraphic();
                List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
                list.remove(this.pluginFileName);
                org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_DEACTIVATED_PLUGINS");
            }
            catch (Throwable throwable) {
                this.makeDisable(throwable, true);
            }
            finally {
                this.displayLoadingBar(false);
            }
        })).start();
    }

    private void deactivated() {
        new Thread(() -> Platform.runLater(() -> {
            try {
                List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
                list.add(this.pluginFileName);
                org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_DEACTIVATED_PLUGINS");
                this.clearPluginGraphicAndDeactivate();
            }
            catch (Throwable throwable) {
                this.makeDisable(throwable, true);
            }
        })).start();
    }

    public void onEvent(String string) {
        if (this.isActivated()) {
            try {
                switch (string) {
                    case "EVENT_APPLICATION_ACTIVATED": {
                        this.plugin.applicationActivated();
                        break;
                    }
                    case "EVENT_APPLICATION_DEACTIVATED": {
                        this.plugin.applicationDeactivated();
                        break;
                    }
                    case "EVENT_APPLICATION_CLOSE_REQUESTED": {
                        this.plugin.applicationCloseRequested();
                        break;
                    }
                    case "EVENT_UPDATE_PROXY_HOST": {
                        this.plugin.proxyHostObject().set((Object)RESTfulAPI.getProxyHost());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

