/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.application;

import com.jfoenix.controls.JFXButton;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.PopOver;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.plugin.PluginComponent;
import org.silentsoft.actlist.plugin.PluginManager;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventHandler;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.model.Delta;
import org.silentsoft.ui.model.MaximizeProperty;
import org.silentsoft.ui.util.StageDragResizer;

public class AppController
implements EventListener {
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane head;
    @FXML
    private AnchorPane body;
    @FXML
    private VBox splashBox;
    @FXML
    private Label splashDescription;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private HBox controlBox;
    @FXML
    private Button appMinimizeButton;
    @FXML
    private Button appMaximizeButton;
    @FXML
    private Button appCloseButton;
    @FXML
    private VBox componentBox;
    private MaximizeProperty maximizeProperty;
    private HashMap<String, URLClassLoader> pluginMap;

    protected void initialize() {
        EventHandler.addListener((EventListener)this);
        this.root.setPrefWidth(ConfigUtil.getRootWidth());
        this.root.setPrefHeight(ConfigUtil.getRootHeight());
        this.maximizeProperty = new MaximizeProperty(App.getStage());
        this.pluginMap = new HashMap();
        this.makeDraggable(App.getStage(), (Node)this.head);
        this.makeNormalizable(App.getStage(), (Node)this.head);
        this.makeMinimizable(App.getStage(), (Node)this.appMinimizeButton);
        this.makeMaximizable(App.getStage(), (Node)this.appMaximizeButton);
        this.makeClosable(App.getStage(), (Node)this.appCloseButton);
        this.makeResizable(App.getStage(), (Region)this.root);
        this.checkUpdate();
        SharedMemory.getDataMap().put((Object)"KEY_PLUGIN_MAP", this.pluginMap);
        SharedMemory.getDataMap().put((Object)"KEY_COMPONENT_BOX", (Object)this.componentBox);
        this.hideSplashImage();
        this.loadPlugins();
        this.enableContextMenu();
        this.enableDragAndDrop();
    }

    private void makeDraggable(Stage stage, Node node) {
        Delta delta = new Delta();
        node.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                delta.setX(stage.getX() - mouseEvent.getScreenX());
                delta.setY(stage.getY() - mouseEvent.getScreenY());
                node.setOpacity(0.8);
            }
        });
        node.setOnMouseDragged(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (this.maximizeProperty.isMaximized()) {
                    double d = mouseEvent.getScreenX() - stage.getX();
                    double d2 = mouseEvent.getScreenY() - stage.getY();
                    this.changeMaximizeProperty(stage);
                    stage.setX(d);
                    stage.setY(d2);
                    delta.setX(-1.0 * (stage.getWidth() / 2.0));
                    delta.setY(-1.0 * mouseEvent.getSceneY());
                } else {
                    stage.setX(mouseEvent.getScreenX() + delta.getX());
                    stage.setY(mouseEvent.getScreenY() + delta.getY());
                }
            }
        });
        node.setOnMouseReleased(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                node.setOpacity(1.0);
            }
        });
    }

    private void makeNormalizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getClickCount() >= 2) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeMinimizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                stage.setIconified(true);
            }
        });
    }

    private void makeMaximizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeClosable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                stage.hide();
            }
        });
    }

    private void makeResizable(Stage stage, Region region) {
        StageDragResizer.makeResizable((Stage)stage, (Region)region, (int)7, (int)10, () -> {
            try {
                ConfigUtil.setRootWidth(region.getWidth());
                ConfigUtil.setRootHeight(region.getHeight());
                ConfigUtil.setStageWidth(App.getStage().getWidth());
                ConfigUtil.setStageHeight(App.getStage().getHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void changeMaximizeProperty(Stage stage) {
        this.maximizeProperty.setMaximized(stage, !this.maximizeProperty.isMaximized());
        if (this.maximizeProperty.isMaximized()) {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.head, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.head, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.head, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)25.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)0.0);
        } else {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setLeftAnchor((Node)this.head, (Double)2.0);
            AnchorPane.setRightAnchor((Node)this.head, (Double)2.0);
            AnchorPane.setTopAnchor((Node)this.head, (Double)2.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)27.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)2.0);
        }
    }

    private void checkUpdate() {
        new Thread(() -> {
            try {
                boolean bl = false;
                ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
                arrayList.add(new BasicNameValuePair("version", "1.2.7"));
                arrayList.add(new BasicNameValuePair("os", SystemUtil.getOSName()));
                arrayList.add(new BasicNameValuePair("architecture", SystemUtil.getPlatformArchitecture()));
                HashMap hashMap = RESTfulAPI.doGet("http://silentsoft.org/actlist/update/check", arrayList, HashMap.class);
                if (hashMap == null) {
                    return;
                }
                if (hashMap.containsKey("available")) {
                    bl = Boolean.parseBoolean((String)hashMap.get("available"));
                }
                SharedMemory.getDataMap().put((Object)"KEY_IS_AVAILABLE_NEW_ACTLIST", (Object)bl);
                if (bl) {
                    Platform.runLater(() -> {
                        PopOver popOver = new PopOver();
                        Label label = new Label();
                        label.setCursor(Cursor.HAND);
                        label.setStyle("-fx-background-color: red; -fx-background-radius: 5em;");
                        label.setMinWidth(6.0);
                        label.setMinHeight(6.0);
                        label.setMaxWidth(6.0);
                        label.setMaxHeight(6.0);
                        HBox.setMargin((Node)label, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
                        label.setOnMouseClicked(mouseEvent -> {
                            if (!popOver.isShowing()) {
                                popOver.show((Node)label);
                            }
                        });
                        this.controlBox.getChildren().add(0, (Object)label);
                        Label label2 = new Label("Actlist Update Alarm");
                        label2.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
                        label2.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
                        Label label3 = new Label("New Actlist is available. Would you like to browse now ?");
                        label3.setWrapText(true);
                        label3.setFont(Font.font((String)"Verdana", (double)12.0));
                        label3.setTextAlignment(TextAlignment.CENTER);
                        label3.setPrefWidth(194.0);
                        label3.setPrefHeight(40.0);
                        JFXButton jFXButton = new JFXButton("Not Now");
                        jFXButton.setCursor(Cursor.HAND);
                        jFXButton.setPrefWidth(97.0);
                        jFXButton.setButtonType(JFXButton.ButtonType.RAISED);
                        jFXButton.setRipplerFill(Paint.valueOf((String)"#eeeeee"));
                        jFXButton.setFont(Font.font((String)"Verdana", (double)12.0));
                        jFXButton.setTextFill(Paint.valueOf((String)"#0b7aea"));
                        jFXButton.setOnMouseClicked(mouseEvent -> {
                            label.setOnMouseClicked(null);
                            this.controlBox.getChildren().remove((Object)label);
                            popOver.hide();
                        });
                        JFXButton jFXButton2 = new JFXButton("Browse");
                        jFXButton2.setCursor(Cursor.HAND);
                        jFXButton2.setPrefWidth(97.0);
                        jFXButton2.setButtonType(JFXButton.ButtonType.RAISED);
                        jFXButton2.setRipplerFill(Paint.valueOf((String)"#eeeeee"));
                        jFXButton2.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
                        jFXButton2.setTextFill(Paint.valueOf((String)"#1c81f9"));
                        jFXButton2.setOnMouseClicked(mouseEvent -> {
                            try {
                                Desktop.getDesktop().browse(new URI("http://silentsoft.org/actlist/archives/"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            label.setOnMouseClicked(null);
                            this.controlBox.getChildren().remove((Object)label);
                            popOver.hide();
                        });
                        HBox hBox = new HBox(new Node[]{jFXButton, jFXButton2});
                        hBox.setAlignment(Pos.CENTER);
                        hBox.setStyle("-fx-border-color: lightgray; -fx-border-width: 1 0 0 0;");
                        VBox vBox = new VBox(new Node[]{label2, label3, hBox});
                        vBox.setAlignment(Pos.CENTER);
                        vBox.setStyle("-fx-background-color: white;");
                        vBox.setSpacing(5.0);
                        vBox.setPrefWidth(214.0);
                        vBox.setPrefHeight(103.0);
                        popOver.setContentNode((Node)vBox);
                        popOver.setArrowLocation(PopOver.ArrowLocation.TOP_LEFT);
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
    }

    private void hideSplashImage() {
        new Thread(() -> {
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.splashBox.setVisible(false);
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlugins() {
        AnchorPane anchorPane;
        HBox hBox;
        File file;
        this.componentBox.getChildren().clear();
        try {
            file = Paths.get(System.getProperty("user.dir"), "plugins").toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            hBox = this.readDeactivatedPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_DEACTIVATED_PLUGINS", hBox);
            anchorPane = this.readPriorityOfPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_PRIORITY_OF_PLUGINS", anchorPane);
            ArrayList<String> arrayList = new ArrayList<String>();
            Files.walk(Paths.get(System.getProperty("user.dir"), "plugins"), 1, new FileVisitOption[0]).forEach(path -> {
                if (this.isAssignableFromJarFile((Path)path)) {
                    arrayList.add(path.getFileName().toString());
                }
            });
            for (int i = anchorPane.size() - 1; i >= 0; --i) {
                String string = anchorPane.get(i);
                if (arrayList.contains(string)) {
                    arrayList.remove(string);
                    arrayList.add(0, string);
                    continue;
                }
                anchorPane.remove(i);
            }
            anchorPane.clear();
            anchorPane.addAll(arrayList);
            this.savePriorityOfPlugins();
            for (String string : arrayList) {
                try {
                    Path path2 = Paths.get(System.getProperty("user.dir"), "plugins", string);
                    if (!this.isAssignableFromJarFile(path2)) continue;
                    this.loadPlugin(path2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            if (this.componentBox.getChildren().isEmpty()) {
                Label label = new Label();
                label.setText("No plugins available.");
                HBox hBox2 = new HBox(new Node[]{label});
                hBox2.setAlignment(Pos.CENTER);
                AnchorPane.setTopAnchor((Node)hBox2, (Double)0.0);
                AnchorPane.setRightAnchor((Node)hBox2, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)hBox2, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)hBox2, (Double)0.0);
                AnchorPane anchorPane2 = new AnchorPane(new Node[]{hBox2});
                anchorPane2.setStyle("-fx-background-color: #ffffff;");
                anchorPane2.setPrefWidth(200.0);
                anchorPane2.setPrefHeight(140.0);
                this.componentBox.getChildren().add((Object)anchorPane2);
            }
        }
        catch (Throwable throwable) {
            if (this.componentBox.getChildren().isEmpty()) {
                Label label = new Label();
                label.setText("No plugins available.");
                HBox hBox3 = new HBox(new Node[]{label});
                hBox3.setAlignment(Pos.CENTER);
                AnchorPane.setTopAnchor((Node)hBox3, (Double)0.0);
                AnchorPane.setRightAnchor((Node)hBox3, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)hBox3, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)hBox3, (Double)0.0);
                AnchorPane anchorPane3 = new AnchorPane(new Node[]{hBox3});
                anchorPane3.setStyle("-fx-background-color: #ffffff;");
                anchorPane3.setPrefWidth(200.0);
                anchorPane3.setPrefHeight(140.0);
                this.componentBox.getChildren().add((Object)anchorPane3);
            }
            throw throwable;
        }
        if (this.componentBox.getChildren().isEmpty()) {
            file = new Label();
            file.setText("No plugins available.");
            hBox = new HBox(new Node[]{file});
            hBox.setAlignment(Pos.CENTER);
            AnchorPane.setTopAnchor((Node)hBox, (Double)0.0);
            AnchorPane.setRightAnchor((Node)hBox, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)hBox, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)hBox, (Double)0.0);
            anchorPane = new AnchorPane(new Node[]{hBox});
            anchorPane.setStyle("-fx-background-color: #ffffff;");
            anchorPane.setPrefWidth(200.0);
            anchorPane.setPrefHeight(140.0);
            this.componentBox.getChildren().add((Object)anchorPane);
        }
        App.getStage().showingProperty().addListener((observableValue, bl, bl2) -> {
            if (!bl.booleanValue() && bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_ACTIVATED");
            } else if (bl.booleanValue() && !bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_DEACTIVATED");
            }
        });
        App.getStage().iconifiedProperty().addListener((observableValue, bl, bl2) -> {
            if (!bl.booleanValue() && bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_DEACTIVATED");
            } else if (bl.booleanValue() && !bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_ACTIVATED");
            }
        });
        App.getStage().setOnCloseRequest(windowEvent -> {
            EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_CLOSE_REQUESTED", (boolean)false);
            EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_EXIT");
        });
    }

    private void enableContextMenu() {
        MenuItem menuItem = new MenuItem("Add a new plugin");
        menuItem.setOnAction(actionEvent -> {
            FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter("Actlist Plugin File", new String[]{"*.jar"});
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Select a new Actlist plugin file");
            fileChooser.setInitialDirectory(Paths.get(System.getProperty("user.dir"), "plugins").toFile());
            fileChooser.getExtensionFilters().add((Object)extensionFilter);
            fileChooser.setSelectedExtensionFilter(extensionFilter);
            File file = fileChooser.showOpenDialog((Window)App.getStage());
            if (file == null) {
                return;
            }
            if (this.possibleToInstallThePlugin(file)) {
                this.installAndLoadThePlugin(file);
            }
        });
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{menuItem});
        this.scrollPane.setOnMouseReleased(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                contextMenu.show((Window)App.getStage(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
        });
    }

    private void enableDragAndDrop() {
        Predicate<Dragboard> predicate = dragboard -> {
            File file;
            List list;
            return dragboard.hasFiles() && (list = dragboard.getFiles()).size() == 1 && (file = (File)list.get(0)).isFile() && file.getName().toLowerCase().endsWith(".jar");
        };
        this.scrollPane.setOnDragOver(dragEvent -> {
            if (predicate.test(dragEvent.getDragboard())) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            } else {
                dragEvent.consume();
            }
        });
        this.scrollPane.setOnDragDropped(dragEvent -> {
            File file;
            dragEvent.setDropCompleted(false);
            if (predicate.test(dragEvent.getDragboard()) && this.possibleToInstallThePlugin(file = (File)dragEvent.getDragboard().getFiles().get(0))) {
                this.installAndLoadThePlugin(file);
                dragEvent.setDropCompleted(true);
            }
            dragEvent.consume();
        });
    }

    private boolean possibleToInstallThePlugin(File file) {
        HashMap hashMap;
        boolean bl = true;
        if (Paths.get(System.getProperty("user.dir"), "plugins", file.getName()).toFile().exists() && (hashMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP")).containsKey(file.getName())) {
            bl = false;
            MessageBox.showError((Object)App.getStage(), (String)"The selected file name is already in use by another plugin !");
        }
        return bl;
    }

    private void installAndLoadThePlugin(File file) {
        try {
            boolean bl = PluginManager.install(file);
            if (bl) {
                PluginManager.load(file.getName(), true);
                this.savePriorityOfPlugins();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageBox.showError((Object)App.getStage(), (String)"Oops... something is weird !");
        }
    }

    private boolean isAssignableFromJarFile(Path path) {
        String string;
        String string2;
        File file = path.toFile();
        return file.isFile() && (string2 = file.getName()).contains(".") && ".jar".equalsIgnoreCase(string = string2.substring(string2.lastIndexOf("."), string2.length()));
    }

    private List<String> readDeactivatedPlugins() {
        return FileUtil.readFileByLine((Path)Paths.get(System.getProperty("user.dir"), "plugins", "deactivated.ini"), (boolean)true);
    }

    private void saveDeactivatedPlugins() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
            for (String string : list) {
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
            }
            FileUtil.saveFile((Path)Paths.get(System.getProperty("user.dir"), "plugins", "deactivated.ini"), (String)stringBuffer.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<String> readPriorityOfPlugins() {
        return FileUtil.readFileByLine((Path)Paths.get(System.getProperty("user.dir"), "plugins", "priority.ini"), (boolean)true);
    }

    private void savePriorityOfPlugins() {
        try {
            List<String> list;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.componentBox.getChildren().isEmpty()) {
                list = (List)SharedMemory.getDataMap().get((Object)"KEY_PRIORITY_OF_PLUGINS");
            } else {
                list = new ArrayList();
                for (String string : this.componentBox.getChildrenUnmodifiable()) {
                    list.add(((PluginComponent)string.getUserData()).getPluginFileName());
                }
            }
            for (String string : list) {
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
            }
            FileUtil.saveFile((Path)Paths.get(System.getProperty("user.dir"), "plugins", "priority.ini"), (String)stringBuffer.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadPlugin(Path path) throws Exception {
        String string = path.getFileName().toString();
        List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
        PluginManager.load(string, !list.contains(string));
    }

    public void onEvent(String string) {
        switch (string) {
            case "EVENT_SAVE_DEACTIVATED_PLUGINS": {
                this.saveDeactivatedPlugins();
                break;
            }
            case "EVENT_SAVE_PRIORITY_OF_PLUGINS": {
                this.savePriorityOfPlugins();
            }
        }
    }
}

