/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin.about;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TabPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.ui.viewer.AbstractViewerController;

public class PluginAboutController
extends AbstractViewerController {
    @FXML
    private ImageView iconImage;
    @FXML
    private Label name;
    @FXML
    private HBox versionAndAuthorBox;
    @FXML
    private Label version;
    @FXML
    private Label authorText;
    @FXML
    private Hyperlink authorLink;
    @FXML
    private HBox newVersionBox;
    @FXML
    private Hyperlink newVersionLink;
    @FXML
    private ScrollPane masterPane;
    @FXML
    private TabPane tabPane;
    @FXML
    private WebView descriptionView;
    @FXML
    private WebView changeLogView;
    @FXML
    private WebView licenseView;

    public void initialize(Parent parent, Object ... objectArray) {
        Object object;
        if (objectArray != null && objectArray.length > 0 && (object = objectArray[0]) instanceof ActlistPlugin) {
            Object object2;
            ActlistPlugin actlistPlugin = (ActlistPlugin)object;
            if (actlistPlugin.existsIcon()) {
                try {
                    this.iconImage.setImage(actlistPlugin.getIcon().getImage());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginName())) {
                this.name.setText(actlistPlugin.getPluginName());
            }
            if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginVersion())) {
                this.version.setText(actlistPlugin.getPluginVersion());
            }
            if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginAuthor())) {
                if (ObjectUtil.isNotEmpty((Object)actlistPlugin.getPluginAuthorURI())) {
                    this.authorLink.setText(actlistPlugin.getPluginAuthor());
                    this.authorLink.setOnAction(actionEvent -> {
                        this.authorLink.setVisited(false);
                        try {
                            Desktop.getDesktop().browse(actlistPlugin.getPluginAuthorURI());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    });
                } else {
                    this.authorText.setText(" by ".concat(actlistPlugin.getPluginAuthor()));
                }
            }
            if ((object2 = objectArray[1]) == null || !(object2 instanceof URI)) {
                this.newVersionBox.setVisible(false);
                VBox vBox = (VBox)this.newVersionBox.getParent();
                vBox.getChildren().remove((Object)this.newVersionBox);
            } else {
                this.newVersionBox.setVisible(true);
                URI uRI = (URI)object2;
                this.newVersionLink.setOnAction(actionEvent -> {
                    this.newVersionLink.setVisited(false);
                    try {
                        Desktop.getDesktop().browse(uRI);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                });
            }
            this.setContentToWebView(this.descriptionView, actlistPlugin.getPluginDescriptionURI(), actlistPlugin.getPluginDescription());
            this.setContentToWebView(this.changeLogView, actlistPlugin.getPluginChangeLogURI(), actlistPlugin.getPluginChangeLog());
            this.setContentToWebView(this.licenseView, actlistPlugin.getPluginLicenseURI(), actlistPlugin.getPluginLicense());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContentToWebView(WebView webView, URI uRI, String string) {
        BufferedReader bufferedReader = null;
        try {
            if (ObjectUtil.isNotEmpty((Object)uRI)) {
                if ("jar".equals(uRI.getScheme())) {
                    bufferedReader = new BufferedReader(new InputStreamReader(uRI.toURL().openStream(), Charset.forName("UTF-8")));
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string2.concat("\r\n"));
                    }
                    webView.getEngine().loadContent(stringBuffer.toString(), "text/plain");
                } else {
                    webView.getEngine().load(uRI.toString());
                }
            } else if (ObjectUtil.isNotEmpty((Object)string)) {
                webView.getEngine().loadContent(string, "text/plain");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

