/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.about;

import java.awt.Desktop;
import java.net.URI;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.viewer.AbstractViewerController;

public class AboutController
extends AbstractViewerController {
    @FXML
    private Label version;
    @FXML
    private HBox newVersionBox;
    @FXML
    private Hyperlink archivesLink;
    @FXML
    private Hyperlink sourceCodeLink;
    @FXML
    private Hyperlink licenseLink;
    @FXML
    private Hyperlink changeLogLink;
    @FXML
    private Hyperlink homepageLink;

    public void initialize(Parent parent, Object ... objectArray) {
        this.version.setText("1.2.7");
        boolean bl = (Boolean)SharedMemory.getDataMap().getOrDefault((Object)"KEY_IS_AVAILABLE_NEW_ACTLIST", (Object)false);
        if (bl) {
            this.newVersionBox.setVisible(true);
        } else {
            this.newVersionBox.setVisible(false);
        }
    }

    @FXML
    private void browseHomepage() {
        this.browse(this.homepageLink, "http://silentsoft.org");
    }

    @FXML
    private void browseArchives() {
        this.browse(this.archivesLink, "http://silentsoft.org/actlist/archives/");
    }

    @FXML
    private void browseSourceCode() {
        this.browse(this.sourceCodeLink, "https://github.com/silentsoft/actlist");
    }

    @FXML
    private void browseLicense() {
        this.browse(this.licenseLink, "https://github.com/silentsoft/actlist/blob/master/NOTICE.md");
    }

    @FXML
    private void browseChangeLog() {
        this.browse(this.changeLogLink, "https://github.com/silentsoft/actlist/blob/master/CHANGELOG.md");
    }

    private void browse(Hyperlink hyperlink, String string) {
        hyperlink.setVisited(false);
        try {
            Desktop.getDesktop().browse(URI.create(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

