/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.ui.util;

import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import org.silentsoft.ui.model.Delta;

public abstract class DragResizer {
    private final Region region;
    private final int margin;
    private final Runnable dragDoneAction;
    private Delta delta;
    private boolean isDragging;
    private boolean isDragForEast;
    private boolean isDragForWest;
    private boolean isDragForSouth;
    private boolean isDragForNorth;

    protected DragResizer(Region region) {
        this(region, 0);
    }

    protected DragResizer(Region region, int margin) {
        this(region, margin, null);
    }

    protected DragResizer(Region region, int margin, Runnable dragDoneAction) {
        this.region = region;
        this.margin = margin;
        this.dragDoneAction = dragDoneAction;
        this.delta = new Delta();
        region.addEventFilter(MouseEvent.MOUSE_MOVED, event -> this.mouseMoved((MouseEvent)event));
        region.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> this.mousePressed((MouseEvent)event));
        region.addEventFilter(MouseEvent.MOUSE_DRAGGED, event -> this.mouseDragged((MouseEvent)event));
        region.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> this.mouseReleased((MouseEvent)event));
    }

    protected void mouseMoved(MouseEvent event) {
        if (this.isInDraggableZoneForNorth(event) && this.isInDraggableZoneForWest(event)) {
            this.region.setCursor(Cursor.NW_RESIZE);
        } else if (this.isInDraggableZoneForNorth(event) && this.isInDraggableZoneForEast(event)) {
            this.region.setCursor(Cursor.NE_RESIZE);
        } else if (this.isInDraggableZoneForSouth(event) && this.isInDraggableZoneForEast(event)) {
            this.region.setCursor(Cursor.SE_RESIZE);
        } else if (this.isInDraggableZoneForSouth(event) && this.isInDraggableZoneForWest(event)) {
            this.region.setCursor(Cursor.SW_RESIZE);
        } else if (this.isInDraggableZoneForEast(event)) {
            this.region.setCursor(Cursor.E_RESIZE);
        } else if (this.isInDraggableZoneForWest(event)) {
            this.region.setCursor(Cursor.W_RESIZE);
        } else if (this.isInDraggableZoneForSouth(event)) {
            this.region.setCursor(Cursor.S_RESIZE);
        } else if (this.isInDraggableZoneForNorth(event)) {
            this.region.setCursor(Cursor.N_RESIZE);
        } else {
            this.region.setCursor(Cursor.DEFAULT);
        }
    }

    protected void mousePressed(MouseEvent event) {
        if (!this.isInDraggableZone(event)) {
            return;
        }
        this.isDragging = true;
        this.isDragForEast = this.isInDraggableZoneForEast(event);
        if (this.isDragForEast) {
            this.delta.setWidth(event.getX());
        }
        if (this.isDragForWest = this.isInDraggableZoneForWest(event)) {
            this.delta.setX(event.getScreenX());
        }
        if (this.isDragForSouth = this.isInDraggableZoneForSouth(event)) {
            this.delta.setHeight(event.getY());
        }
        if (this.isDragForNorth = this.isInDraggableZoneForNorth(event)) {
            this.delta.setY(event.getScreenY());
        }
    }

    protected void mouseDragged(MouseEvent event) {
        double size;
        if (!this.isDragging) {
            return;
        }
        if (this.isDragForEast) {
            size = this.region.getPrefWidth() + (event.getX() - this.delta.getWidth());
            if (size > this.region.getMinWidth()) {
                this.delta.setWidth(event.getX());
                this.drag(event, DragMode.WIDTH, this.region.getScene().getWindow().getX(), size);
            } else {
                this.drag(event, DragMode.WIDTH, this.region.getScene().getWindow().getX(), this.region.getMinWidth());
            }
        }
        if (this.isDragForWest) {
            size = this.region.getPrefWidth() + (this.delta.getX() - event.getScreenX());
            if (size > this.region.getMinWidth()) {
                this.delta.setX(event.getScreenX());
                this.drag(event, DragMode.WIDTH, event.getScreenX(), size);
            } else {
                this.drag(event, DragMode.WIDTH, this.region.getScene().getWindow().getX(), this.region.getMinWidth());
            }
        }
        if (this.isDragForSouth) {
            size = this.region.getPrefHeight() + (event.getY() - this.delta.getHeight());
            if (size > this.region.getMinHeight()) {
                this.delta.setHeight(event.getY());
                this.drag(event, DragMode.HEIGHT, this.region.getScene().getWindow().getY(), size);
            } else {
                this.drag(event, DragMode.HEIGHT, this.region.getScene().getWindow().getY(), this.region.getMinHeight());
            }
        }
        if (this.isDragForNorth) {
            size = this.region.getPrefHeight() + (this.delta.getY() - event.getScreenY());
            if (size > this.region.getMinHeight()) {
                this.delta.setY(event.getScreenY());
                this.drag(event, DragMode.HEIGHT, event.getScreenY(), size);
            } else {
                this.drag(event, DragMode.HEIGHT, this.region.getScene().getWindow().getY(), this.region.getMinHeight());
            }
        }
    }

    protected void mouseReleased(MouseEvent event) {
        this.isDragging = false;
        this.region.setCursor(Cursor.DEFAULT);
        if ((this.isDragForEast || this.isDragForWest || this.isDragForSouth || this.isDragForNorth) && this.dragDoneAction != null) {
            this.dragDoneAction.run();
        }
    }

    protected boolean isInDraggableZoneForEast(MouseEvent event) {
        return event.getSceneX() > this.region.getWidth();
    }

    protected boolean isInDraggableZoneForWest(MouseEvent event) {
        return event.getSceneX() - (double)this.margin < 0.0;
    }

    protected boolean isInDraggableZoneForSouth(MouseEvent event) {
        return event.getSceneY() > this.region.getHeight();
    }

    protected boolean isInDraggableZoneForNorth(MouseEvent event) {
        return event.getSceneY() < (double)this.margin;
    }

    protected boolean isInDraggableZone(MouseEvent event) {
        return this.isInDraggableZoneForEast(event) || this.isInDraggableZoneForWest(event) || this.isInDraggableZoneForSouth(event) || this.isInDraggableZoneForNorth(event);
    }

    protected void drag(MouseEvent mouseEvent, DragMode dragMode, double position, double size) {
        switch (dragMode) {
            case WIDTH: {
                this.region.setPrefWidth(size);
                break;
            }
            case HEIGHT: {
                this.region.setPrefHeight(size);
            }
        }
    }

    public static enum DragMode {
        WIDTH,
        HEIGHT;

    }
}

