/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.ui.component.messagebox;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;

public final class MessageBox {
    public static void showAbout(String message) {
        MessageBox.showAbout(null, null, message);
    }

    public static void showAbout(Object owner, String message) {
        MessageBox.showAbout(owner, null, message);
    }

    public static void showAbout(String masthead, String message) {
        MessageBox.showAbout(null, masthead, message);
    }

    public static void showAbout(Object owner, String masthead, String message) {
        String title = "About";
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(title);
        alert.setHeaderText(masthead);
        alert.setContentText(message);
        if (owner != null) {
            alert.initOwner((Window)owner);
        }
        alert.showAndWait();
    }

    public static void showInformation(Object owner, String masthead, String message) {
        String title = "Information";
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(title);
        alert.setHeaderText(masthead);
        alert.setContentText(message);
        if (owner != null) {
            alert.initOwner((Window)owner);
        }
        alert.showAndWait();
    }

    public static Optional<ButtonType> showConfirm(String message) {
        return MessageBox.showConfirm(null, null, message);
    }

    public static Optional<ButtonType> showConfirm(Object owner, String message) {
        return MessageBox.showConfirm(owner, null, message);
    }

    public static Optional<ButtonType> showConfirm(String masthead, String message) {
        return MessageBox.showConfirm(null, masthead, message);
    }

    public static Optional<ButtonType> showConfirm(Object owner, String masthead, String message) {
        String title = "Confirm";
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(title);
        alert.setHeaderText(masthead);
        alert.setContentText(message);
        if (owner != null) {
            alert.initOwner((Window)owner);
        }
        return alert.showAndWait();
    }

    public static void showError(String message) {
        MessageBox.showError(null, null, message);
    }

    public static void showError(Object owner, String message) {
        MessageBox.showError(owner, null, message);
    }

    public static void showError(String masthead, String message) {
        MessageBox.showError(null, masthead, message);
    }

    public static void showError(Object owner, String masthead, String message) {
        String title = "Error";
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setHeaderText(masthead);
        alert.setContentText(message);
        if (owner != null) {
            alert.initOwner((Window)owner);
        }
        alert.showAndWait();
    }

    public static void showException(Throwable exception) {
        MessageBox.showException(null, null, null, exception);
    }

    public static void showException(Object owner, Throwable exception) {
        MessageBox.showException(owner, null, null, exception);
    }

    public static void showException(String message, Throwable exception) {
        MessageBox.showException(null, null, message, exception);
    }

    public static void showException(Object owner, String message, Throwable exception) {
        MessageBox.showException(owner, null, message, exception);
    }

    public static void showException(String masthead, String message, Throwable exception) {
        MessageBox.showException(null, masthead, message, exception);
    }

    public static void showException(Object owner, String masthead, String message, Throwable exception) {
        Platform.runLater(() -> {
            String title = "Exception";
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle(title);
            alert.setHeaderText(masthead);
            alert.setContentText(message);
            if (owner != null) {
                alert.initOwner((Window)owner);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            String exceptionText = sw.toString();
            Label label = new Label("The exception stacktrace was:");
            TextArea textArea = new TextArea(exceptionText);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane expContent = new GridPane();
            expContent.setMaxWidth(Double.MAX_VALUE);
            expContent.add((Node)label, 0, 0);
            expContent.add((Node)textArea, 0, 1);
            alert.getDialogPane().setExpandableContent((Node)expContent);
            alert.showAndWait();
        });
    }
}

