/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.converters.IndicatorPositionConverter;
import com.jfoenix.skins.JFXSliderSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.Slider;
import javafx.util.Callback;

public class JFXSlider
extends Slider {
    private ObjectProperty<Callback<JFXSlider, StringBinding>> valueFactory;
    private static final String DEFAULT_STYLE_CLASS = "jfx-slider";
    private StyleableObjectProperty<IndicatorPosition> indicatorPosition = new SimpleStyleableObjectProperty(StyleableProperties.access$000(), (Object)this, "indicatorPosition", (Object)IndicatorPosition.LEFT);
    private List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public JFXSlider() {
        super(0.0, 100.0, 50.0);
        this.initialize();
    }

    public JFXSlider(double min, double max, double value) {
        super(min, max, value);
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXSliderSkin(this);
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final ObjectProperty<Callback<JFXSlider, StringBinding>> valueFactoryProperty() {
        if (this.valueFactory == null) {
            this.valueFactory = new SimpleObjectProperty((Object)this, "valueFactory");
        }
        return this.valueFactory;
    }

    public final Callback<JFXSlider, StringBinding> getValueFactory() {
        return this.valueFactory == null ? null : (Callback)this.valueFactory.get();
    }

    public final void setValueFactory(Callback<JFXSlider, StringBinding> valueFactory) {
        this.valueFactoryProperty().set(valueFactory);
    }

    public IndicatorPosition getIndicatorPosition() {
        return this.indicatorPosition == null ? IndicatorPosition.LEFT : (IndicatorPosition)((Object)this.indicatorPosition.get());
    }

    public StyleableObjectProperty<IndicatorPosition> indicatorPositionProperty() {
        return this.indicatorPosition;
    }

    public void setIndicatorPosition(IndicatorPosition pos) {
        this.indicatorPosition.set((Object)pos);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        if (this.STYLEABLES == null) {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.addAll(JFXSlider.getClassCssMetaData());
            styleables.addAll(Slider.getClassCssMetaData());
            this.STYLEABLES = Collections.unmodifiableList(styleables);
        }
        return this.STYLEABLES;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXSlider, IndicatorPosition> INDICATOR_POSITION = new CssMetaData<JFXSlider, IndicatorPosition>("-fx-indicator-position", IndicatorPositionConverter.getInstance(), IndicatorPosition.LEFT){

            public boolean isSettable(JFXSlider control) {
                return control.indicatorPosition == null || !control.indicatorPosition.isBound();
            }

            public StyleableProperty<IndicatorPosition> getStyleableProperty(JFXSlider control) {
                return control.indicatorPositionProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return INDICATOR_POSITION;
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, INDICATOR_POSITION);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum IndicatorPosition {
        LEFT,
        RIGHT;

    }
}

