/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.actlist.plugin.PluginComponent;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.io.memory.SharedMemory;

public class PluginManager {
    public static boolean install(File file) throws Exception {
        if (file == null) {
            return false;
        }
        HashMap hashMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
        boolean bl = true;
        if (file.getPath().equals(Paths.get(System.getProperty("user.dir"), "plugins", file.getName()).toString())) {
            if (hashMap.containsKey(file.getName())) {
                MessageBox.showError((Object)App.getStage(), (String)"You can not select an already loaded plugin !");
                return false;
            }
            bl = false;
        }
        URLClassLoader uRLClassLoader = null;
        Class<?> clazz = null;
        boolean bl2 = false;
        try {
            uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});
            clazz = uRLClassLoader.loadClass("Plugin");
            if (!ActlistPlugin.class.isAssignableFrom(clazz)) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = true;
        }
        if (bl2) {
            MessageBox.showError((Object)App.getStage(), (String)"This file is not kind of Actlist plugin !");
            return false;
        }
        Path path = Paths.get(file.toURI());
        Path path2 = Paths.get(System.getProperty("user.dir"), "plugins");
        if (bl) {
            Files.copy(path, path2.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        }
        return true;
    }

    public static void delete(String string) throws Exception {
        PluginManager.unload(string);
        Files.delete(Paths.get(System.getProperty("user.dir"), "plugins", string));
    }

    public static void load(String string, boolean bl) throws Exception {
        PluginManager.load(string, bl, null);
    }

    public static void load(String string, boolean bl, Integer n) throws Exception {
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{Paths.get(System.getProperty("user.dir"), "plugins", string).toUri().toURL()});
        Class<?> clazz = uRLClassLoader.loadClass("Plugin");
        if (ActlistPlugin.class.isAssignableFrom(clazz)) {
            HashMap hashMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
            hashMap.put(string, uRLClassLoader);
            FXMLLoader fXMLLoader = new FXMLLoader(PluginComponent.class.getResource(PluginComponent.class.getSimpleName().concat(".fxml")));
            Node node = (Node)fXMLLoader.load();
            PluginComponent pluginComponent = (PluginComponent)fXMLLoader.getController();
            pluginComponent.initialize(string, clazz, bl);
            node.setUserData((Object)pluginComponent);
            VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
            if (n == null) {
                vBox.getChildren().add((Object)node);
            } else {
                vBox.getChildren().add(n.intValue(), (Object)node);
            }
        }
    }

    public static void unload(String string) throws Exception {
        VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
        int n = vBox.getChildren().size();
        for (int i = 0; i < n; ++i) {
            PluginComponent pluginComponent = (PluginComponent)((Node)vBox.getChildren().get(i)).getUserData();
            if (!pluginComponent.getPluginFileName().equals(string)) continue;
            pluginComponent.clear();
            vBox.getChildren().remove(i);
            HashMap hashMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
            ((URLClassLoader)hashMap.get(string)).close();
            hashMap.remove(string);
            break;
        }
    }
}

