/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public static String readFile(File file) throws IOException {
        return FileUtil.readFile(file.toPath());
    }

    public static String readFile(Path path) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader reader = Files.newBufferedReader(path, CHARSET);
        String line = null;
        while ((line = reader.readLine()) != null) {
            stringBuffer.append(line);
        }
        reader.close();
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileByLine(Path path, boolean trim) {
        ArrayList<String> content = new ArrayList<String>();
        if (Files.isReadable(path)) {
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(path, CHARSET);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    content.add(trim ? line.trim() : line);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return content;
    }

    public static void saveFile(File file, String content) throws IOException {
        FileUtil.saveFile(file.toPath(), content);
    }

    public static void saveFile(Path path, String content) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
        if (Files.isWritable(path)) {
            BufferedWriter writer = Files.newBufferedWriter(path, CHARSET, new OpenOption[0]);
            writer.write(content, 0, content.length());
            writer.close();
        }
    }

    public static void appendFile(String content, File file) throws IOException {
        FileUtil.appendFile(content, file, true);
    }

    public static void appendFile(String content, File file, boolean withNewLine) throws IOException {
        if (withNewLine && file.length() > 0L) {
            content = String.format("%s%s", "\r\n", content);
        }
        FileUtils.writeStringToFile((File)file, (String)content, (boolean)true);
    }

    public static boolean isExists(String fileName) {
        return new File(fileName).exists();
    }

    public static boolean isNotExists(String fileName) {
        return !FileUtil.isExists(fileName);
    }

    public static boolean isValidPath(String path) {
        try {
            Paths.get(path, new String[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isNotValidPath(String path) {
        return !FileUtil.isValidPath(path);
    }

    public static String getName(String fileName) {
        int lastIndexOfSeparator = fileName.lastIndexOf(File.separator);
        int lastIndexOfDot = fileName.lastIndexOf(".");
        lastIndexOfDot = lastIndexOfDot > lastIndexOfSeparator ? lastIndexOfDot : fileName.length();
        return fileName.substring(lastIndexOfSeparator + 1, lastIndexOfDot);
    }

    public static String getExtension(String fileName) {
        int lastIndexOfSeparator = fileName.lastIndexOf(File.separator);
        int lastIndexOfDot = fileName.lastIndexOf(".");
        if (lastIndexOfDot != -1 && lastIndexOfDot > lastIndexOfSeparator) {
            return fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTotalLineNumber(String fileName) {
        int totalLineNumber = -1;
        BufferedReader lineNumberReader = null;
        try {
            lineNumberReader = new LineNumberReader(new FileReader(fileName));
            ((LineNumberReader)lineNumberReader).skip(Long.MAX_VALUE);
            totalLineNumber = ((LineNumberReader)lineNumberReader).getLineNumber() + 1;
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        finally {
            if (lineNumberReader != null) {
                try {
                    lineNumberReader.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.toString());
                }
            }
        }
        return totalLineNumber;
    }

    public static String getContentsByLineNumberFromSOF(String fileName, int lines) {
        return FileUtil.getContentsByLineNumber(fileName, 1, lines);
    }

    public static String getContentsByLineNumberFromEOF(String fileName, int lines) {
        int totalLineNumber = FileUtil.getTotalLineNumber(fileName);
        return FileUtil.getContentsByLineNumber(fileName, totalLineNumber - lines + 1, totalLineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentsByLineNumber(String fileName, int start, int end) {
        StringBuffer stringBuffer = new StringBuffer();
        if (start <= end) {
            BufferedReader lineNumberReader = null;
            try {
                lineNumberReader = new LineNumberReader(new FileReader(fileName));
                String line = null;
                while ((line = ((LineNumberReader)lineNumberReader).readLine()) != null) {
                    int lineNumber = ((LineNumberReader)lineNumberReader).getLineNumber();
                    if (lineNumber >= start && lineNumber <= end) {
                        stringBuffer.append(line);
                        continue;
                    }
                    if (lineNumber <= end) continue;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
            }
            finally {
                if (lineNumberReader != null) {
                    try {
                        lineNumberReader.close();
                    }
                    catch (IOException e) {
                        LOGGER.error(e.toString());
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public static boolean clean(File file, Function<File, Boolean> function) {
        return FileUtil.clean(file, function, true);
    }

    public static boolean clean(File file, final Function<File, Boolean> function, final boolean skipIfDenied) {
        boolean result = true;
        try {
            Files.walkFileTree(Paths.get(file.getPath(), new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                    block3: {
                        File visitedFile = filePath.toFile();
                        if (((Boolean)function.apply(visitedFile)).booleanValue()) {
                            try {
                                visitedFile.delete();
                            }
                            catch (Exception e) {
                                if (skipIfDenied) break block3;
                                throw e;
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path filePath, IOException exc) throws IOException {
                    if (skipIfDenied) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dirPath, IOException exc) throws IOException {
                    File visitedDirectory = dirPath.toFile();
                    if (visitedDirectory.list().length == 0) {
                        visitedDirectory.delete();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            result = false;
        }
        return result;
    }
}

