/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.validation;

import com.jfoenix.validation.ValidationFacade$$Lambda$1;
import com.jfoenix.validation.ValidationFacade$$Lambda$2;
import com.jfoenix.validation.ValidationFacade$$Lambda$3;
import com.jfoenix.validation.ValidationFacade$$Lambda$4;
import com.jfoenix.validation.ValidationFacade$$Lambda$5;
import com.jfoenix.validation.base.ValidatorBase;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class ValidationFacade
extends VBox {
    private Label errorLabel;
    private StackPane errorIcon;
    private HBox errorContainer;
    private double oldErrorLabelHeight = -1.0;
    private double initYlayout = -1.0;
    private double initHeight = -1.0;
    private boolean errorShown = false;
    private double currentFieldHeight = -1.0;
    private double errorLabelInitHeight = 0.0;
    private boolean heightChanged = false;
    private Timeline hideErrorAnimation;
    private ReadOnlyObjectWrapper<ValidatorBase> activeValidator = new ReadOnlyObjectWrapper();
    private ObservableList<ValidatorBase> validators = FXCollections.observableArrayList();
    private ObjectProperty<Control> controlProperty = new SimpleObjectProperty();
    private static final PseudoClass PSEUDO_CLASS_ERROR = PseudoClass.getPseudoClass((String)"error");

    public ValidationFacade() {
        this.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.setSpacing(0.0);
        this.errorLabel = new Label();
        this.errorLabel.getStyleClass().add((Object)"errorLabel");
        this.errorLabel.setWrapText(true);
        this.errorIcon = new StackPane();
        this.errorContainer = new HBox();
        this.errorContainer.getChildren().add((Object)this.errorLabel);
        this.errorContainer.getChildren().add((Object)this.errorIcon);
        HBox.setHgrow((Node)this.errorLabel, (Priority)Priority.ALWAYS);
        this.errorLabel.setMaxWidth(Double.MAX_VALUE);
        this.errorIcon.setTranslateY(3.0);
        this.errorContainer.setSpacing(10.0);
        this.errorContainer.setVisible(false);
        this.errorContainer.setManaged(false);
        this.errorContainer.setOpacity(0.0);
        this.errorLabel.heightProperty().addListener(ValidationFacade$$Lambda$1.lambdaFactory$(this));
        this.errorContainer.visibleProperty().addListener(ValidationFacade$$Lambda$2.lambdaFactory$(this));
        this.activeValidatorProperty().addListener(ValidationFacade$$Lambda$3.lambdaFactory$(this));
    }

    public ValidatorBase getActiveValidator() {
        return this.activeValidator == null ? null : (ValidatorBase)((Object)this.activeValidator.get());
    }

    public ReadOnlyObjectProperty<ValidatorBase> activeValidatorProperty() {
        return this.activeValidator.getReadOnlyProperty();
    }

    public ObservableList<ValidatorBase> getValidators() {
        return this.validators;
    }

    public void setValidators(ValidatorBase ... validators) {
        this.validators.addAll((Object[])validators);
    }

    public static boolean validate(Control control) {
        ValidationFacade facade = (ValidationFacade)control.getParent();
        for (ValidatorBase validator : facade.validators) {
            if (validator.getSrcControl() == null) {
                validator.setSrcControl((Node)facade.controlProperty.get());
            }
            validator.validate();
            if (!validator.getHasErrors()) continue;
            facade.activeValidator.set((Object)validator);
            control.pseudoClassStateChanged(PSEUDO_CLASS_ERROR, true);
            return false;
        }
        control.pseudoClassStateChanged(PSEUDO_CLASS_ERROR, false);
        facade.activeValidator.set(null);
        return true;
    }

    public static void reset(Control control) {
        ValidationFacade facade = (ValidationFacade)control.getParent();
        facade.activeValidator.set(null);
    }

    public Control getControl() {
        return (Control)this.controlProperty.get();
    }

    public void setControl(Control control) {
        this.setMaxWidth(control.getMaxWidth());
        this.prefWidthProperty().bind((ObservableValue)control.prefWidthProperty());
        this.prefHeightProperty().bind((ObservableValue)control.prefHeightProperty());
        this.errorContainer.setMaxWidth(control.getMaxWidth() > -1.0 ? control.getMaxWidth() : control.getPrefWidth());
        this.errorContainer.prefWidthProperty().bind((ObservableValue)control.prefWidthProperty());
        this.errorContainer.prefHeightProperty().bind((ObservableValue)control.prefHeightProperty());
        this.getChildren().clear();
        this.getChildren().add((Object)control);
        this.getChildren().add((Object)this.errorContainer);
        this.controlProperty.set((Object)control);
    }

    private void showError(ValidatorBase validator) {
        this.errorLabel.setText(validator.getMessage());
        Node awsomeIcon = validator.getIcon();
        this.errorIcon.getChildren().clear();
        if (awsomeIcon != null) {
            this.errorIcon.getChildren().add((Object)awsomeIcon);
            StackPane.setAlignment((Node)awsomeIcon, (Pos)Pos.TOP_RIGHT);
        }
        if (this.initYlayout == -1.0) {
            this.initYlayout = this.getBoundsInParent().getMinY();
            this.currentFieldHeight = this.initHeight = this.getHeight();
        }
        this.errorContainer.setManaged(true);
        this.errorContainer.setVisible(true);
        this.errorShown = true;
    }

    private void hideError() {
        if (this.heightChanged) {
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})}).play();
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.minHeightProperty(), (Object)this.initHeight, Interpolator.EASE_BOTH)})}).play();
            this.heightChanged = false;
        }
        this.errorLabel.setText(null);
        this.oldErrorLabelHeight = this.errorLabelInitHeight;
        this.errorIcon.getChildren().clear();
        this.currentFieldHeight = this.initHeight;
        this.errorContainer.setManaged(false);
        this.errorContainer.setVisible(false);
        this.errorShown = false;
    }

    private /* synthetic */ void lambda$new$517(ObservableValue o, ValidatorBase oldVal, ValidatorBase newVal) {
        if (this.hideErrorAnimation != null && this.hideErrorAnimation.getStatus().equals((Object)Animation.Status.RUNNING)) {
            this.hideErrorAnimation.stop();
        }
        if (newVal != null) {
            this.hideErrorAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.errorContainer.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)})});
            this.hideErrorAnimation.setOnFinished(ValidationFacade$$Lambda$4.lambdaFactory$(this, newVal));
            this.hideErrorAnimation.play();
        } else {
            this.hideError();
        }
    }

    private /* synthetic */ void lambda$null$516(ValidatorBase newVal, ActionEvent finish) {
        this.showError(newVal);
    }

    private /* synthetic */ void lambda$new$515(ObservableValue o, Boolean oldVal, Boolean newVal) {
        new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.errorContainer.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}).play();
    }

    private /* synthetic */ void lambda$new$514(ObservableValue o, Number oldVal, Number newVal) {
        if (this.errorShown) {
            if (this.oldErrorLabelHeight == -1.0) {
                this.oldErrorLabelHeight = this.errorLabelInitHeight = oldVal.doubleValue();
            }
            this.heightChanged = true;
            double newHeight = this.getHeight() - this.oldErrorLabelHeight + newVal.doubleValue();
            Timeline errorAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.minHeightProperty(), (Object)this.currentFieldHeight, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)(this.initYlayout + this.getMaxHeight() / 2.0 - newHeight / 2.0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.minHeightProperty(), (Object)newHeight, Interpolator.EASE_BOTH)})});
            errorAnimation.play();
            errorAnimation.setOnFinished(ValidationFacade$$Lambda$5.lambdaFactory$(this));
            this.currentFieldHeight = newHeight;
            this.oldErrorLabelHeight = newVal.doubleValue();
        }
    }

    private /* synthetic */ void lambda$null$513(ActionEvent finish) {
        new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.errorContainer.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}).play();
    }

    static /* synthetic */ void access$lambda$0(ValidationFacade validationFacade, ObservableValue observableValue, Number number, Number number2) {
        validationFacade.lambda$new$514(observableValue, number, number2);
    }

    static /* synthetic */ void access$lambda$1(ValidationFacade validationFacade, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        validationFacade.lambda$new$515(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$2(ValidationFacade validationFacade, ObservableValue observableValue, ValidatorBase validatorBase, ValidatorBase validatorBase2) {
        validationFacade.lambda$new$517(observableValue, validatorBase, validatorBase2);
    }

    static /* synthetic */ void access$lambda$3(ValidationFacade validationFacade, ValidatorBase validatorBase, ActionEvent actionEvent) {
        validationFacade.lambda$null$516(validatorBase, actionEvent);
    }

    static /* synthetic */ void access$lambda$4(ValidationFacade validationFacade, ActionEvent actionEvent) {
        validationFacade.lambda$null$513(actionEvent);
    }
}

