/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.application;

import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.Provider;
import de.codecentric.centerdevice.MenuToolkit;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.Robot;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.silentsoft.actlist.ActlistConfig;
import org.silentsoft.actlist.about.About;
import org.silentsoft.actlist.application.AppController;
import org.silentsoft.actlist.configuration.Configuration;
import org.silentsoft.actlist.console.Console;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.JSONUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.hotkey.HotkeyHandler;
import org.silentsoft.ui.tray.TrayIconHandler;
import org.silentsoft.ui.util.StageUtil;

public class App
extends Application
implements EventListener {
    private static Stage stage;
    private static Parent app;
    private AppController appController;
    private static Provider provider;
    private Stage consoleStage;
    private Stage aboutStage;
    private Stage configurationStage;

    public static void main(String[] stringArray) {
        App.loadConfiguration();
        App.checkSingleInstance();
        App.launch((String[])stringArray);
    }

    public static Stage getStage() {
        Stage stage = StageUtil.getCurrentStage();
        if (stage == null) {
            return App.stage;
        }
        return stage;
    }

    static Parent getParent() {
        return app;
    }

    public static List<javafx.scene.image.Image> getIcons() {
        return new Function<int[], List<javafx.scene.image.Image>>(){

            @Override
            public List<javafx.scene.image.Image> apply(int[] nArray) {
                ArrayList<javafx.scene.image.Image> arrayList = new ArrayList<javafx.scene.image.Image>();
                for (int n : nArray) {
                    arrayList.add(new javafx.scene.image.Image(String.join((CharSequence)"", "/images/icon/actlist_", String.valueOf(n), ".png")));
                }
                return arrayList;
            }
        }.apply(new int[]{24, 32, 48, 64, 128, 256});
    }

    public static Provider getProvider() {
        if (provider == null) {
            provider = Provider.getCurrentProvider((boolean)false);
        }
        return provider;
    }

    public void start(Stage stage) throws Exception {
        App.stage = stage;
        this.initialize();
        stage.setTitle("Actlist");
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setScene(this.createScene());
        stage.setWidth(ConfigUtil.getStageWidth());
        stage.setHeight(ConfigUtil.getStageHeight());
        stage.setOpacity(ConfigUtil.getStageOpacity());
        stage.setAlwaysOnTop(ConfigUtil.isAlwaysOnTop());
        stage.show();
    }

    private void initialize() throws Exception {
        Platform.setImplicitExit((boolean)false);
        StageUtil.registerStage((Stage)stage);
        org.silentsoft.io.event.EventHandler.addListener((EventListener)this);
        this.initConsole();
        this.displayStageIcon();
        this.registerTrayIcon();
        this.registerHotkey();
        this.registerMenu();
        FXMLLoader fXMLLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().concat(".fxml")));
        app = (Parent)fXMLLoader.load();
        this.appController = (AppController)fXMLLoader.getController();
        Platform.runLater(() -> this.appController.initialize());
    }

    private Scene createScene() {
        Scene scene = null;
        if (SystemUtil.isMac()) {
            BorderPane borderPane = new BorderPane();
            borderPane.setStyle("-fx-background-color: transparent;");
            borderPane.setTop((Node)this.createMenuBar());
            borderPane.setCenter((Node)app);
            scene = new Scene((Parent)borderPane, (Paint)Color.TRANSPARENT);
        }
        return scene == null ? new Scene(app, (Paint)Color.TRANSPARENT) : scene;
    }

    private MenuBar createMenuBar() {
        return null;
    }

    private static void loadConfiguration() {
        try {
            ActlistConfig actlistConfig = null;
            File file = Paths.get(System.getProperty("user.dir"), "actlist.jar.config").toFile();
            if (file.exists()) {
                String string = FileUtil.readFile((File)file);
                actlistConfig = (ActlistConfig)JSONUtil.JSONToObject((String)string, ActlistConfig.class);
            } else {
                actlistConfig = new ActlistConfig();
                actlistConfig.put("rootWidth", 380.0);
                actlistConfig.put("rootHeight", 230.0);
                actlistConfig.put("stageWidth", 390.0);
                actlistConfig.put("stageHeight", 240.0);
                actlistConfig.put("stageOpacity", 1.0);
                actlistConfig.put("showHideActlistHotKeyModifier", 640);
                actlistConfig.put("showHideActlistHotKeyCode", 65);
                actlistConfig.put("alwaysOnTop", false);
                actlistConfig.put("proxyMode", "AUTOMATIC");
                actlistConfig.put("proxyHost", "");
            }
            SharedMemory.getDataMap().put((Object)"KEY_ACTLIST_CONFIG", (Object)actlistConfig);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void checkSingleInstance() {
        String string = "Actlist";
        if (SystemUtil.isWindows()) {
            string = string + ".exe";
        }
        if (SystemUtil.findProcessByImageName((String)string, (String)SystemUtil.getCurrentProcessId())) {
            try {
                Robot robot = new Robot();
                int n = ConfigUtil.getShowHideActlistHotKeyCode();
                int n2 = ConfigUtil.getShowHideActlistHotKeyModifier();
                if ((n2 & 0x80) == 128) {
                    robot.keyPress(17);
                }
                if ((n2 & 0x200) == 512) {
                    robot.keyPress(18);
                }
                if ((n2 & 0x40) == 64) {
                    robot.keyPress(16);
                }
                if ((n2 & 0x100) == 256) {
                    robot.keyPress(524);
                }
                robot.keyPress(n);
                if ((n2 & 0x80) == 128) {
                    robot.keyRelease(17);
                }
                if ((n2 & 0x200) == 512) {
                    robot.keyRelease(18);
                }
                if ((n2 & 0x40) == 64) {
                    robot.keyRelease(16);
                }
                if ((n2 & 0x100) == 256) {
                    robot.keyRelease(524);
                }
                robot.keyRelease(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private void initConsole() throws Exception {
        if (this.consoleStage == null) {
            this.consoleStage = new Stage();
            this.consoleStage.setTitle("Console");
            this.consoleStage.initOwner((Window)App.getStage());
            this.consoleStage.initStyle(StageStyle.TRANSPARENT);
            FXMLLoader fXMLLoader = new FXMLLoader(Console.class.getResource(Console.class.getSimpleName().concat(".fxml")));
            Parent parent = (Parent)fXMLLoader.load();
            Console console = (Console)fXMLLoader.getController();
            console.initialize(this.consoleStage);
            System.setOut(console.getPrintStream());
            System.setErr(console.getPrintStream());
            BorderPane borderPane = new BorderPane();
            borderPane.setStyle("-fx-background-color: transparent;");
            borderPane.setTop((Node)this.createMenuBar());
            borderPane.setCenter((Node)parent);
            this.consoleStage.setScene(new Scene((Parent)borderPane, (Paint)Color.TRANSPARENT));
            this.consoleStage.setWidth(400.0);
            this.consoleStage.setHeight(500.0);
            this.consoleStage.getIcons().addAll(App.getIcons());
        }
    }

    private void displayStageIcon() {
        stage.getIcons().addAll(App.getIcons());
    }

    private void registerTrayIcon() {
        if (SystemUtil.isMac()) {
            TrayIconHandler.registerTrayIcon((Image)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/icon/actlist_64.png")).getImage(), (String)"Actlist", actionEvent -> this.showOrHide());
        } else {
            TrayIconHandler.registerTrayIcon((Image)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/icon/actlist_16.png")).getImage(), (String)"Actlist", actionEvent -> this.showOrHide());
        }
        TrayIconHandler.addItem((String)String.join((CharSequence)"", "Show/Hide ", "(", ConfigUtil.getShowHideActlistHotKeyText().replaceAll(" ", ""), ")"), actionEvent -> this.showOrHide());
        TrayIconHandler.addItem((String)"Console", actionEvent -> this.showConsole());
        TrayIconHandler.addItem((String)"Configuration", actionEvent -> this.showConfiguration());
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Open plugins directory", actionEvent -> {
            try {
                File file = Paths.get(System.getProperty("user.dir"), "plugins").toFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                Desktop.getDesktop().open(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Browse silentsoft.org", actionEvent -> {
            try {
                Desktop.getDesktop().browse(new URI("http://silentsoft.org"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        TrayIconHandler.addItem((String)"About", actionEvent -> Platform.runLater(() -> this.showAbout()));
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Exit", actionEvent -> this.exit());
    }

    private void registerHotkey() throws Exception {
        App.getProvider().register(KeyStroke.getKeyStroke(ConfigUtil.getShowHideActlistHotKeyCode(), ConfigUtil.getShowHideActlistHotKeyModifier()), new HotKeyListener(){

            public void onHotKey(HotKey hotKey) {
                App.this.showOrHide();
            }
        });
        HotkeyHandler.getInstance().registerHotkey(KeyCode.ESCAPE, false, false, false, () -> this.showOrHide());
        stage.addEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)HotkeyHandler.getInstance());
    }

    private void registerMenu() {
        if (SystemUtil.isMac()) {
            String string = "Actlist";
            MenuToolkit menuToolkit = MenuToolkit.toolkit();
            MenuItem menuItem = new MenuItem("About " + string);
            menuItem.setOnAction(actionEvent -> this.showAbout());
            MenuItem menuItem2 = new MenuItem("Preferences");
            menuItem2.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
            menuItem2.setOnAction(actionEvent -> this.showConfiguration());
            Menu menu = new Menu(string, null, new MenuItem[]{menuItem, new SeparatorMenuItem(), menuItem2, new SeparatorMenuItem(), menuToolkit.createHideMenuItem(string), menuToolkit.createHideOthersMenuItem(), menuToolkit.createUnhideAllMenuItem(), new SeparatorMenuItem(), menuToolkit.createQuitMenuItem(string)});
            menuToolkit.setApplicationMenu(menu);
            Menu menu2 = new Menu("File");
            menu2.getItems().addAll((Object[])new MenuItem[]{menuToolkit.createCloseWindowMenuItem()});
            Menu menu3 = new Menu("Edit");
            Menu menu4 = new Menu("View");
            Menu menu5 = new Menu("Window", null, new MenuItem[]{menuToolkit.createMinimizeMenuItem(), menuToolkit.createZoomMenuItem(), menuToolkit.createCycleWindowsItem(), new SeparatorMenuItem(), menuToolkit.createBringAllToFrontItem()});
            menuToolkit.autoAddWindowMenuItems(menu5);
            Menu menu6 = new Menu("Help");
            menuToolkit.setGlobalMenuBar(new MenuBar(new Menu[]{menu, menu2, menu3, menu4, menu5, menu6}));
        }
    }

    private void showOrHide() {
        if (stage.isIconified()) {
            Platform.runLater(() -> stage.setIconified(false));
        } else if (stage.isShowing()) {
            if (stage.isFocused()) {
                Platform.runLater(() -> stage.hide());
            } else {
                Platform.runLater(() -> stage.requestFocus());
            }
        } else {
            Platform.runLater(() -> stage.show());
        }
    }

    private void bringToFront() {
        if (stage.isIconified() || !stage.isShowing() || stage.isShowing() && !stage.isFocused()) {
            this.showOrHide();
        }
    }

    private void showAbout() {
        Platform.runLater(() -> {
            if (this.aboutStage == null) {
                this.aboutStage = new Stage();
                this.aboutStage.initOwner((Window)App.getStage());
                this.aboutStage.initStyle(StageStyle.UTILITY);
                this.aboutStage.setResizable(false);
                BorderPane borderPane = new BorderPane();
                borderPane.setTop((Node)this.createMenuBar());
                borderPane.setCenter((Node)new About().getViewer());
                this.aboutStage.setScene(new Scene((Parent)borderPane));
            }
            this.aboutStage.show();
        });
    }

    private void showConsole() {
        Platform.runLater(() -> this.consoleStage.show());
    }

    private void showConfiguration() {
        Platform.runLater(() -> {
            if (this.configurationStage == null) {
                this.configurationStage = new Stage();
                this.configurationStage.initOwner((Window)App.getStage());
                this.configurationStage.setTitle("Actlist Configuration");
                this.configurationStage.setResizable(false);
                BorderPane borderPane = new BorderPane();
                borderPane.setTop((Node)this.createMenuBar());
                borderPane.setCenter((Node)new Configuration().getViewer());
                this.configurationStage.setScene(new Scene((Parent)borderPane));
                this.configurationStage.getIcons().addAll(App.getIcons());
            }
            this.configurationStage.show();
        });
    }

    private void exit() {
        App.getProvider().reset();
        App.getProvider().stop();
        System.exit(0);
    }

    public void onEvent(String string) {
        switch (string) {
            case "EVENT_REGISTER_TRAY_ICON": {
                this.registerTrayIcon();
                break;
            }
            case "EVENT_APPLICATION_SHOW_HIDE": {
                this.showOrHide();
                break;
            }
            case "EVENT_APPLICATION_BRING_TO_FRONT": {
                this.bringToFront();
                break;
            }
            case "EVENT_APPLICATION_EXIT": {
                this.exit();
            }
        }
    }
}

