/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.util;

import org.silentsoft.actlist.ActlistConfig;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.memory.SharedMemory;

public class ConfigUtil {
    public static ActlistConfig getActlistConfig() {
        return (ActlistConfig)SharedMemory.getDataMap().get((Object)"KEY_ACTLIST_CONFIG");
    }

    public static double getRootWidth() {
        Object t = ConfigUtil.getActlistConfig().get("rootWidth");
        if (t instanceof Integer) {
            return (double)((Integer)t).intValue() + 0.0;
        }
        return (Double)t;
    }

    public static void setRootWidth(double d) throws Exception {
        ConfigUtil.getActlistConfig().put("rootWidth", d);
    }

    public static double getRootHeight() {
        Object t = ConfigUtil.getActlistConfig().get("rootHeight");
        if (t instanceof Integer) {
            return (double)((Integer)t).intValue() + 0.0;
        }
        return (Double)t;
    }

    public static void setRootHeight(double d) throws Exception {
        ConfigUtil.getActlistConfig().put("rootHeight", d);
    }

    public static double getStageWidth() {
        Object t = ConfigUtil.getActlistConfig().get("stageWidth");
        if (t instanceof Integer) {
            return (double)((Integer)t).intValue() + 0.0;
        }
        return (Double)t;
    }

    public static void setStageWidth(double d) throws Exception {
        ConfigUtil.getActlistConfig().put("stageWidth", d);
    }

    public static double getStageHeight() {
        Object t = ConfigUtil.getActlistConfig().get("stageHeight");
        if (t instanceof Integer) {
            return (double)((Integer)t).intValue() + 0.0;
        }
        return (Double)t;
    }

    public static void setStageHeight(double d) throws Exception {
        ConfigUtil.getActlistConfig().put("stageHeight", d);
    }

    public static double getStageOpacity() {
        Object t = ConfigUtil.getActlistConfig().get("stageOpacity");
        if (t instanceof Integer) {
            return (double)((Integer)t).intValue() + 0.0;
        }
        return (Double)t;
    }

    public static void setStageOpacity(double d) throws Exception {
        ConfigUtil.getActlistConfig().put("stageOpacity", d);
    }

    public static boolean isAlwaysOnTop() {
        return (Boolean)ConfigUtil.getActlistConfig().get("alwaysOnTop");
    }

    public static void setAlwaysOnTop(boolean bl) throws Exception {
        ConfigUtil.getActlistConfig().put("alwaysOnTop", bl);
    }

    public static int getShowHideActlistHotKeyModifier() {
        return (Integer)ConfigUtil.getActlistConfig().get("showHideActlistHotKeyModifier");
    }

    public static void setShowHideActlistHotKeyModifier(int n) throws Exception {
        ConfigUtil.getActlistConfig().put("showHideActlistHotKeyModifier", n);
    }

    public static int getShowHideActlistHotKeyCode() {
        return (Integer)ConfigUtil.getActlistConfig().get("showHideActlistHotKeyCode");
    }

    public static void setShowHideActlistHotKeyCode(int n) throws Exception {
        ConfigUtil.getActlistConfig().put("showHideActlistHotKeyCode", n);
    }

    public static String getShowHideActlistHotKeyText() {
        String string = "";
        int n = ConfigUtil.getShowHideActlistHotKeyModifier();
        if ((n & 0x80) == 128) {
            string = string.concat("Ctrl + ");
        }
        if ((n & 0x200) == 512) {
            string = string.concat("Alt + ");
        }
        if ((n & 0x40) == 64) {
            string = string.concat("Shift + ");
        }
        if ((n & 0x100) == 256) {
            string = SystemUtil.isWindows() ? string.concat("Win + ") : (SystemUtil.isMac() ? string.concat("Cmd + ") : string.concat("Meta + "));
        }
        return string.concat(String.valueOf((char)ConfigUtil.getShowHideActlistHotKeyCode()));
    }

    public static String getProxyMode() {
        return (String)ConfigUtil.getActlistConfig().get("proxyMode");
    }

    public static void setProxyMode(String string) throws Exception {
        ConfigUtil.getActlistConfig().put("proxyMode", string);
    }

    public static String getProxyHost() {
        return (String)ConfigUtil.getActlistConfig().get("proxyHost");
    }

    public static void setProxyHost(String string) throws Exception {
        ConfigUtil.getActlistConfig().put("proxyHost", string);
    }

    public class ProxyMode {
        public static final String NONE = "NONE";
        public static final String AUTOMATIC = "AUTOMATIC";
        public static final String MANUAL = "MANUAL";
    }
}

