/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.net.push.pushbullet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.message.BasicHeader;
import org.silentsoft.net.push.pushbullet.Device;
import org.silentsoft.net.push.pushbullet.Devices;
import org.silentsoft.net.push.pushbullet.Push;
import org.silentsoft.net.push.pushbullet.UserInfo;
import org.silentsoft.net.rest.RESTfulAPI;

public class PushbulletAPI
extends RESTfulAPI {
    static {
        PushbulletAPI.init("https://api.pushbullet.com", "/v2");
    }

    public static UserInfo getUserInfo(String accessToken) throws Exception {
        return PushbulletAPI.doGet("/users/me", UserInfo.class, (HttpRequest request) -> request.setHeader((Header)new BasicHeader("Access-Token", accessToken)));
    }

    public static List<Device> getDevices(String accessToken) throws Exception {
        Devices devices = PushbulletAPI.doGet("/devices", Devices.class, (HttpRequest request) -> request.setHeader((Header)new BasicHeader("Access-Token", accessToken)));
        return devices == null ? null : devices.getDevices();
    }

    public static Push sendNote(String accessToken, TargetType type, String target, String title, String body) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("type", "note");
        param.put(type.name(), target);
        param.put("title", title);
        param.put("body", body);
        return PushbulletAPI.doPost("/pushes", (Object)new ObjectMapper().writeValueAsString(param), Push.class, (HttpRequest request) -> request.setHeader((Header)new BasicHeader("Access-Token", accessToken)));
    }

    public static enum TargetType {
        device_iden,
        client_iden,
        channel_tag,
        email;

    }
}

